/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.image;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Random;

public abstract class CaptchaImageUtil {
    private static final String range = "0123456789abcdefghjkmnpqrstuvwxyzABCDEFGHJKMNPQRSRUVWXYZ";
    public static final String SESSIONCHECKCODE = "session_checkcode";
    public static final String REQUESTCHECKCODE = "j_checkcode";

    public static String getRandomString(int len) {
        Random random = new Random();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            result.append(range.charAt(random.nextInt(range.length())));
        }
        return result.toString();
    }

    public static String getRandomString() {
        return CaptchaImageUtil.getRandomString(4);
    }

    public static boolean checkcodeMatch(String session_checkcode, String request_checkcode) {
        if (request_checkcode == null || session_checkcode == null || "".equals(request_checkcode)) {
            return false;
        }
        return session_checkcode.equalsIgnoreCase(request_checkcode.replaceAll("O", "0").replaceAll("o", "0").replaceAll("I", "1").replaceAll("i", "1").replaceAll("L", "1").replaceAll("l", "1"));
    }

    public static BufferedImage generateCaptchaImage(String captchaKey) {
        int width = 10 + 13 * captchaKey.length();
        int height = 22;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g = image.createGraphics();
        g.setColor(CaptchaImageUtil.getRandColor(180, 250));
        g.fillRect(0, 0, width, height);
        g.setFont(new Font("Times New Roman", 0, 21));
        g.setColor(new Color(0, 0, 0));
        Random rand = new Random();
        for (int i = 0; i < captchaKey.length(); ++i) {
            ((Graphics)g).drawString(captchaKey.substring(i, i + 1), 13 * i + 6 + rand.nextInt(5), 14 + rand.nextInt(6));
        }
        g.dispose();
        return image;
    }

    public static Color getRandColor(int fc, int bc) {
        Random random = new Random();
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }
}

