/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.network;

import com.alibaba.fastjson.JSON;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.file.FileSystemOpt;
import com.centit.support.json.JSONOpt;
import com.centit.support.network.InputStreamResponseHandler;
import com.centit.support.network.Utf8ResponseHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpExecutor {
    protected static final Logger logger = LoggerFactory.getLogger(HttpExecutor.class);
    public static final ContentType APPLICATION_FORM_URLENCODED = ContentType.create((String)"application/x-www-form-urlencoded", (Charset)Consts.UTF_8);
    public static final String BOUNDARY = "------1cC9oE7dN8eT1fI0aT2n4------";
    public static final String multiPartTypeHead = "multipart/form-data; charset=UTF-8; boundary=------1cC9oE7dN8eT1fI0aT2n4------";
    public static final String applicationFormHead = "application/x-www-form-urlencoded; charset=UTF-8";
    public static final String multiPartApplicationFormHead = "multipart/x-www-form-urlencoded; charset=UTF-8; boundary=------1cC9oE7dN8eT1fI0aT2n4------";
    public static final String applicationJSONHead = ContentType.create((String)"application/json", (Charset)Consts.UTF_8).toString();
    public static final String plainTextHead = ContentType.create((String)"text/plain", (Charset)Consts.UTF_8).toString();
    public static final String xmlTextHead = ContentType.create((String)"text/xml", (Charset)Consts.UTF_8).toString();
    public static final String applicationOctetStream = ContentType.create((String)"application/octet-stream", (Charset)null).toString();
    private static TrustManager manager = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };

    public static CloseableHttpClient createHttpClient(HttpHost httpProxy, boolean keepSession, boolean useSSL) throws NoSuchAlgorithmException, KeyManagementException {
        HttpClientBuilder clientBuilder = HttpClients.custom();
        if (useSSL) {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{manager}, null);
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(context, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)socketFactory).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        }
        if (keepSession) {
            RequestConfig config = RequestConfig.custom().setCookieSpec("netscape").build();
            clientBuilder.setDefaultRequestConfig(config);
        }
        if (httpProxy != null) {
            clientBuilder.setProxy(httpProxy);
        }
        return clientBuilder.build();
    }

    public static CloseableHttpClient createHttpClient() {
        return HttpClients.createDefault();
    }

    public static CloseableHttpClient createHttpClient(HttpHost httpProxy) {
        return HttpClients.custom().setProxy(httpProxy).build();
    }

    public static CloseableHttpClient createKeepSessionHttpClient() {
        RequestConfig config = RequestConfig.custom().setCookieSpec("netscape").build();
        return HttpClients.custom().setDefaultRequestConfig(config).build();
    }

    public static CloseableHttpClient createKeepSessionHttpClient(HttpHost httpProxy) {
        RequestConfig config = RequestConfig.custom().setCookieSpec("netscape").build();
        return HttpClients.custom().setDefaultRequestConfig(config).setProxy(httpProxy).build();
    }

    public static CloseableHttpClient createHttpsClient() throws NoSuchAlgorithmException, KeyManagementException {
        return HttpExecutor.createHttpClient(null, false, true);
    }

    public static CloseableHttpClient createKeepSessionHttpsClient() throws NoSuchAlgorithmException, KeyManagementException {
        return HttpExecutor.createHttpClient(null, true, true);
    }

    public static String httpExecute(CloseableHttpClient httpclient, HttpContext context, HttpRequestBase httpRequest, HttpHost httpProxy) throws IOException {
        if (httpProxy != null) {
            RequestConfig config = RequestConfig.custom().setProxy(httpProxy).build();
            httpRequest.setConfig(config);
        }
        try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpRequest, context);){
            String responseContent;
            String string = responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
            return string;
        }
    }

    public static String httpExecute(CloseableHttpClient httpclient, HttpContext context, HttpRequestBase httpRequest) throws IOException {
        return HttpExecutor.httpExecute(httpclient, context, httpRequest, null);
    }

    public static String httpExecute(CloseableHttpClient httpclient, HttpRequestBase httpRequest, HttpHost httpProxy) throws IOException {
        return HttpExecutor.httpExecute(httpclient, null, httpRequest, httpProxy);
    }

    public static String httpExecute(CloseableHttpClient httpclient, HttpRequestBase httpRequest) throws IOException {
        return HttpExecutor.httpExecute(httpclient, null, httpRequest, null);
    }

    public static String appendParamToUrl(String uri, String queryParam) {
        if (queryParam == null || "".equals(queryParam)) {
            return uri;
        }
        return uri.endsWith("?") || uri.endsWith("&") ? uri + queryParam : (uri.indexOf(63) == -1 ? uri + '?' + queryParam : uri + '&' + queryParam);
    }

    public static String simpleGet(CloseableHttpClient httpclient, HttpContext context, String uri, String queryParam) throws IOException {
        HttpGet httpGet = new HttpGet(HttpExecutor.appendParamToUrl(uri, queryParam));
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpGet);
    }

    public static String simpleGet(CloseableHttpClient httpclient, String uri, String queryParam) throws IOException {
        return HttpExecutor.simpleGet(httpclient, null, uri, queryParam);
    }

    public static String simpleGet(CloseableHttpClient httpclient, HttpContext context, String uri, Map<String, Object> queryParam) throws IOException {
        StringBuilder urlBuilder = new StringBuilder(uri);
        if (queryParam != null) {
            if (!uri.endsWith("?") && !uri.endsWith("&")) {
                if (uri.indexOf(63) == -1) {
                    urlBuilder.append('?');
                } else {
                    urlBuilder.append('&');
                }
            }
            int n = 0;
            for (Map.Entry<String, Object> ent : queryParam.entrySet()) {
                if (n > 0) {
                    urlBuilder.append('&');
                }
                ++n;
                urlBuilder.append(ent.getKey()).append('=').append(StringEscapeUtils.escapeHtml4((String)StringBaseOpt.objectToString(ent.getValue())));
            }
        }
        HttpGet httpGet = new HttpGet(urlBuilder.toString());
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpGet);
    }

    public static String simpleGet(CloseableHttpClient httpclient, HttpContext context, String uri) throws IOException {
        return HttpExecutor.simpleGet(httpclient, context, uri, (String)null);
    }

    public static String simpleGet(CloseableHttpClient httpclient, String uri) throws IOException {
        return HttpExecutor.simpleGet(httpclient, null, uri, (String)null);
    }

    public static String simpleGet(CloseableHttpClient httpclient, String uri, Map<String, Object> queryParam) throws IOException {
        return HttpExecutor.simpleGet(httpclient, null, uri, queryParam);
    }

    public static String simpleDelete(CloseableHttpClient httpclient, HttpContext context, String uri, String queryParam) throws IOException {
        HttpDelete httpDelete = new HttpDelete(HttpExecutor.appendParamToUrl(uri, queryParam));
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpDelete);
    }

    public static String simpleDelete(CloseableHttpClient httpclient, String uri, String queryParam) throws IOException {
        return HttpExecutor.simpleDelete(httpclient, null, uri, queryParam);
    }

    public static String simplePut(CloseableHttpClient httpclient, HttpContext context, String uri, String putEntity) throws IOException {
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setHeader("Content-Type", plainTextHead);
        if (putEntity != null) {
            StringEntity entity = new StringEntity(putEntity, Consts.UTF_8);
            httpPut.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpPut);
    }

    public static String simplePut(CloseableHttpClient httpclient, String uri, String putEntity) throws IOException {
        return HttpExecutor.simplePut(httpclient, null, uri, putEntity);
    }

    public static String rawPut(CloseableHttpClient httpclient, HttpContext context, String uri, byte[] bytes) throws IOException {
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setHeader("Content-Type", applicationFormHead);
        if (bytes != null) {
            ByteArrayEntity entity = new ByteArrayEntity(bytes);
            httpPut.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpPut);
    }

    public static String rawPut(CloseableHttpClient httpclient, String uri, byte[] bytes) throws IOException {
        return HttpExecutor.rawPut(httpclient, null, uri, bytes);
    }

    public static String requestInputStreamPut(CloseableHttpClient httpclient, HttpContext context, String uri, InputStream putIS) throws IOException {
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setHeader("Content-Type", applicationFormHead);
        if (putIS != null) {
            InputStreamEntity entity = new InputStreamEntity(putIS);
            httpPut.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpPut);
    }

    public static String requestInputStreamPut(CloseableHttpClient httpclient, String uri, InputStream putIS) throws IOException {
        return HttpExecutor.requestInputStreamPut(httpclient, null, uri, putIS);
    }

    public static List<NameValuePair> makeRequectParams(Object obj, String prefixName) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (obj == null) {
            return params;
        }
        if (ReflectionOpt.isScalarType(obj.getClass())) {
            params.add((NameValuePair)new BasicNameValuePair(prefixName, StringBaseOpt.objectToString(obj)));
            return params;
        }
        if (obj instanceof NameValuePair) {
            params.add((NameValuePair)obj);
            return params;
        }
        if (obj instanceof Map) {
            String sFN = prefixName == null || "".equals(prefixName) ? "" : prefixName + ".";
            Map objMap = (Map)obj;
            for (Map.Entry f : objMap.entrySet()) {
                if (f.getValue() == null) continue;
                List<NameValuePair> subNP = HttpExecutor.makeRequectParams(f.getValue(), sFN + (String)f.getKey());
                params.addAll(subNP);
            }
            return params;
        }
        if (obj instanceof Collection) {
            Collection objList = (Collection)obj;
            if (objList.size() == 1) {
                Object subObj = objList.iterator().next();
                if (subObj != null) {
                    if (ReflectionOpt.isScalarType(subObj.getClass())) {
                        params.add((NameValuePair)new BasicNameValuePair(prefixName, StringBaseOpt.objectToString(obj)));
                    } else if (subObj instanceof NameValuePair) {
                        params.add((NameValuePair)subObj);
                    } else {
                        List<NameValuePair> subNP = HttpExecutor.makeRequectParams(subObj, prefixName);
                        params.addAll(subNP);
                    }
                }
            } else if (objList.size() > 1) {
                int n = 0;
                for (Object subObj : objList) {
                    if (subObj != null) {
                        if (ReflectionOpt.isScalarType(subObj.getClass())) {
                            params.add((NameValuePair)new BasicNameValuePair(prefixName, StringBaseOpt.objectToString(subObj)));
                        } else if (subObj instanceof NameValuePair) {
                            params.add((NameValuePair)subObj);
                        } else {
                            List<NameValuePair> subNP = HttpExecutor.makeRequectParams(subObj, prefixName + "[" + n + "]");
                            params.addAll(subNP);
                        }
                    }
                    ++n;
                }
            }
            return params;
        }
        if (obj instanceof Object[]) {
            Object[] objs = (Object[])obj;
            if (objs.length == 1) {
                Object subobj = objs[0];
                if (subobj != null) {
                    if (ReflectionOpt.isScalarType(subobj.getClass())) {
                        params.add((NameValuePair)new BasicNameValuePair(prefixName, StringBaseOpt.objectToString(obj)));
                    } else if (subobj instanceof NameValuePair) {
                        params.add((NameValuePair)subobj);
                    } else {
                        List<NameValuePair> subNP = HttpExecutor.makeRequectParams(subobj, prefixName);
                        params.addAll(subNP);
                    }
                }
            } else if (objs.length > 1) {
                for (int i = 0; i < objs.length; ++i) {
                    if (objs[i] == null) continue;
                    if (ReflectionOpt.isScalarType(objs[i].getClass())) {
                        params.add((NameValuePair)new BasicNameValuePair(prefixName, StringBaseOpt.objectToString(objs[i])));
                        continue;
                    }
                    if (objs[i] instanceof NameValuePair) {
                        params.add((NameValuePair)objs[i]);
                        continue;
                    }
                    List<NameValuePair> subNP = HttpExecutor.makeRequectParams(objs[i], prefixName + "[" + i + "]");
                    params.addAll(subNP);
                }
            }
            return params;
        }
        List<Method> methods = ReflectionOpt.getAllGetterMethod(obj.getClass());
        String sFN = prefixName == null || "".equals(prefixName) ? "" : prefixName + ".";
        for (Method md : methods) {
            try {
                Object v = md.invoke(obj, new Object[0]);
                if (v == null) continue;
                String skey = ReflectionOpt.methodNameToField(md.getName());
                List<NameValuePair> subNP = HttpExecutor.makeRequectParams(v, sFN + skey);
                params.addAll(subNP);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return params;
    }

    public static List<NameValuePair> makeRequectParams(Object obj) {
        return HttpExecutor.makeRequectParams(obj, "");
    }

    public static String formPut(CloseableHttpClient httpclient, HttpContext context, String uri, Object formData) throws IOException {
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setHeader("Content-Type", applicationFormHead);
        if (formData != null) {
            EntityBuilder eb = EntityBuilder.create();
            eb.setContentType(APPLICATION_FORM_URLENCODED);
            eb.setContentEncoding("utf-8");
            List<NameValuePair> params = HttpExecutor.makeRequectParams(formData, "");
            eb.setParameters(params);
            httpPut.setEntity(eb.build());
        }
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpPut);
    }

    public static String formPut(CloseableHttpClient httpclient, String uri, Object formData) throws IOException {
        return HttpExecutor.formPut(httpclient, null, uri, formData);
    }

    public static String multiFormPut(CloseableHttpClient httpclient, HttpContext context, String uri, Object[] formObjects, Map<String, Object> extFormObjects) throws IOException {
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setHeader("Content-Type", applicationFormHead);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (formObjects != null) {
            for (int i = 0; i < formObjects.length; ++i) {
                if (formObjects[i] == null) continue;
                List<NameValuePair> subNP = HttpExecutor.makeRequectParams(formObjects[i], "");
                params.addAll(subNP);
            }
        }
        if (extFormObjects != null) {
            List<NameValuePair> subNP = HttpExecutor.makeRequectParams(extFormObjects, "");
            params.addAll(subNP);
        }
        EntityBuilder eb = EntityBuilder.create();
        eb.setContentType(APPLICATION_FORM_URLENCODED);
        eb.setContentEncoding("utf-8");
        eb.setParameters(params);
        httpPut.setEntity(eb.build());
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpPut);
    }

    public static String multiFormPut(CloseableHttpClient httpclient, HttpContext context, String uri, Object formObject, Map<String, Object> extFormObjects) throws IOException {
        return HttpExecutor.multiFormPut(httpclient, context, uri, new Object[]{formObject}, extFormObjects);
    }

    public static String simplePost(CloseableHttpClient httpclient, HttpContext context, String uri, String postEntity, boolean asPutMethod) throws IOException {
        HttpPost httpPost = new HttpPost(asPutMethod ? HttpExecutor.urlAddMethodParameter(uri, "PUT") : uri);
        httpPost.setHeader("Content-Type", plainTextHead);
        if (postEntity != null) {
            StringEntity entity = new StringEntity(postEntity, Consts.UTF_8);
            httpPost.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpPost);
    }

    public static String simplePost(CloseableHttpClient httpclient, String uri, String postEntity, boolean asPutMethod) throws IOException {
        return HttpExecutor.simplePost(httpclient, null, uri, postEntity, asPutMethod);
    }

    public static String simplePost(CloseableHttpClient httpclient, String uri, String postEntity) throws IOException {
        return HttpExecutor.simplePost(httpclient, null, uri, postEntity, false);
    }

    public static String requestInputStreamPost(CloseableHttpClient httpclient, HttpContext context, String uri, InputStream postIS) throws IOException {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader("Content-Type", applicationFormHead);
        if (postIS != null) {
            InputStreamEntity entity = new InputStreamEntity(postIS);
            httpPost.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpPost);
    }

    public static String requestInputStreamPost(CloseableHttpClient httpclient, String uri, InputStream postIS) throws IOException {
        return HttpExecutor.requestInputStreamPost(httpclient, null, uri, postIS);
    }

    public static String rawPost(CloseableHttpClient httpclient, HttpContext context, String uri, byte[] bytes, boolean asPutMethod) throws IOException {
        HttpPost httpPost = new HttpPost(asPutMethod ? HttpExecutor.urlAddMethodParameter(uri, "PUT") : uri);
        httpPost.setHeader("Content-Type", applicationFormHead);
        if (bytes != null) {
            ByteArrayEntity entity = new ByteArrayEntity(bytes);
            httpPost.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpPost);
    }

    public static String rawPost(CloseableHttpClient httpclient, String uri, byte[] bytes, boolean asPutMethod) throws IOException {
        return HttpExecutor.rawPost(httpclient, null, uri, bytes, asPutMethod);
    }

    public static String rawPost(CloseableHttpClient httpclient, String uri, byte[] bytes) throws IOException {
        return HttpExecutor.rawPost(httpclient, null, uri, bytes, false);
    }

    public static String jsonPost(CloseableHttpClient httpclient, HttpContext context, String uri, String jsonString, boolean asPutMethod) throws IOException {
        HttpPost httpPost = new HttpPost(asPutMethod ? HttpExecutor.urlAddMethodParameter(uri, "PUT") : uri);
        httpPost.setHeader("Content-Type", applicationJSONHead);
        if (jsonString != null && !"".equals(jsonString)) {
            StringEntity entity = new StringEntity(jsonString, Consts.UTF_8);
            httpPost.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpPost);
    }

    public static String jsonPost(CloseableHttpClient httpclient, HttpContext context, String uri, JSON jsonEntity, boolean asPutMethod) throws IOException {
        return HttpExecutor.jsonPost(httpclient, context, uri, jsonEntity == null ? null : jsonEntity.toJSONString(), asPutMethod);
    }

    public static String jsonPost(CloseableHttpClient httpclient, HttpContext context, String uri, Object obj, boolean asPutMethod) throws IOException {
        return HttpExecutor.jsonPost(httpclient, context, uri, obj == null ? null : JSON.toJSONString((Object)obj), asPutMethod);
    }

    public static String jsonPost(CloseableHttpClient httpclient, String uri, String jsonString, boolean asPutMethod) throws IOException {
        return HttpExecutor.jsonPost(httpclient, null, uri, jsonString, asPutMethod);
    }

    public static String jsonPost(CloseableHttpClient httpclient, String uri, String jsonString) throws IOException {
        return HttpExecutor.jsonPost(httpclient, null, uri, jsonString, false);
    }

    public static String jsonPost(CloseableHttpClient httpclient, String uri, Object obj, boolean asPutMethod) throws IOException {
        return HttpExecutor.jsonPost(httpclient, null, uri, obj, asPutMethod);
    }

    public static String jsonPost(CloseableHttpClient httpclient, String uri, Object obj) throws IOException {
        return HttpExecutor.jsonPost(httpclient, null, uri, obj, false);
    }

    public static String jsonPost(CloseableHttpClient httpclient, String uri, JSON jsonEntity, boolean asPutMethod) throws IOException {
        return HttpExecutor.jsonPost(httpclient, null, uri, jsonEntity, asPutMethod);
    }

    public static String jsonPost(CloseableHttpClient httpclient, String uri, JSON jsonEntity) throws IOException {
        return HttpExecutor.jsonPost(httpclient, null, uri, jsonEntity, false);
    }

    public static String jsonPut(CloseableHttpClient httpclient, HttpContext context, String uri, String jsonString) throws IOException {
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setHeader("Content-Type", applicationJSONHead);
        if (jsonString != null && !"".equals(jsonString)) {
            StringEntity entity = new StringEntity(jsonString, Consts.UTF_8);
            httpPut.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpPut);
    }

    public static String jsonPut(CloseableHttpClient httpclient, String uri, String jsonString) throws IOException {
        return HttpExecutor.jsonPut(httpclient, null, uri, jsonString);
    }

    public static String xmlPost(CloseableHttpClient httpclient, HttpContext context, String uri, String xmlEntity, boolean asPutMethod) throws IOException {
        HttpPost httpPost = new HttpPost(asPutMethod ? HttpExecutor.urlAddMethodParameter(uri, "PUT") : uri);
        httpPost.setHeader("Content-Type", xmlTextHead);
        if (xmlEntity != null) {
            StringEntity entity = new StringEntity(xmlEntity, Consts.UTF_8);
            httpPost.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpPost);
    }

    public static String xmlPost(CloseableHttpClient httpclient, String uri, String xmlEntity, boolean asPutMethod) throws IOException {
        return HttpExecutor.xmlPost(httpclient, null, uri, xmlEntity, asPutMethod);
    }

    public static String xmlPost(CloseableHttpClient httpclient, String uri, String xmlEntity) throws IOException {
        return HttpExecutor.xmlPost(httpclient, null, uri, xmlEntity, false);
    }

    public static String xmlPut(CloseableHttpClient httpclient, HttpContext context, String uri, String xmlEntity) throws IOException {
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setHeader("Content-Type", xmlTextHead);
        if (xmlEntity != null && !"".equals(xmlEntity)) {
            StringEntity entity = new StringEntity(xmlEntity, Consts.UTF_8);
            httpPut.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpPut);
    }

    public static String xmlPut(CloseableHttpClient httpclient, String uri, String xmlEntity) throws IOException {
        return HttpExecutor.xmlPut(httpclient, null, uri, xmlEntity);
    }

    public static String urlAddMethodParameter(String url, String method) {
        String sUrl = url.indexOf(63) == -1 ? url + "?_method=" + method : (url.endsWith("?") ? url + "_method=" + method : url + "&_method=" + method);
        return sUrl;
    }

    public static String formPost(CloseableHttpClient httpclient, HttpContext context, String uri, Object formData, boolean asPutMethod) throws IOException {
        HttpPost httpPost = new HttpPost(asPutMethod ? HttpExecutor.urlAddMethodParameter(uri, "PUT") : uri);
        httpPost.setHeader("Content-Type", applicationFormHead);
        if (formData != null) {
            EntityBuilder eb = EntityBuilder.create();
            eb.setContentType(APPLICATION_FORM_URLENCODED);
            eb.setContentEncoding("utf-8");
            List<NameValuePair> params = HttpExecutor.makeRequectParams(formData, "");
            eb.setParameters(params);
            httpPost.setEntity(eb.build());
        }
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpPost);
    }

    public static String formPost(CloseableHttpClient httpclient, String uri, Object formData, boolean asPutMethod) throws IOException {
        return HttpExecutor.formPost(httpclient, null, uri, formData, asPutMethod);
    }

    public static String formPost(CloseableHttpClient httpclient, String uri, Object formData) throws IOException {
        return HttpExecutor.formPost(httpclient, null, uri, formData, false);
    }

    public static String multiFormPost(CloseableHttpClient httpclient, HttpContext context, String uri, Object[] formObjects, Map<String, Object> extFormObjects, boolean asPutMethod) throws IOException {
        HttpPost httpPost = new HttpPost(asPutMethod ? HttpExecutor.urlAddMethodParameter(uri, "PUT") : uri);
        httpPost.setHeader("Content-Type", applicationFormHead);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (formObjects != null) {
            for (int i = 0; i < formObjects.length; ++i) {
                if (formObjects[i] == null) continue;
                List<NameValuePair> subNP = HttpExecutor.makeRequectParams(formObjects[i], "");
                params.addAll(subNP);
            }
        }
        if (extFormObjects != null) {
            List<NameValuePair> subNP = HttpExecutor.makeRequectParams(extFormObjects, "");
            params.addAll(subNP);
        }
        EntityBuilder eb = EntityBuilder.create();
        eb.setContentType(APPLICATION_FORM_URLENCODED);
        eb.setContentEncoding("utf-8");
        eb.setParameters(params);
        httpPost.setEntity(eb.build());
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpPost);
    }

    public static String multiFormPost(CloseableHttpClient httpclient, String uri, Object[] formObjects, Map<String, Object> extFormObjects, boolean asPutMethod) throws IOException {
        return HttpExecutor.multiFormPost(httpclient, null, uri, formObjects, extFormObjects, asPutMethod);
    }

    public static String multiFormPost(CloseableHttpClient httpclient, HttpContext context, String uri, Object formObject, Map<String, Object> extFormObjects, boolean asPutMethod) throws IOException {
        return HttpExecutor.multiFormPost(httpclient, context, uri, new Object[]{formObject}, extFormObjects, asPutMethod);
    }

    public static String multiFormPost(CloseableHttpClient httpclient, String uri, Object formObject, Map<String, Object> extFormObjects, boolean asPutMethod) throws IOException {
        return HttpExecutor.multiFormPost(httpclient, null, uri, new Object[]{formObject}, extFormObjects, asPutMethod);
    }

    public static String multiFormPost(CloseableHttpClient httpclient, String uri, Object[] formObjects, Map<String, Object> extFormObjects) throws IOException {
        return HttpExecutor.multiFormPost(httpclient, null, uri, formObjects, extFormObjects, false);
    }

    public static String multiFormPost(CloseableHttpClient httpclient, String uri, Object formObject, Map<String, Object> extFormObjects) throws IOException {
        return HttpExecutor.multiFormPost(httpclient, null, uri, new Object[]{formObject}, extFormObjects, false);
    }

    public static String inputStreamUpload(CloseableHttpClient httpclient, HttpContext context, String uri, InputStream inputStream) throws IOException {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader("Content-Type", applicationOctetStream);
        InputStreamEntity entity = new InputStreamEntity(inputStream);
        httpPost.setEntity((HttpEntity)entity);
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpPost);
    }

    public static String inputStreamUpload(CloseableHttpClient httpclient, String uri, InputStream inputStream) throws IOException {
        return HttpExecutor.inputStreamUpload(httpclient, null, uri, inputStream);
    }

    public static String inputStreamUpload(CloseableHttpClient httpclient, HttpContext context, String uri, Map<String, Object> formObjects, InputStream inputStream) throws IOException {
        String paramsUrl = null;
        if (formObjects != null) {
            List<NameValuePair> params = HttpExecutor.makeRequectParams(formObjects, "");
            paramsUrl = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(params, Consts.UTF_8));
        }
        return HttpExecutor.inputStreamUpload(httpclient, context, HttpExecutor.appendParamToUrl(uri, paramsUrl), inputStream);
    }

    public static String inputStreamUpload(CloseableHttpClient httpclient, String uri, Map<String, Object> formObjects, InputStream inputStream) throws IOException {
        return HttpExecutor.inputStreamUpload(httpclient, null, uri, formObjects, inputStream);
    }

    public static String formPostWithFileUpload(CloseableHttpClient httpclient, HttpContext context, String uri, Map<String, Object> formObjects, Map<String, File> files) throws IOException {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader("Content-Type", multiPartTypeHead);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setBoundary(BOUNDARY);
        if (formObjects != null) {
            for (Map.Entry<String, Object> entry : formObjects.entrySet()) {
                builder.addTextBody(entry.getKey(), JSONOpt.objectToJSONString(entry.getValue()));
            }
        }
        if (files != null) {
            for (Map.Entry<String, Object> entry : files.entrySet()) {
                builder.addBinaryBody(entry.getKey(), (File)entry.getValue());
            }
        }
        httpPost.setEntity(builder.build());
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpPost);
    }

    public static String formPostWithFileUpload(CloseableHttpClient httpclient, String uri, Map<String, Object> formObjects, Map<String, File> files) throws IOException {
        return HttpExecutor.formPostWithFileUpload(httpclient, null, uri, formObjects, files);
    }

    public static String fileUpload(CloseableHttpClient httpclient, HttpContext context, String uri, Map<String, Object> formObjects, File file) throws IOException {
        String paramsUrl = null;
        if (formObjects != null) {
            List<NameValuePair> params = HttpExecutor.makeRequectParams(formObjects, "");
            paramsUrl = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(params, Consts.UTF_8));
        }
        return HttpExecutor.fileUpload(httpclient, context, HttpExecutor.appendParamToUrl(uri, paramsUrl), file);
    }

    public static String fileUpload(CloseableHttpClient httpclient, String uri, Map<String, Object> formObjects, File file) throws IOException {
        return HttpExecutor.fileUpload(httpclient, null, uri, formObjects, file);
    }

    public static String fileUpload(CloseableHttpClient httpclient, HttpContext context, String uri, File file) throws IOException {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader("Content-Type", applicationOctetStream);
        InputStreamEntity entity = new InputStreamEntity((InputStream)new FileInputStream(file));
        httpPost.setEntity((HttpEntity)entity);
        return HttpExecutor.httpExecute(httpclient, context, (HttpRequestBase)httpPost);
    }

    public static String fileUpload(CloseableHttpClient httpclient, String uri, File file) throws IOException {
        return HttpExecutor.fileUpload(httpclient, null, uri, file);
    }

    protected static String extraFileName(CloseableHttpResponse response) {
        Header[] contentDispositionHeader = response.getHeaders("Content-disposition");
        Pattern p = Pattern.compile(".*filename=\"(.*)\"");
        Matcher m = p.matcher(contentDispositionHeader[0].getValue());
        if (m.matches()) {
            String fileName = m.group(1);
            return fileName;
        }
        return null;
    }

    public static boolean fileDownload(CloseableHttpClient httpclient, HttpContext context, String uri, String queryParam, String filePath) throws IOException {
        HttpGet httpGet = new HttpGet(HttpExecutor.appendParamToUrl(uri, queryParam));
        try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet, context);){
            Header[] contentTypeHeader = response.getHeaders("Content-Type");
            if (contentTypeHeader == null || contentTypeHeader.length < 1 || StringUtils.indexOf((CharSequence)contentTypeHeader[0].getValue(), (CharSequence)"text/") >= 0) {
                String responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
                throw new RuntimeException(responseContent);
            }
            InputStream inputStream = (InputStream)InputStreamResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
            boolean bl = FileSystemOpt.createFile(inputStream, filePath);
            return bl;
        }
    }

    public static boolean fileDownload(CloseableHttpClient httpclient, String uri, String queryParam, String filePath) throws IOException {
        return HttpExecutor.fileDownload(httpclient, null, uri, queryParam, filePath);
    }
}

