/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.security;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public abstract class DESSecurityUtils {
    public static Cipher createEncryptCipher(String keyValue) throws GeneralSecurityException {
        Key key = DESSecurityUtils.getKey(keyValue.getBytes());
        Cipher encryptCipher = Cipher.getInstance("DES");
        encryptCipher.init(1, key);
        return encryptCipher;
    }

    public static Cipher createDencryptCipher(String keyValue) throws GeneralSecurityException {
        Key key = DESSecurityUtils.getKey(keyValue.getBytes());
        Cipher decryptCipher = Cipher.getInstance("DES");
        decryptCipher.init(2, key);
        return decryptCipher;
    }

    private static Key getKey(byte[] arrBTmp) {
        byte[] arrB = new byte[8];
        for (int i = 0; i < arrBTmp.length && i < arrB.length; ++i) {
            arrB[i] = arrBTmp[i];
        }
        SecretKeySpec key = new SecretKeySpec(arrB, "DES");
        return key;
    }

    public static byte[] encrypt(byte[] arrB, String keyValue) throws GeneralSecurityException {
        return DESSecurityUtils.createEncryptCipher(keyValue).doFinal(arrB);
    }

    public static byte[] decrypt(byte[] arrB, String keyValue) throws GeneralSecurityException {
        return DESSecurityUtils.createDencryptCipher(keyValue).doFinal(arrB);
    }

    public static String encryptAndBase64(String str, String keyValue) {
        try {
            return new String(Base64.encodeBase64((byte[])DESSecurityUtils.encrypt(str.getBytes(), keyValue)));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String decryptBase64String(String str, String keyValue) {
        try {
            return new String(DESSecurityUtils.decrypt(Base64.decodeBase64((byte[])str.getBytes()), keyValue));
        }
        catch (Exception e) {
            return null;
        }
    }
}

