/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.security;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;

public abstract class Md5Encoder {
    public static String encode(byte[] data) {
        try {
            MessageDigest MD5 = MessageDigest.getInstance("MD5");
            MD5.update(data, 0, data.length);
            return new String(Hex.encodeHex((byte[])MD5.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String encode(String data) {
        try {
            return Md5Encoder.encode(data.getBytes("utf8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String encodePasswordAsSpringSecurity(String data, String salt) {
        return Md5Encoder.encode(data + "{" + salt + "}");
    }

    public static String encodePasswordAsJasigCas(String data, String salt, int iterations) {
        try {
            MessageDigest MD5 = MessageDigest.getInstance("MD5");
            byte[] saltBytes = salt.getBytes("utf8");
            MD5.update(saltBytes, 0, saltBytes.length);
            byte[] hashedBytes = MD5.digest(data.getBytes("utf8"));
            for (int i = 0; i < iterations - 1; ++i) {
                hashedBytes = MD5.digest(hashedBytes);
            }
            return new String(Hex.encodeHex((byte[])hashedBytes));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String encodePassword(String data, String salt) {
        return Md5Encoder.encodePasswordAsSpringSecurity(data, salt);
    }

    public static String encodePasswordWithDoubleMd5(String data, String salt) {
        return Md5Encoder.encodePasswordAsSpringSecurity(Md5Encoder.encode(data), salt);
    }
}

