/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatetimeOpt {
    private static Logger log = LoggerFactory.getLogger(DatetimeOpt.class);
    private static String defaultDatePattern = "yyyy-MM-dd";
    private static String timePattern = "HH:mm";
    private static String timeWithSecondPattern = "HH:mm:ss";
    private static String datetimePattern = "yyyy-MM-dd HH:mm:ss";
    private static String timestampPattern = "yyyy-MM-dd HH:mm:ss.SSS";
    private static String gmtDatePattern = "d MMM yyyy HH:mm:ss 'GMT'";

    private DatetimeOpt() {
        throw new IllegalAccessError("Utility class");
    }

    public static String currentDate() {
        SimpleDateFormat formatter = new SimpleDateFormat(defaultDatePattern);
        Date dt = new Date(System.currentTimeMillis());
        String sCurDate = formatter.format(dt);
        return sCurDate;
    }

    public static String currentTime() {
        SimpleDateFormat formatter = new SimpleDateFormat(timePattern);
        Date dt = new Date(System.currentTimeMillis());
        return formatter.format(dt);
    }

    public static String currentTimeWithSecond() {
        SimpleDateFormat formatter = new SimpleDateFormat(timeWithSecondPattern);
        Date dt = new Date(System.currentTimeMillis());
        return formatter.format(dt);
    }

    public static String currentDatetime() {
        SimpleDateFormat formatter = new SimpleDateFormat(datetimePattern);
        Date dt = new Date(System.currentTimeMillis());
        String sCurDate = formatter.format(dt);
        return sCurDate;
    }

    public static Date createUtilDate(int year, int month, int date, int hourOfDay, int minute, int second) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(year, month - 1, date, hourOfDay, minute, second);
        return cal.getTime();
    }

    public static Date createUtilDate(int year, int month, int date, int hourOfDay, int minute, int second, int milliSecond) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(year, month - 1, date, hourOfDay, minute, second);
        cal.set(14, milliSecond);
        return cal.getTime();
    }

    public static Date createUtilDate(int year, int month, int date, int hourOfDay, int minute) {
        return DatetimeOpt.createUtilDate(year, month, date, hourOfDay, minute, 0);
    }

    public static Date createUtilDate(int year, int month, int date) {
        return DatetimeOpt.createUtilDate(year, month, date, 0, 0, 0);
    }

    public static Date convertToUtilDate(java.sql.Date date) {
        return date;
    }

    public static java.sql.Date convertToSqlDate(Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof java.sql.Date) {
            return (java.sql.Date)date;
        }
        return new java.sql.Date(date.getTime());
    }

    public static java.sql.Date castObjectToSqlDate(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof java.sql.Date) {
            return (java.sql.Date)date;
        }
        if (date instanceof Date) {
            return new java.sql.Date(((Date)date).getTime());
        }
        Date dt = DatetimeOpt.castObjectToDate(date);
        if (dt == null) {
            return null;
        }
        return new java.sql.Date(dt.getTime());
    }

    public static Timestamp convertToSqlTimestamp(Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Timestamp) {
            return (Timestamp)date;
        }
        return new Timestamp(date.getTime());
    }

    public static Timestamp castObjectToSqlTimestamp(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Timestamp) {
            return (Timestamp)date;
        }
        if (date instanceof Date) {
            return new Timestamp(((Date)date).getTime());
        }
        Date dt = DatetimeOpt.castObjectToDate(date);
        if (dt == null) {
            return null;
        }
        return new Timestamp(dt.getTime());
    }

    public static java.sql.Date currentSqlDate() {
        return new java.sql.Date(System.currentTimeMillis());
    }

    public static Date currentUtilDate() {
        return new Date(System.currentTimeMillis());
    }

    public static Timestamp currentSqlTimeStamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Calendar currentCalendarDate() {
        Date today = DatetimeOpt.currentUtilDate();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(today);
        return cal;
    }

    public static String getDatePattern() {
        return defaultDatePattern;
    }

    public static String getDateTimePattern() {
        return datetimePattern;
    }

    public static Date convertStringToDate(String strDate, String aMask) {
        try {
            SimpleDateFormat df = new SimpleDateFormat(aMask);
            if (strDate == null || strDate.equals("")) {
                return null;
            }
            return df.parse(strDate);
        }
        catch (ParseException pe) {
            log.error("converting '" + strDate + "' to date with mask '" + aMask + "'");
            return null;
        }
    }

    public static String convertDateToString(Date aDate, String aMask) {
        String returnValue = "";
        if (aDate == null) {
            log.error("aDate is null!");
        } else {
            String sMask = aMask == null || "".equals(aMask) ? "yyyy-MM-dd" : aMask;
            SimpleDateFormat df = new SimpleDateFormat(sMask);
            returnValue = df.format(aDate);
        }
        return returnValue;
    }

    public static String convertTimeToString(Date aDate) {
        return DatetimeOpt.convertDateToString(aDate, timePattern);
    }

    public static String convertTimeWithSecondToString(Date aDate) {
        return DatetimeOpt.convertDateToString(aDate, timeWithSecondPattern);
    }

    public static String convertDateToString(Date aDate) {
        return DatetimeOpt.convertDateToString(aDate, defaultDatePattern);
    }

    public static String convertDateToGMTString(Date aDate) {
        return DatetimeOpt.convertDateToString(aDate, gmtDatePattern);
    }

    public static String convertDatetimeToString(Date aDate) {
        return DatetimeOpt.convertDateToString(aDate, datetimePattern);
    }

    public static String convertTimestampToString(Date aDate) {
        return DatetimeOpt.convertDateToString(aDate, timestampPattern);
    }

    public static String getNowDateTime4String() {
        return DatetimeOpt.convertDateToString(DatetimeOpt.currentUtilDate(), DatetimeOpt.getDateTimePattern());
    }

    public static Date convertStringToDate(String strDate) throws ParseException {
        return DatetimeOpt.convertStringToDate(strDate, DatetimeOpt.getDatePattern());
    }

    public static int getDayOfWeek(int y, int m, int d) {
        int y0 = y - (14 - m) / 12;
        int x = y0 + y0 / 4 - y0 / 100 + y0 / 400;
        int m0 = m + 12 * ((14 - m) / 12) - 2;
        return (d + x + 31 * m0 / 12) % 7;
    }

    public static int getDayOfWeek(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(7) - 1;
    }

    public static String getDayOfWeekCN(Date date) {
        String[] weeklist = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d", ""};
        return weeklist[DatetimeOpt.getDayOfWeek(date)];
    }

    public static int getSecond(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(13);
    }

    public static int getMilliSecond(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(14);
    }

    public static int getMinute(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(12);
    }

    public static int getHour(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(11);
    }

    public static int getWeekOfYear(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(3);
    }

    public static int getWeekOfMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(4);
    }

    public static int getDay(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getDayOfYear(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(6);
    }

    public static int getMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static int getYear(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(1);
    }

    public static Date truncateToDay(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return DatetimeOpt.createUtilDate(cal.get(1), cal.get(2) + 1, cal.get(5));
    }

    public static Date truncateToMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return DatetimeOpt.createUtilDate(cal.get(1), cal.get(2) + 1, 1);
    }

    public static Date truncateToYear(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return DatetimeOpt.createUtilDate(cal.get(1), 1, 1);
    }

    public static Date seekEndOfYear(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return DatetimeOpt.createUtilDate(cal.get(1), 12, 31);
    }

    public static Date seekEndOfMonth(Date date) {
        return DatetimeOpt.addDays(DatetimeOpt.truncateToMonth(DatetimeOpt.addMonths(date, 1)), -1);
    }

    public static Date addSeconds(Date date, int nSeconds) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(13, nSeconds);
        return cal.getTime();
    }

    public static Date addMinutes(Date date, int nMinutes) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(12, nMinutes);
        return cal.getTime();
    }

    public static Date addHours(Date date, int nHours) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(10, nHours);
        return cal.getTime();
    }

    public static Date addDays(Date date, int nDays) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(5, nDays);
        return cal.getTime();
    }

    public static Date addMonths(Date date, int nMonths) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(2, nMonths);
        return cal.getTime();
    }

    public static Date addYears(Date date, int nYears) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(1, nYears);
        return cal.getTime();
    }

    public static int calcSpanDays(Date beginDate, Date endDate) {
        Date bD = beginDate.getTime() > endDate.getTime() ? DatetimeOpt.truncateToDay(endDate) : DatetimeOpt.truncateToDay(beginDate);
        Date eD = beginDate.getTime() > endDate.getTime() ? beginDate : endDate;
        return (int)((eD.getTime() - bD.getTime()) / 1000L / 60L / 60L / 24L + 1L);
    }

    public static Date calcWeek1stDay(int nYear, int nWeekNo) {
        Calendar cal = Calendar.getInstance();
        cal.set(7, 1);
        cal.set(1, nYear);
        cal.set(3, nWeekNo);
        return cal.getTime();
    }

    public static Date calcWeekLastDay(int nYear, int nWeekNo) {
        Calendar cal = Calendar.getInstance();
        cal.set(7, 7);
        cal.set(1, nYear);
        cal.set(3, nWeekNo);
        return cal.getTime();
    }

    public static int calcWeekendDays(Date beginDate, Date endDate) {
        int nWeekDay = DatetimeOpt.getDayOfWeek(beginDate);
        int m = DatetimeOpt.calcSpanDays(beginDate, endDate);
        int weekEnds = (m + nWeekDay) / 7;
        int nWeekDay2 = (m + nWeekDay) % 7;
        int days = weekEnds * 2 - (nWeekDay == 0 ? 0 : 1) + (nWeekDay2 > 0 ? 1 : 0);
        return days;
    }

    public static int calcWeekDays(Date beginDate, Date endDate, int weekDay) {
        int nWeekDay = DatetimeOpt.getDayOfWeek(beginDate);
        int m = DatetimeOpt.calcSpanDays(beginDate, endDate);
        return m / 7 + (weekDay >= nWeekDay && nWeekDay + m % 7 > weekDay || weekDay + 7 >= nWeekDay && nWeekDay + m % 7 > weekDay + 7 ? 1 : 0);
    }

    public static boolean equalOnSecond(Date oneDate, Date otherDate) {
        if (oneDate == null || otherDate == null) {
            return false;
        }
        return oneDate.getTime() / 1000L == otherDate.getTime() / 1000L;
    }

    public static boolean equalOnMinute(Date oneDate, Date otherDate) {
        if (oneDate == null || otherDate == null) {
            return false;
        }
        return oneDate.getTime() / 60000L == otherDate.getTime() / 60000L;
    }

    public static boolean equalOnHour(Date oneDate, Date otherDate) {
        if (oneDate == null || otherDate == null) {
            return false;
        }
        return oneDate.getTime() / 3600000L == otherDate.getTime() / 3600000L;
    }

    public static boolean equalOnDay(Date oneDate, Date otherDate) {
        if (oneDate == null || otherDate == null) {
            return false;
        }
        return oneDate.getTime() / 86400000L == otherDate.getTime() / 86400000L;
    }

    public static int compareTwoDate(Date oneDate, Date otherDate) {
        if (oneDate == null && otherDate == null) {
            return 0;
        }
        if (oneDate == null) {
            return -1;
        }
        if (otherDate == null) {
            return 1;
        }
        return oneDate.compareTo(otherDate);
    }

    public static Date smartPraseDate(String sDate) {
        if (sDate == null || "".equals(sDate)) {
            return null;
        }
        String sTD = StringRegularOpt.trimDateString(sDate);
        int sl = sTD.length();
        switch (sl) {
            case 5: {
                return DatetimeOpt.convertStringToDate(sTD, "yy-MM");
            }
            case 7: {
                return DatetimeOpt.convertStringToDate(sTD, "yyyy-MM");
            }
            case 8: {
                return DatetimeOpt.convertStringToDate(sTD, "yy-MM-dd");
            }
            case 10: {
                return DatetimeOpt.convertStringToDate(sTD, "yyyy-MM-dd");
            }
            case 11: {
                return DatetimeOpt.convertStringToDate(sTD, "yy-MM-dd HH");
            }
            case 13: {
                return DatetimeOpt.convertStringToDate(sTD, "yyyy-MM-dd HH");
            }
            case 14: {
                return DatetimeOpt.convertStringToDate(sTD, "yy-MM-dd HH:mm");
            }
            case 16: {
                return DatetimeOpt.convertStringToDate(sTD, "yyyy-MM-dd HH:mm");
            }
            case 17: {
                return DatetimeOpt.convertStringToDate(sTD, "yy-MM-dd HH:mm:ss");
            }
            case 19: {
                return DatetimeOpt.convertStringToDate(sTD, "yyyy-MM-dd HH:mm:ss");
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return DatetimeOpt.convertStringToDate(sTD, "yyyy-MM-dd HH:mm:ss.SSS");
            }
        }
        return null;
    }

    public static final Date castObjectToDate(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof Long) {
            return new Date((Long)obj);
        }
        String str = StringBaseOpt.objectToString(obj);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        if (Pattern.matches("\\d+", str)) {
            return new Date(Long.parseLong(str));
        }
        return DatetimeOpt.smartPraseDate(str);
    }
}

