/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.StringRegularOpt;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.sourceforge.pinyin4j.PinyinHelper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StringBaseOpt {
    protected static final Logger logger = LoggerFactory.getLogger(StringBaseOpt.class);

    private StringBaseOpt() {
        throw new IllegalAccessError("Utility class");
    }

    public static String encodeBase64(String str) {
        return new String(Base64.encodeBase64((byte[])str.getBytes()));
    }

    public static String decodeBase64(String str) {
        return new String(Base64.decodeBase64((byte[])str.getBytes()));
    }

    public static byte[] compress(String str) throws IOException {
        if (null == str || str.length() <= 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(str.getBytes());
        gzip.close();
        return out.toByteArray();
    }

    public static String unCompress(byte[] str) throws IOException {
        int n;
        if (null == str || str.length <= 0) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(str);
        GZIPInputStream gzip = new GZIPInputStream(in);
        byte[] buffer = new byte[256];
        while ((n = gzip.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
        return out.toString("utf-8");
    }

    public static String concat(Object ... objs) {
        StringBuilder sb = new StringBuilder();
        if (objs != null && objs.length > 0) {
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] == null) continue;
                sb.append(StringBaseOpt.objectToString(objs[i]));
            }
        }
        return sb.toString();
    }

    public static String concat(Object[] objs, String separator) {
        StringBuilder sb = new StringBuilder();
        int objInd = 0;
        if (objs != null && objs.length > 0) {
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] == null) continue;
                if (objInd > 0) {
                    sb.append(separator);
                }
                ++objInd;
                sb.append(StringBaseOpt.objectToString(objs[i]));
            }
        }
        return sb.toString();
    }

    public static String concat(Collection<Object> objs, String separator) {
        StringBuilder sb = new StringBuilder();
        if (objs != null && objs.size() > 0) {
            int i = 0;
            for (Object obj : objs) {
                if (obj == null) continue;
                if (i > 0) {
                    sb.append(separator);
                }
                ++i;
                sb.append(StringBaseOpt.objectToString(obj));
            }
        }
        return sb.toString();
    }

    public static boolean contains(String[] strs, String str) {
        if (strs == null) {
            return false;
        }
        for (String str1 : strs) {
            if (!str1.contains(str)) continue;
            return true;
        }
        return false;
    }

    public static String deleteStringByQuote(String str, String quote) {
        if (null == str || "".equals(str)) {
            return "";
        }
        return StringUtils.replace((String)str.trim(), (String)("_" + quote), (String)"");
    }

    public static int indexOf(String[] strs, String str) {
        int index = -1;
        if (null != strs) {
            for (int i = 0; i < strs.length; ++i) {
                if (!strs[i].contains(str)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public static boolean isNvl(String str) {
        return StringUtils.isBlank((CharSequence)str);
    }

    public static String nvlAsBlank(String str) {
        return str == null ? "" : str;
    }

    public static String emptyValue(String str, String emptyValue) {
        return StringUtils.isBlank((CharSequence)str) ? emptyValue : str;
    }

    public static String fillZeroForString(String str, int size) {
        return StringUtils.leftPad((String)str, (int)size, (char)'0');
    }

    public static String midPad(String str, int size, String prefix, char padChar) {
        return prefix == null ? StringUtils.leftPad((String)str, (int)size, (char)padChar) : prefix + StringUtils.leftPad((String)str, (int)(size - prefix.length()), (char)padChar);
    }

    public static String midPad(String str, int size, String prefix, String padChar) {
        return prefix == null ? StringUtils.leftPad((String)str, (int)size, (String)padChar) : prefix + StringUtils.leftPad((String)str, (int)(size - prefix.length()), (String)padChar);
    }

    public static String multiplyString(String str, int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    @Deprecated
    public static String clacDocumentNo(String templet, long currNo, Map<String, String> params) {
        if (StringRegularOpt.isNvl(templet)) {
            return String.valueOf(currNo);
        }
        String sDocNo = templet;
        if (sDocNo.contains("$N")) {
            int firstBegin = sDocNo.indexOf("$N");
            int firstEnd = firstBegin + 2;
            int secondBegin = sDocNo.indexOf("$", firstEnd);
            int nunber = 0;
            if (secondBegin > firstEnd) {
                nunber = Integer.parseInt(sDocNo.substring(firstEnd, secondBegin));
            }
            sDocNo = sDocNo.substring(0, firstBegin) + StringBaseOpt.fillZeroForString(String.valueOf(currNo), nunber) + sDocNo.substring(secondBegin + 1);
        }
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                sDocNo = sDocNo.replaceAll("\\$" + param.getKey() + "\\$", param.getValue());
            }
        }
        sDocNo = sDocNo.replaceAll("\\$year\\$", String.valueOf(DatetimeOpt.getYear(DatetimeOpt.currentUtilDate())));
        sDocNo = sDocNo.replaceAll("\\$Y2\\$", String.valueOf(DatetimeOpt.getYear(DatetimeOpt.currentUtilDate())).substring(2, 4));
        return sDocNo;
    }

    public static String nextCode(String sCode) {
        int nSL = sCode.length();
        String sRes = "";
        int i = nSL;
        while (i > 0) {
            char c;
            if ((c = sCode.charAt(--i)) == '9') {
                sRes = '0' + sRes;
                continue;
            }
            if (c == 'z') {
                sRes = 'a' + sRes;
                continue;
            }
            if (c == 'Z') {
                sRes = 'A' + sRes;
                continue;
            }
            c = (char)(c + '\u0001');
            sRes = c + sRes;
            break;
        }
        if (i > 0) {
            sRes = sCode.substring(0, i) + sRes;
        }
        return sRes;
    }

    public static String getFirstLetter(String oriStr) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < oriStr.length(); ++i) {
            String[] pinyin = PinyinHelper.toHanyuPinyinStringArray((char)oriStr.charAt(i));
            if (pinyin != null && pinyin.length > 0) {
                sb.append(pinyin[0].charAt(0));
                continue;
            }
            sb.append(oriStr.charAt(i));
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFileToBuffer(String sFileName) {
        try (FileInputStream in = new FileInputStream(sFileName);){
            byte[] readBytes = new byte[in.available()];
            int l = in.read(readBytes);
            if (l <= 0) return null;
            String string = new String(readBytes);
            return string;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String readJarResourceToBuffer(Class<?> clazz, String sResourceName) {
        StringBuilder buffer = new StringBuilder();
        try {
            InputStream in = clazz.getResourceAsStream(sResourceName);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String line = br.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append("\r\n");
                line = br.readLine();
            }
            br.close();
            in.close();
            return buffer.toString();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String objectToString(Object objValue) {
        if (objValue == null) {
            return null;
        }
        if (objValue instanceof String) {
            return (String)objValue;
        }
        if (objValue instanceof byte[]) {
            return new String((byte[])objValue);
        }
        if (objValue instanceof Object[]) {
            Object[] objs = (Object[])objValue;
            StringBuilder sb = new StringBuilder();
            if (objs.length > 0) {
                for (int i = 0; i < objs.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    if (objs[i] == null) continue;
                    if (objs[i] instanceof Date) {
                        sb.append(DatetimeOpt.convertDatetimeToString((Date)objs[i]));
                        continue;
                    }
                    sb.append(objs[i].toString());
                }
                return sb.toString();
            }
            return null;
        }
        if (objValue instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            int vc = 0;
            Collection valueList = (Collection)objValue;
            for (Object ov : valueList) {
                if (ov == null) continue;
                if (vc > 0) {
                    sb.append(",");
                }
                if (ov instanceof Date) {
                    sb.append(DatetimeOpt.convertDatetimeToString((Date)ov));
                } else {
                    sb.append(ov.toString());
                }
                ++vc;
            }
            return sb.toString();
        }
        if (objValue instanceof Date) {
            return DatetimeOpt.convertDatetimeToString((Date)objValue);
        }
        return objValue.toString();
    }

    public static List<String> objectToStringList(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            ArrayList<String> stringList = new ArrayList<String>(((Collection)object).size() + 1);
            for (Object po : (Collection)object) {
                stringList.add(StringBaseOpt.castObjectToString(po));
            }
            return stringList;
        }
        if (object instanceof Object[]) {
            ArrayList<String> stringList = new ArrayList<String>(((Object[])object).length + 1);
            for (Object po : (Object[])object) {
                stringList.add(StringBaseOpt.castObjectToString(po));
            }
            return stringList;
        }
        ArrayList<String> stringList = new ArrayList<String>(1);
        stringList.add(StringBaseOpt.castObjectToString(object));
        return stringList;
    }

    public static String castObjectToString(Object obj) {
        return StringBaseOpt.objectToString(obj);
    }

    public static String castObjectToString(Object obj, String defaultValue) {
        return GeneralAlgorithm.nvl(StringBaseOpt.objectToString(obj), defaultValue);
    }

    public static <T> T stringToScalarData(String sdata, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)sdata)) {
            return null;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return (T)Integer.valueOf(sdata);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return (T)Long.valueOf(sdata);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return (T)Double.valueOf(sdata);
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return (T)Boolean.valueOf(sdata);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return (T)Float.valueOf(sdata);
        }
        if (clazz == String.class) {
            return (T)sdata;
        }
        if (clazz == Date.class) {
            return (T)DatetimeOpt.smartPraseDate(sdata);
        }
        if (clazz == UUID.class) {
            return (T)UUID.fromString(sdata);
        }
        return null;
    }
}

