/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.centit.support.algorithm.DatetimeOpt;
import java.util.Date;
import java.util.function.Supplier;

public class CachedObject<T> {
    private T target = null;
    private boolean evicted = true;
    private Date refreshTime;
    private long freshPeriod;
    private Supplier<T> refresher;

    public CachedObject(Supplier<T> refresher) {
        this.refresher = refresher;
        this.freshPeriod = 43200L;
    }

    public CachedObject(Supplier<T> refresher, long freshPeriod) {
        this.refresher = refresher;
        this.freshPeriod = freshPeriod;
    }

    public void setFreshPeriod(int freshPeriod) {
        this.freshPeriod = freshPeriod;
    }

    public synchronized void evictObject() {
        this.evicted = true;
    }

    public synchronized T getCachedObject() {
        if (this.target == null || this.evicted || System.currentTimeMillis() > this.refreshTime.getTime() + this.freshPeriod * 60000L) {
            this.target = this.refresher.get();
            this.refreshTime = DatetimeOpt.currentUtilDate();
            this.evicted = false;
        }
        return this.target;
    }
}

