/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.ReflectionOpt;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JSONOpt {
    protected static final Logger logger = LoggerFactory.getLogger(JSONOpt.class);

    private JSONOpt() {
        throw new IllegalAccessError("Utility class");
    }

    private static JSONKey praseJosnKey(String skey) {
        JSONKey key = new JSONKey();
        key.ind = -1;
        int nL = skey.indexOf(91);
        if (nL > 0) {
            key.skey = skey.substring(0, nL);
            int nR = skey.indexOf(93);
            key.ind = nR > nL + 1 ? Integer.parseInt(skey.substring(nL + 1, nR)) : 0;
        } else {
            key.skey = skey;
        }
        return key;
    }

    private static JSONPath findJsonObject(JSONObject objJson, int depth, String[] skeys) {
        JSONPath p = new JSONPath();
        int nLast = 0;
        JSONObject lastKeyJson = objJson;
        while (nLast < depth) {
            Object obj2;
            JSONArray jarray;
            JSONKey key = JSONOpt.praseJosnKey(skeys[nLast]);
            if (!lastKeyJson.containsKey((Object)key.skey)) break;
            Object obj = lastKeyJson.get((Object)key.skey);
            if (obj instanceof JSONObject) {
                if (key.ind >= 0) break;
                lastKeyJson = (JSONObject)obj;
                ++nLast;
                continue;
            }
            if (!(obj instanceof JSONArray) || key.ind < 0 || key.ind >= (jarray = (JSONArray)obj).size() || !((obj2 = jarray.get(key.ind)) instanceof JSONObject)) break;
            lastKeyJson = (JSONObject)obj2;
            ++nLast;
        }
        p.found = true;
        p.pathPos = nLast;
        p.objJson = lastKeyJson;
        return p;
    }

    public static JSONObject findJsonObject(JSONObject objJson, String[] skeys) {
        int depth = skeys.length;
        if (depth < 1) {
            return null;
        }
        JSONPath path = JSONOpt.findJsonObject(objJson, depth, skeys);
        if (path.pathPos != depth) {
            return null;
        }
        return path.objJson;
    }

    public static JSONObject findJsonObject(JSONObject objJson, String path) {
        String[] skeys = path.split("\\x2E");
        return JSONOpt.findJsonObject(objJson, skeys);
    }

    private static JSONObject createJsonObject(String[] skeys, int beginPos, Object value) {
        int depth = skeys.length;
        if (depth == 0) {
            return null;
        }
        int nLast = beginPos;
        JSONKey key = JSONOpt.praseJosnKey(skeys[depth - 1]);
        JSONObject leafKey = new JSONObject();
        if (key.ind < 0) {
            leafKey.put(key.skey, value);
        } else {
            JSONArray jarray = new JSONArray();
            for (int i = 0; i < key.ind; ++i) {
                jarray.add(i, null);
            }
            jarray.add(key.ind, value);
            leafKey.put(key.skey, (Object)jarray);
        }
        depth -= 2;
        while (depth >= nLast) {
            key = JSONOpt.praseJosnKey(skeys[depth]);
            JSONObject tempKey = new JSONObject();
            if (key.ind < 0) {
                tempKey.put(key.skey, (Object)leafKey);
            } else {
                JSONArray jarray = new JSONArray();
                for (int i = 0; i < key.ind; ++i) {
                    jarray.add(i, null);
                }
                jarray.add(key.ind, (Object)leafKey);
                tempKey.put(key.skey, (Object)jarray);
            }
            leafKey = tempKey;
            --depth;
        }
        return leafKey;
    }

    public static void setAttribute(JSONObject objJson, String path, Object value) {
        String[] skeys = path.split("\\x2E");
        int depth = skeys.length;
        if (depth == 0) {
            return;
        }
        JSONPath jpath = JSONOpt.findJsonObject(objJson, depth - 1, skeys);
        Object jsonValue = value;
        if (jpath.pathPos < depth - 1) {
            jsonValue = JSONOpt.createJsonObject(skeys, jpath.pathPos + 1, value);
        }
        JSONKey key = JSONOpt.praseJosnKey(skeys[jpath.pathPos]);
        if (key.ind < 0) {
            jpath.objJson.put(key.skey, jsonValue);
        } else if (jpath.objJson.containsKey((Object)key.skey)) {
            Object leafJson = jpath.objJson.get((Object)key.skey);
            if (leafJson instanceof JSONArray) {
                JSONArray jarray = (JSONArray)leafJson;
                if (jarray.size() < key.ind + 1) {
                    for (int i = jarray.size(); i < key.ind; ++i) {
                        jarray.add(i, null);
                    }
                    jarray.add(key.ind, jsonValue);
                } else if (jpath.pathPos == depth - 1 && jsonValue instanceof Map) {
                    Object obj = jarray.get(key.ind);
                    if (obj instanceof JSONObject) {
                        for (Map.Entry ent : ((Map)value).entrySet()) {
                            ((JSONObject)obj).put(ent.getKey().toString(), ent.getValue());
                        }
                    } else {
                        jarray.set(key.ind, jsonValue);
                    }
                } else {
                    jarray.set(key.ind, jsonValue);
                }
            } else {
                JSONArray jarray = new JSONArray();
                for (int i = 0; i < key.ind; ++i) {
                    jarray.add(i, null);
                }
                jarray.add(key.ind, jsonValue);
                jpath.objJson.put(key.skey, (Object)jarray);
            }
        } else {
            JSONArray jarray = new JSONArray();
            for (int i = 0; i < key.ind; ++i) {
                jarray.add(i, null);
            }
            jarray.add(key.ind, jsonValue);
            jpath.objJson.put(key.skey, (Object)jarray);
        }
    }

    public static void appendData(JSONObject objJson, String path, Object value) {
        String[] skeys = path.split("\\x2E");
        int depth = skeys.length;
        if (depth == 0) {
            return;
        }
        JSONPath jpath = JSONOpt.findJsonObject(objJson, depth - 1, skeys);
        Object jsonValue = value;
        if (jpath.pathPos < depth - 1) {
            jsonValue = JSONOpt.createJsonObject(skeys, jpath.pathPos + 1, value);
            JSONKey key = JSONOpt.praseJosnKey(skeys[jpath.pathPos]);
            if (key.ind < 0) {
                jpath.objJson.put(key.skey, jsonValue);
            } else {
                JSONArray jarray = new JSONArray();
                for (int i = 0; i < key.ind; ++i) {
                    jarray.add(i, null);
                }
                jarray.add(key.ind, jsonValue);
                jpath.objJson.put(key.skey, (Object)jarray);
            }
        } else {
            JSONKey key = JSONOpt.praseJosnKey(skeys[depth - 1]);
            if (jpath.objJson.containsKey((Object)key.skey)) {
                jpath.objJson.put(key.skey, value);
            } else if (key.ind < 0) {
                jpath.objJson.put(key.skey, value);
            } else {
                JSONArray jarray = new JSONArray();
                for (int i = 0; i < key.ind; ++i) {
                    jarray.add(i, null);
                }
                jarray.add(key.ind, value);
                jpath.objJson.put(key.skey, (Object)jarray);
            }
        }
    }

    public static void batchAppendData(JSONObject objJson, String path, Object[] values) {
        for (Object obj : values) {
            JSONOpt.appendData(objJson, path, obj);
        }
    }

    public static void batchAppendData(JSONObject objJson, String path, Collection<Object> values) {
        for (Object obj : values) {
            JSONOpt.appendData(objJson, path, obj);
        }
    }

    public static String objectToJSONString(Object obj) {
        return JSONOpt.objectToJSONString(obj, false, false);
    }

    public static String objectToJSONString(Object obj, boolean methodOnly, boolean fieldOnly) {
        return JSONOpt.objectToJSONString(obj, methodOnly, fieldOnly, false);
    }

    public static String objectToJSONString(Object obj, boolean methodOnly, boolean fieldOnly, boolean includePrivateField) {
        if (obj == null) {
            return null;
        }
        if (ReflectionOpt.isScalarType(obj.getClass())) {
            return obj.toString();
        }
        if (obj instanceof JSON) {
            return ((JSON)obj).toJSONString();
        }
        if (ReflectionOpt.isArray(obj)) {
            return JSONOpt.arrayToJSONArray(obj, methodOnly, fieldOnly, includePrivateField).toJSONString();
        }
        return JSONOpt.objectToJSONObject(obj, methodOnly, fieldOnly, includePrivateField).toJSONString();
    }

    public static Map<String, Object> objectToMap(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        if (ReflectionOpt.isScalarType(object.getClass())) {
            return JSONOpt.createHashMap("scalar", object);
        }
        return (JSONObject)JSON.toJSON((Object)object);
    }

    public static JSON objectToJSON(Object obj) {
        return JSONOpt.objectToJSON(obj, false, false);
    }

    public static JSON objectToJSON(Object obj, boolean methodOnly, boolean fieldOnly, boolean includePrivateField) {
        if (obj instanceof JSON) {
            return (JSON)obj;
        }
        if (ReflectionOpt.isArray(obj)) {
            return JSONOpt.arrayToJSONArray(obj, methodOnly, fieldOnly, includePrivateField);
        }
        return JSONOpt.objectToJSONObject(obj, methodOnly, fieldOnly, includePrivateField);
    }

    public static JSON objectToJSON(Object obj, boolean methodOnly, boolean fieldOnly) {
        return JSONOpt.objectToJSON(obj, methodOnly, fieldOnly, false);
    }

    public static JSONObject objectToJSONObject(Object obj) {
        return JSONOpt.objectToJSONObject(obj, false, false, false);
    }

    private static Object makeJSONValue(Object value, boolean methodOnly, boolean fieldOnly) {
        if (value == null) {
            return null;
        }
        if (ReflectionOpt.isScalarType(value.getClass())) {
            return value;
        }
        return JSONOpt.objectToJSON(value, methodOnly, fieldOnly);
    }

    public static JSONObject objectToJSONObject(Object obj, boolean methodOnly, boolean fieldOnly, boolean includePrivateField) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        JSONObject jObj = new JSONObject();
        if (ReflectionOpt.isScalarType(obj.getClass())) {
            jObj.put("value", (Object)obj.toString());
            return jObj;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry ent : map.entrySet()) {
                jObj.put(ent.getKey().toString(), JSONOpt.makeJSONValue(ent.getValue(), methodOnly, fieldOnly));
            }
            return jObj;
        }
        ArrayList<String> methodNames = new ArrayList<String>();
        List<Method> getMethods = ReflectionOpt.getAllGetterMethod(obj.getClass());
        if (!fieldOnly && getMethods != null) {
            for (Method m : getMethods) {
                String fieldName = ReflectionOpt.methodNameToField(m.getName());
                methodNames.add(fieldName);
                Object value = null;
                try {
                    value = m.invoke(obj, new Object[0]);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                jObj.put(fieldName, JSONOpt.makeJSONValue(value, methodOnly, fieldOnly));
            }
        }
        Field[] fls = ReflectionOpt.getFields(obj);
        if (!methodOnly && fls != null) {
            for (Field fl : fls) {
                if (methodNames.contains(fl.getName()) || !includePrivateField && !Modifier.isPublic(fl.getModifiers())) continue;
                Object value = ReflectionOpt.forceGetFieldValue(obj, fl);
                jObj.put(fl.getName(), JSONOpt.makeJSONValue(value, methodOnly, fieldOnly));
            }
        }
        if (!(fls != null && fls.length >= 1 || getMethods != null && getMethods.size() >= 1)) {
            jObj.put("value", (Object)obj.toString());
        }
        return jObj;
    }

    public static JSONObject objectToJSONObject(Object obj, boolean methodOnly, boolean fieldOnly) {
        return JSONOpt.objectToJSONObject(obj, methodOnly, fieldOnly, false);
    }

    public static JSONArray arrayToJSONArray(Object obj) {
        return JSONOpt.arrayToJSONArray(obj, false, false, false);
    }

    public static JSONArray arrayToJSONArray(Object objArray, boolean methodOnly, boolean fieldOnly, boolean includePrivateField) {
        JSONArray jArray;
        block10: {
            char[] objList;
            block15: {
                double[] objList2;
                block14: {
                    float[] objList3;
                    block13: {
                        long[] objList4;
                        block12: {
                            int[] objList5;
                            block11: {
                                block9: {
                                    Object[] objList6;
                                    if (objArray == null) {
                                        return null;
                                    }
                                    if (objArray instanceof JSONArray) {
                                        return (JSONArray)objArray;
                                    }
                                    jArray = new JSONArray();
                                    if (!(objArray instanceof Object[])) break block9;
                                    for (Object obj : objList6 = (Object[])objArray) {
                                        jArray.add(JSONOpt.makeJSONValue(obj, methodOnly, fieldOnly));
                                    }
                                    break block10;
                                }
                                if (!(objArray instanceof Collection)) break block11;
                                Collection objList7 = (Collection)objArray;
                                for (Object obj : objList7) {
                                    jArray.add(JSONOpt.makeJSONValue(obj, methodOnly, fieldOnly));
                                }
                                break block10;
                            }
                            if (!int[].class.equals(objArray.getClass())) break block12;
                            for (int obj : objList5 = (int[])objArray) {
                                jArray.add((Object)obj);
                            }
                            break block10;
                        }
                        if (!long[].class.equals(objArray.getClass())) break block13;
                        for (long obj : objList4 = (long[])objArray) {
                            jArray.add((Object)obj);
                        }
                        break block10;
                    }
                    if (!float[].class.equals(objArray.getClass())) break block14;
                    for (float obj : objList3 = (float[])objArray) {
                        jArray.add((Object)Float.valueOf(obj));
                    }
                    break block10;
                }
                if (!double[].class.equals(objArray.getClass())) break block15;
                for (double obj : objList2 = (double[])objArray) {
                    jArray.add((Object)obj);
                }
                break block10;
            }
            if (!char[].class.equals(objArray.getClass())) break block10;
            for (char obj : objList = (char[])objArray) {
                jArray.add((Object)Character.valueOf(obj));
            }
        }
        return jArray;
    }

    public static JSONArray arrayToJSONArray(Object objArray, boolean methodOnly, boolean fieldOnly) {
        return JSONOpt.arrayToJSONArray(objArray, methodOnly, fieldOnly, false);
    }

    public static Map<String, Object> createHashMap(Object ... objs) {
        if (objs == null || objs.length < 2) {
            return null;
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(objs.length);
        for (int i = 0; i < objs.length / 2; ++i) {
            paramsMap.put(String.valueOf(objs[i * 2]), objs[i * 2 + 1]);
        }
        return paramsMap;
    }

    public static JSONObject createJSONObject(Object ... objs) {
        if (objs == null || objs.length < 2) {
            return null;
        }
        JSONObject paramsMap = new JSONObject(objs.length);
        for (int i = 0; i < objs.length / 2; ++i) {
            paramsMap.put(String.valueOf(objs[i * 2]), objs[i * 2 + 1]);
        }
        return paramsMap;
    }

    public static JSONArray createJSONOArray(Object ... objs) {
        if (objs == null || objs.length < 1) {
            return null;
        }
        JSONArray ja = new JSONArray(objs.length);
        for (int i = 0; i < objs.length; ++i) {
            ja.add((Object)JSONOpt.objectToJSON(objs[i]));
        }
        return ja;
    }

    public static JSONObject mergeJSONObjectt(JSONObject json1, JSONObject json2) {
        JSONObject json = new JSONObject();
        json.putAll((Map)json1);
        json.putAll((Map)json2);
        return json;
    }

    static class JSONKey {
        String skey;
        int ind;

        JSONKey() {
        }
    }

    static class JSONPath {
        JSONObject objJson;
        String path;
        boolean found;
        int pathPos;

        JSONPath() {
        }
    }
}

