/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassScannerOpt {
    protected static final Logger logger = LoggerFactory.getLogger(ClassScannerOpt.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Class<?>> getClassList(String pkgName, boolean isRecursive, Class<? extends Annotation> annotation) {
        ArrayList classList = new ArrayList();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            String strFile = pkgName.replaceAll("\\.", "/");
            Enumeration<URL> urls = loader.getResources(strFile);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                String protocol = url.getProtocol();
                String pkgPath = url.getPath();
                if ("file".equals(protocol)) {
                    ClassScannerOpt.findClassName(classList, pkgName, pkgPath, isRecursive, annotation);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                ClassScannerOpt.findClassName(classList, pkgName, url, isRecursive, annotation);
            }
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage());
        }
        finally {
            loader.clearAssertionStatus();
        }
        return classList;
    }

    public static void findClassName(List<Class<?>> clazzList, String pkgName, String pkgPath, boolean isRecursive, Class<? extends Annotation> annotation) {
        if (clazzList == null) {
            return;
        }
        File[] files = ClassScannerOpt.filterClassFiles(pkgPath);
        if (files != null) {
            for (File f : files) {
                String fileName = f.getName();
                if (f.isFile()) {
                    String clazzName = ClassScannerOpt.getClassName(pkgName, fileName);
                    ClassScannerOpt.addClassName(clazzList, clazzName, annotation);
                    continue;
                }
                if (!isRecursive) continue;
                String subPkgName = pkgName + "." + fileName;
                String subPkgPath = pkgPath + "/" + fileName;
                ClassScannerOpt.findClassName(clazzList, subPkgName, subPkgPath, true, annotation);
            }
        }
    }

    public static void findClassName(List<Class<?>> clazzList, String pkgName, URL url, boolean isRecursive, Class<? extends Annotation> annotation) throws IOException {
        JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
        JarFile jarFile = jarURLConnection.getJarFile();
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            String prefix_name;
            JarEntry jarEntry = jarEntries.nextElement();
            String jarEntryName = jarEntry.getName();
            String clazzName = jarEntryName.replace("/", ".");
            int endIndex = clazzName.lastIndexOf(".");
            String prefix = null;
            if (endIndex > 0 && (endIndex = (prefix_name = clazzName.substring(0, endIndex)).lastIndexOf(".")) > 0) {
                prefix = prefix_name.substring(0, endIndex);
            }
            if (prefix == null || !jarEntryName.endsWith(".class")) continue;
            if (prefix.equals(pkgName)) {
                ClassScannerOpt.addClassName(clazzList, clazzName, annotation);
                continue;
            }
            if (!isRecursive || !prefix.startsWith(pkgName)) continue;
            ClassScannerOpt.addClassName(clazzList, clazzName, annotation);
        }
    }

    private static File[] filterClassFiles(String pkgPath) {
        if (pkgPath == null) {
            return null;
        }
        return new File(pkgPath).listFiles(file -> file.isFile() && file.getName().endsWith(".class") || file.isDirectory());
    }

    private static String getClassName(String fileName) {
        if (fileName.endsWith(".class")) {
            return fileName.substring(0, fileName.length() - 6);
        }
        return fileName;
    }

    private static String getClassName(String pkgName, String fileName) {
        int endIndex = fileName.lastIndexOf(".");
        String clazz = null;
        if (endIndex >= 0) {
            clazz = fileName.substring(0, endIndex);
        }
        String clazzName = null;
        if (clazz != null) {
            clazzName = pkgName + "." + clazz;
        }
        return clazzName;
    }

    private static void addClassName(List<Class<?>> clazzList, String clazzName, Class<? extends Annotation> annotation) {
        if (clazzList != null && clazzName != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(ClassScannerOpt.getClassName(clazzName));
            }
            catch (ClassNotFoundException e) {
                logger.error("load " + clazzName + " error:" + e.getLocalizedMessage());
            }
            if (clazz != null) {
                if (annotation == null) {
                    clazzList.add(clazz);
                } else if (clazz.isAnnotationPresent(annotation)) {
                    clazzList.add(clazz);
                }
            }
        }
    }
}

