/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import com.centit.support.algorithm.DatetimeOpt;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class Lunar {
    private int year;
    private int month;
    private int day;
    private boolean leap;
    private static final String[] chineseNumber = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c"};
    static final long[] lunarInfo = new long[]{19416L, 19168L, 42352L, 21717L, 53856L, 55632L, 91476L, 22176L, 39632L, 21970L, 19168L, 42422L, 42192L, 53840L, 119381L, 46400L, 54944L, 44450L, 38320L, 84343L, 18800L, 42160L, 46261L, 27216L, 27968L, 109396L, 11104L, 38256L, 21234L, 18800L, 25958L, 54432L, 59984L, 28309L, 23248L, 11104L, 100067L, 37600L, 116951L, 51536L, 54432L, 120998L, 46416L, 22176L, 107956L, 9680L, 37584L, 53938L, 43344L, 46423L, 27808L, 46416L, 86869L, 19872L, 42448L, 83315L, 21200L, 43432L, 59728L, 27296L, 44710L, 43856L, 19296L, 43748L, 42352L, 21088L, 62051L, 55632L, 23383L, 22176L, 38608L, 19925L, 19152L, 42192L, 54484L, 53840L, 54616L, 46400L, 46496L, 103846L, 38320L, 18864L, 43380L, 42160L, 45690L, 27216L, 27968L, 44870L, 43872L, 38256L, 19189L, 18800L, 25776L, 29859L, 59984L, 27480L, 21952L, 43872L, 38613L, 37600L, 51552L, 55636L, 54432L, 55888L, 30034L, 22176L, 43959L, 9680L, 37584L, 51893L, 43344L, 46240L, 47780L, 44368L, 21977L, 19360L, 42416L, 86390L, 21168L, 43312L, 31060L, 27296L, 44368L, 23378L, 19296L, 42726L, 42208L, 53856L, 60005L, 54576L, 23200L, 30371L, 38608L, 19415L, 19152L, 42192L, 118966L, 53840L, 54560L, 56645L, 46496L, 22224L, 21938L, 18864L, 42359L, 42160L, 43600L, 111189L, 27936L, 44448L};

    private static final int yearDays(int y) {
        int sum = 348;
        for (int i = 32768; i > 8; i >>= 1) {
            if ((lunarInfo[y - 1900] & (long)i) == 0L) continue;
            ++sum;
        }
        return sum + Lunar.leapDays(y);
    }

    private static final int leapDays(int y) {
        if (Lunar.leapMonth(y) != 0) {
            if ((lunarInfo[y - 1900] & 0x10000L) != 0L) {
                return 30;
            }
            return 29;
        }
        return 0;
    }

    private static final int leapMonth(int y) {
        return (int)(lunarInfo[y - 1900] & 0xFL);
    }

    private static final int monthDays(int y, int m) {
        if ((lunarInfo[y - 1900] & (long)(65536 >> m)) == 0L) {
            return 29;
        }
        return 30;
    }

    public final String animalsYear() {
        String[] Animals = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
        return Animals[(this.year - 4) % 12];
    }

    private static final String cyclicalm(int num) {
        int yno = num - 4;
        String[] Gan = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
        String[] Zhi = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
        return Gan[yno % 10] + Zhi[yno % 12];
    }

    public final String cyclical() {
        int num = this.year - 1900 + 36;
        return Lunar.cyclicalm(num);
    }

    public Lunar() {
        this.year = 2009;
        this.month = 6;
        this.day = 18;
    }

    public Lunar(Calendar cal) {
        this.setCalendar(cal);
    }

    public Lunar(Date dt) {
        this.setDate(dt);
    }

    public void setDate(Date dt) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(dt);
        this.setCalendar(cal);
    }

    public void setCalendar(Calendar cal) {
        int iMonth;
        int iYear;
        int leapMonth = 0;
        Date baseDate = DatetimeOpt.createUtilDate(1900, 1, 31);
        int offset = (int)((cal.getTime().getTime() - baseDate.getTime()) / 86400000L);
        int daysOfYear = 0;
        for (iYear = 1900; iYear < 2050 && offset > 0; offset -= daysOfYear, ++iYear) {
            daysOfYear = Lunar.yearDays(iYear);
        }
        if (offset < 0) {
            offset += daysOfYear;
            --iYear;
        }
        this.year = iYear;
        leapMonth = Lunar.leapMonth(iYear);
        this.leap = false;
        int daysOfMonth = 0;
        for (iMonth = 1; iMonth < 13 && offset > 0; ++iMonth) {
            if (leapMonth > 0 && iMonth == leapMonth + 1 && !this.leap) {
                --iMonth;
                this.leap = true;
                daysOfMonth = Lunar.leapDays(this.year);
            } else {
                daysOfMonth = Lunar.monthDays(this.year, iMonth);
            }
            offset -= daysOfMonth;
            if (!this.leap || iMonth != leapMonth + 1) continue;
            this.leap = false;
        }
        if (offset == 0 && leapMonth > 0 && iMonth == leapMonth + 1) {
            if (this.leap) {
                this.leap = false;
            } else {
                this.leap = true;
                --iMonth;
            }
        }
        if (offset < 0) {
            offset += daysOfMonth;
            --iMonth;
        }
        this.month = iMonth;
        this.day = offset + 1;
    }

    public static String getChinaDayString(int day) {
        int n;
        String[] chineseTen = new String[]{"\u521d", "\u5341", "\u5eff", "\u5345"};
        int n2 = n = day % 10 == 0 ? 9 : day % 10 - 1;
        if (day > 30) {
            return "";
        }
        if (day == 10) {
            return "\u521d\u5341";
        }
        return chineseTen[day / 10] + chineseNumber[n];
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public boolean isLeap() {
        return this.leap;
    }

    public String toString() {
        return Lunar.cyclicalm(this.year) + "\u5e74" + (this.leap ? "\u95f0" : "") + chineseNumber[this.month - 1] + "\u6708" + Lunar.getChinaDayString(this.day);
    }

    public String getLunarDay() {
        return Lunar.getChinaDayString(this.day);
    }

    public String getLunarMonth() {
        return (this.leap ? "\u95f0" : "") + chineseNumber[this.month - 1] + "\u6708";
    }

    public String getLunarYear() {
        return Lunar.cyclicalm(this.year) + "\u5e74";
    }
}

