/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.common.AbstractCachedObject;
import java.util.Date;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachedObject<T>
extends AbstractCachedObject<T> {
    private static Log logger = LogFactory.getLog(CachedObject.class);
    private Supplier<T> refresher;
    private Date refreshTime;
    private long freshPeriod;
    private T target;

    public CachedObject() {
    }

    public CachedObject(Supplier<T> refresher) {
        this.target = null;
        this.evicted = true;
        this.refresher = refresher;
        this.freshPeriod = 2592000L;
    }

    public CachedObject(Supplier<T> refresher, int freshPeriod) {
        this.target = null;
        this.evicted = true;
        this.refresher = refresher;
        this.freshPeriod = freshPeriod;
    }

    public CachedObject(Supplier<T> refresher, AbstractCachedObject<?> parentCache) {
        this.target = null;
        this.evicted = true;
        this.refresher = refresher;
        parentCache.addDeriveCache(this);
        this.freshPeriod = 2592000L;
    }

    public CachedObject(Supplier<T> refresher, AbstractCachedObject<?>[] parentCaches) {
        this.target = null;
        this.evicted = true;
        this.refresher = refresher;
        for (AbstractCachedObject<?> parentCache : parentCaches) {
            parentCache.addDeriveCache(this);
        }
        this.freshPeriod = 2592000L;
    }

    public void setFreshPeriod(int freshPeriod) {
        this.freshPeriod = freshPeriod;
    }

    private synchronized void refreshData() {
        this.evictDerivativeCahce();
        Object tempTarget = null;
        try {
            tempTarget = this.refresher.get();
        }
        catch (RuntimeException re) {
            logger.error((Object)re.getLocalizedMessage());
        }
        if (tempTarget != null) {
            this.target = tempTarget;
            this.refreshTime = DatetimeOpt.currentUtilDate();
            this.evicted = false;
        }
    }

    public T getCachedTarget() {
        if (this.target == null || this.evicted || System.currentTimeMillis() > this.refreshTime.getTime() + this.freshPeriod * 1000L) {
            this.refreshData();
        }
        return this.target;
    }

    public T getFreshTarget() {
        this.refreshData();
        return this.target;
    }

    @Override
    public T getRawTarget() {
        return this.target;
    }

    public void setRefresher(Supplier<T> refresher) {
        this.refresher = refresher;
    }

    public synchronized void setFreshtDate(T freshData) {
        this.target = freshData;
        this.refreshTime = DatetimeOpt.currentUtilDate();
        this.evicted = false;
    }
}

