/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.common.AbstractCachedObject;
import com.centit.support.common.CachedMap;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DerivativeCachedMap<K, D, T>
extends AbstractCachedObject<Map<K, T>> {
    private static Log logger = LogFactory.getLog(DerivativeCachedMap.class);
    private ConcurrentMap<K, CachedIdentifiedObject> targetMap;
    private long freshPeriod;
    private Function<D, T> refresher;
    private CachedMap<K, D> parentCachedMap;

    public DerivativeCachedMap(Function<D, T> refresher, CachedMap<K, D> parentCache, int initialCapacity) {
        this.targetMap = new ConcurrentHashMap<K, CachedIdentifiedObject>(initialCapacity);
        this.refresher = refresher;
        this.parentCachedMap = parentCache;
        parentCache.addDeriveCache(this);
        this.freshPeriod = 2592000L;
    }

    public DerivativeCachedMap(Function<D, T> refresher, CachedMap<K, D> parentCache) {
        this(refresher, parentCache, 16);
    }

    public void setRefresher(Function<D, T> refresher) {
        this.refresher = refresher;
    }

    public void setFreshPeriod(int freshPeriod) {
        this.freshPeriod = freshPeriod;
    }

    public void evictIdentifiedCache(K key) {
        CachedIdentifiedObject identifiedObject = (CachedIdentifiedObject)this.targetMap.get(key);
        if (identifiedObject != null) {
            identifiedObject.evictCahce();
        }
    }

    @Override
    public void evictCahce() {
        this.targetMap.clear();
        super.evictCahce();
    }

    public T getCachedValue(K key) {
        CachedIdentifiedObject identifiedObject = (CachedIdentifiedObject)this.targetMap.get(key);
        if (identifiedObject != null) {
            return identifiedObject.getCachedTarget(key);
        }
        identifiedObject = new CachedIdentifiedObject();
        Object target = identifiedObject.getFreshTarget(key);
        if (target != null) {
            this.targetMap.put(key, identifiedObject);
        }
        return target;
    }

    @Override
    public Map<K, T> getRawTarget() {
        if (this.targetMap == null) {
            return null;
        }
        HashMap rawTargetMap = new HashMap(this.targetMap.size() + 1);
        for (Map.Entry ent : this.targetMap.entrySet()) {
            rawTargetMap.put(ent.getKey(), ((CachedIdentifiedObject)ent.getValue()).getRawTarget());
        }
        return rawTargetMap;
    }

    class CachedIdentifiedObject
    extends AbstractCachedObject<T> {
        private Date refreshTime;
        private T target = null;
        private AbstractCachedObject<D> parentCache;

        CachedIdentifiedObject() {
            this.evicted = true;
            this.parentCache = null;
        }

        synchronized void refreshData(K key) {
            if (this.parentCache == null) {
                this.parentCache = DerivativeCachedMap.this.parentCachedMap.getCachedObject(key);
                if (this.parentCache != null) {
                    this.parentCache.addDeriveCache(this);
                } else {
                    return;
                }
            }
            Object tempTarget = null;
            try {
                tempTarget = DerivativeCachedMap.this.refresher.apply(DerivativeCachedMap.this.parentCachedMap.getCachedValue(key));
            }
            catch (RuntimeException re) {
                logger.error((Object)re.getLocalizedMessage());
            }
            if (tempTarget != null) {
                this.target = tempTarget;
                this.refreshTime = DatetimeOpt.currentUtilDate();
                this.evicted = false;
            }
        }

        T getCachedTarget(K key) {
            if (this.target == null || this.evicted || System.currentTimeMillis() > this.refreshTime.getTime() + DerivativeCachedMap.this.freshPeriod * 1000L) {
                this.refreshData(key);
            }
            return this.target;
        }

        T getFreshTarget(K key) {
            this.refreshData(key);
            return this.target;
        }

        @Override
        public T getRawTarget() {
            return this.target;
        }
    }
}

