/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.json;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JsonPropertyPreFilters
implements PropertyPreFilter {
    private Set<Class<?>> clazzs;
    private Map<Class<?>, Set<String>> excludes = new HashMap();

    public JsonPropertyPreFilters(Class<?>[] clazzs) {
        this.clazzs = new HashSet();
        for (Class<?> clazz : clazzs) {
            this.clazzs.add(clazz);
        }
    }

    public JsonPropertyPreFilters() {
    }

    public boolean apply(JSONSerializer serializer, Object object, String name) {
        if (object == null) {
            return true;
        }
        for (Class<?> clazz : this.clazzs) {
            if (!clazz.isInstance(object) || !this.excludes.get(clazz).contains(name)) continue;
            return false;
        }
        return true;
    }

    public void addExclude(Class<?> clazz, String exclude) {
        Set<Object> fields;
        if (this.excludes.get(clazz) == null) {
            fields = new HashSet();
            this.excludes.put(clazz, fields);
        }
        fields = this.excludes.get(clazz);
        fields.add(exclude);
    }
}

