/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.network;

import com.alibaba.fastjson.JSON;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.file.FileSystemOpt;
import com.centit.support.json.JSONOpt;
import com.centit.support.network.HttpExecutorContext;
import com.centit.support.network.UrlOptUtils;
import com.centit.support.network.Utf8ResponseHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpExecutor {
    protected static final Logger logger = LoggerFactory.getLogger(HttpExecutor.class);
    public static final ContentType APPLICATION_FORM_URLENCODED = ContentType.create((String)"application/x-www-form-urlencoded", (Charset)Consts.UTF_8);
    public static final String BOUNDARY = "------1cC9oE7dN8eT1fI0aT2n4------";
    public static final String multiPartTypeHead = "multipart/form-data; charset=UTF-8; boundary=------1cC9oE7dN8eT1fI0aT2n4------";
    public static final String applicationFormHead = "application/x-www-form-urlencoded; charset=UTF-8";
    public static final String multiPartApplicationFormHead = "multipart/x-www-form-urlencoded; charset=UTF-8; boundary=------1cC9oE7dN8eT1fI0aT2n4------";
    public static final String applicationJSONHead = ContentType.create((String)"application/json", (Charset)Consts.UTF_8).toString();
    public static final String plainTextHead = ContentType.create((String)"text/plain", (Charset)Consts.UTF_8).toString();
    public static final String xmlTextHead = ContentType.create((String)"text/xml", (Charset)Consts.UTF_8).toString();
    public static final String applicationOctetStream = ContentType.create((String)"application/octet-stream", (Charset)null).toString();
    private static TrustManager manager = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };

    private HttpExecutor() {
        throw new IllegalAccessError("Utility class");
    }

    public static CloseableHttpClient createHttpClient(HttpHost httpProxy, boolean keepSession, boolean useSSL) throws NoSuchAlgorithmException, KeyManagementException {
        HttpClientBuilder clientBuilder = HttpClients.custom();
        if (useSSL) {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{manager}, null);
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(context, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)socketFactory).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        }
        if (keepSession) {
            RequestConfig config = RequestConfig.custom().setCookieSpec("netscape").build();
            clientBuilder.setDefaultRequestConfig(config);
        }
        if (httpProxy != null) {
            clientBuilder.setProxy(httpProxy);
        }
        return clientBuilder.build();
    }

    public static CloseableHttpClient createHttpClient() {
        return HttpClients.createDefault();
    }

    public static CloseableHttpClient createHttpClient(HttpHost httpProxy) {
        return HttpClients.custom().setProxy(httpProxy).build();
    }

    public static CloseableHttpClient createKeepSessionHttpClient() {
        RequestConfig config = RequestConfig.custom().setCookieSpec("netscape").build();
        return HttpClients.custom().setDefaultRequestConfig(config).build();
    }

    public static CloseableHttpClient createKeepSessionHttpClient(HttpHost httpProxy) {
        RequestConfig config = RequestConfig.custom().setCookieSpec("netscape").build();
        return HttpClients.custom().setDefaultRequestConfig(config).setProxy(httpProxy).build();
    }

    public static CloseableHttpClient createHttpsClient() throws NoSuchAlgorithmException, KeyManagementException {
        return HttpExecutor.createHttpClient(null, false, true);
    }

    public static CloseableHttpClient createKeepSessionHttpsClient() throws NoSuchAlgorithmException, KeyManagementException {
        return HttpExecutor.createHttpClient(null, true, true);
    }

    /*
     * Loose catch block
     */
    public static <T> T httpExecute(HttpExecutorContext executorContext, HttpRequestBase httpRequest, ResponseHandler<T> responseHandler) throws IOException {
        boolean createSelfClient;
        if (executorContext.getHttpHeaders() != null) {
            for (Map.Entry<String, String> entHeader : executorContext.getHttpHeaders().entrySet()) {
                httpRequest.setHeader(entHeader.getKey(), entHeader.getValue());
            }
        }
        if (executorContext.getHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy(executorContext.getHttpProxy()).build();
            httpRequest.setConfig(config);
        }
        CloseableHttpClient httpClient = null;
        boolean bl = createSelfClient = executorContext.getHttpclient() == null;
        httpClient = createSelfClient ? (executorContext.getHttpProxy() == null ? HttpExecutor.createHttpClient() : HttpExecutor.createHttpClient(executorContext.getHttpProxy())) : executorContext.getHttpclient();
        try {
            Object object;
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpRequest, executorContext.getHttpContext());){
                object = responseHandler.handleResponse((HttpResponse)response);
            }
            return (T)object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (createSelfClient) {
                httpClient.close();
            }
        }
    }

    public static String httpExecute(HttpExecutorContext executorContext, HttpRequestBase httpRequest) throws IOException {
        return HttpExecutor.httpExecute(executorContext, httpRequest, Utf8ResponseHandler.INSTANCE);
    }

    public static String simpleGet(HttpExecutorContext executorContext, String uri, String queryParam) throws IOException {
        HttpGet httpGet = new HttpGet(UrlOptUtils.appendParamToUrl(uri, queryParam));
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpGet);
    }

    public static String simpleGet(HttpExecutorContext executorContext, String uri, Map<String, Object> queryParam) throws IOException {
        HttpGet httpGet = new HttpGet(UrlOptUtils.appendParamsToUrl(uri, queryParam));
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpGet);
    }

    public static String simpleGet(HttpExecutorContext executorContext, String uri) throws IOException {
        return HttpExecutor.simpleGet(executorContext, uri, (String)null);
    }

    public static String simpleDelete(HttpExecutorContext executorContext, String uri, String queryParam) throws IOException {
        HttpDelete httpDelete = new HttpDelete(UrlOptUtils.appendParamToUrl(uri, queryParam));
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpDelete);
    }

    public static String simplePut(HttpExecutorContext executorContext, String uri, String putEntity) throws IOException {
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setHeader("Content-Type", plainTextHead);
        if (putEntity != null) {
            StringEntity entity = new StringEntity(putEntity, Consts.UTF_8);
            httpPut.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpPut);
    }

    public static String rawPut(HttpExecutorContext executorContext, String uri, byte[] bytes) throws IOException {
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setHeader("Content-Type", applicationFormHead);
        if (bytes != null) {
            ByteArrayEntity entity = new ByteArrayEntity(bytes);
            httpPut.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpPut);
    }

    public static String requestInputStreamPut(HttpExecutorContext executorContext, String uri, InputStream putIS) throws IOException {
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setHeader("Content-Type", applicationFormHead);
        if (putIS != null) {
            InputStreamEntity entity = new InputStreamEntity(putIS);
            httpPut.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpPut);
    }

    public static List<NameValuePair> makeRequectParams(Object obj, String prefixName) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (obj == null) {
            return params;
        }
        if (ReflectionOpt.isScalarType(obj.getClass())) {
            params.add((NameValuePair)new BasicNameValuePair(prefixName, StringBaseOpt.objectToString(obj)));
            return params;
        }
        if (obj instanceof NameValuePair) {
            params.add((NameValuePair)obj);
            return params;
        }
        if (obj instanceof Map) {
            String sFN = prefixName == null || "".equals(prefixName) ? "" : prefixName + ".";
            Map objMap = (Map)obj;
            for (Map.Entry f : objMap.entrySet()) {
                if (f.getValue() == null) continue;
                List<NameValuePair> subNP = HttpExecutor.makeRequectParams(f.getValue(), sFN + (String)f.getKey());
                params.addAll(subNP);
            }
            return params;
        }
        if (obj instanceof Collection) {
            Collection objList = (Collection)obj;
            if (objList.size() == 1) {
                Object subObj = objList.iterator().next();
                if (subObj != null) {
                    if (ReflectionOpt.isScalarType(subObj.getClass())) {
                        params.add((NameValuePair)new BasicNameValuePair(prefixName, StringBaseOpt.objectToString(obj)));
                    } else if (subObj instanceof NameValuePair) {
                        params.add((NameValuePair)subObj);
                    } else {
                        List<NameValuePair> subNP = HttpExecutor.makeRequectParams(subObj, prefixName);
                        params.addAll(subNP);
                    }
                }
            } else if (objList.size() > 1) {
                int n = 0;
                for (Object subObj : objList) {
                    if (subObj != null) {
                        if (ReflectionOpt.isScalarType(subObj.getClass())) {
                            params.add((NameValuePair)new BasicNameValuePair(prefixName, StringBaseOpt.objectToString(subObj)));
                        } else if (subObj instanceof NameValuePair) {
                            params.add((NameValuePair)subObj);
                        } else {
                            List<NameValuePair> subNP = HttpExecutor.makeRequectParams(subObj, prefixName + "[" + n + "]");
                            params.addAll(subNP);
                        }
                    }
                    ++n;
                }
            }
            return params;
        }
        if (obj instanceof Object[]) {
            Object[] objs = (Object[])obj;
            if (objs.length == 1) {
                Object subobj = objs[0];
                if (subobj != null) {
                    if (ReflectionOpt.isScalarType(subobj.getClass())) {
                        params.add((NameValuePair)new BasicNameValuePair(prefixName, StringBaseOpt.objectToString(obj)));
                    } else if (subobj instanceof NameValuePair) {
                        params.add((NameValuePair)subobj);
                    } else {
                        List<NameValuePair> subNP = HttpExecutor.makeRequectParams(subobj, prefixName);
                        params.addAll(subNP);
                    }
                }
            } else if (objs.length > 1) {
                for (int i = 0; i < objs.length; ++i) {
                    if (objs[i] == null) continue;
                    if (ReflectionOpt.isScalarType(objs[i].getClass())) {
                        params.add((NameValuePair)new BasicNameValuePair(prefixName, StringBaseOpt.objectToString(objs[i])));
                        continue;
                    }
                    if (objs[i] instanceof NameValuePair) {
                        params.add((NameValuePair)objs[i]);
                        continue;
                    }
                    List<NameValuePair> subNP = HttpExecutor.makeRequectParams(objs[i], prefixName + "[" + i + "]");
                    params.addAll(subNP);
                }
            }
            return params;
        }
        List<Method> methods = ReflectionOpt.getAllGetterMethod(obj.getClass());
        String sFN = prefixName == null || "".equals(prefixName) ? "" : prefixName + ".";
        for (Method md : methods) {
            try {
                Object v = md.invoke(obj, new Object[0]);
                if (v == null) continue;
                String skey = ReflectionOpt.methodNameToField(md.getName());
                List<NameValuePair> subNP = HttpExecutor.makeRequectParams(v, sFN + skey);
                params.addAll(subNP);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return params;
    }

    public static List<NameValuePair> makeRequectParams(Object obj) {
        return HttpExecutor.makeRequectParams(obj, "");
    }

    public static String formPut(HttpExecutorContext executorContext, String uri, Object formData) throws IOException {
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setHeader("Content-Type", applicationFormHead);
        if (formData != null) {
            EntityBuilder eb = EntityBuilder.create();
            eb.setContentType(APPLICATION_FORM_URLENCODED);
            eb.setContentEncoding("utf-8");
            List<NameValuePair> params = HttpExecutor.makeRequectParams(formData, "");
            eb.setParameters(params);
            httpPut.setEntity(eb.build());
        }
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpPut);
    }

    public static String multiFormPut(HttpExecutorContext executorContext, String uri, Object[] formObjects, Map<String, Object> extFormObjects) throws IOException {
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setHeader("Content-Type", applicationFormHead);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (formObjects != null) {
            for (int i = 0; i < formObjects.length; ++i) {
                if (formObjects[i] == null) continue;
                List<NameValuePair> subNP = HttpExecutor.makeRequectParams(formObjects[i], "");
                params.addAll(subNP);
            }
        }
        if (extFormObjects != null) {
            List<NameValuePair> subNP = HttpExecutor.makeRequectParams(extFormObjects, "");
            params.addAll(subNP);
        }
        EntityBuilder eb = EntityBuilder.create();
        eb.setContentType(APPLICATION_FORM_URLENCODED);
        eb.setContentEncoding("utf-8");
        eb.setParameters(params);
        httpPut.setEntity(eb.build());
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpPut);
    }

    public static String multiFormPut(HttpExecutorContext executorContext, String uri, Object formObject, Map<String, Object> extFormObjects) throws IOException {
        return HttpExecutor.multiFormPut(executorContext, uri, new Object[]{formObject}, extFormObjects);
    }

    public static String simplePost(HttpExecutorContext executorContext, String uri, String postEntity, boolean asPutMethod) throws IOException {
        HttpPost httpPost = new HttpPost(asPutMethod ? HttpExecutor.urlAddMethodParameter(uri, "PUT") : uri);
        httpPost.setHeader("Content-Type", plainTextHead);
        if (postEntity != null) {
            StringEntity entity = new StringEntity(postEntity, Consts.UTF_8);
            httpPost.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpPost);
    }

    public static String simplePost(HttpExecutorContext executorContext, String uri, String postEntity) throws IOException {
        return HttpExecutor.simplePost(executorContext, uri, postEntity, false);
    }

    public static String requestInputStreamPost(HttpExecutorContext executorContext, String uri, InputStream postIS) throws IOException {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader("Content-Type", applicationFormHead);
        if (postIS != null) {
            InputStreamEntity entity = new InputStreamEntity(postIS);
            httpPost.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpPost);
    }

    public static String rawPost(HttpExecutorContext executorContext, String uri, byte[] bytes, boolean asPutMethod) throws IOException {
        HttpPost httpPost = new HttpPost(asPutMethod ? HttpExecutor.urlAddMethodParameter(uri, "PUT") : uri);
        httpPost.setHeader("Content-Type", applicationFormHead);
        if (bytes != null) {
            ByteArrayEntity entity = new ByteArrayEntity(bytes);
            httpPost.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpPost);
    }

    public static String rawPost(HttpExecutorContext executorContext, String uri, byte[] bytes) throws IOException {
        return HttpExecutor.rawPost(executorContext, uri, bytes, false);
    }

    public static String jsonPost(HttpExecutorContext executorContext, String uri, String jsonString, boolean asPutMethod) throws IOException {
        HttpPost httpPost = new HttpPost(asPutMethod ? HttpExecutor.urlAddMethodParameter(uri, "PUT") : uri);
        httpPost.setHeader("Content-Type", applicationJSONHead);
        if (jsonString != null && !"".equals(jsonString)) {
            StringEntity entity = new StringEntity(jsonString, Consts.UTF_8);
            httpPost.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpPost);
    }

    public static String jsonPost(HttpExecutorContext executorContext, String uri, JSON jsonEntity, boolean asPutMethod) throws IOException {
        return HttpExecutor.jsonPost(executorContext, uri, jsonEntity == null ? null : jsonEntity.toJSONString(), asPutMethod);
    }

    public static String jsonPost(HttpExecutorContext executorContext, String uri, Object obj, boolean asPutMethod) throws IOException {
        return HttpExecutor.jsonPost(executorContext, uri, obj == null ? null : JSON.toJSONString((Object)obj), asPutMethod);
    }

    public static String jsonPost(HttpExecutorContext executorContext, String uri, String jsonString) throws IOException {
        return HttpExecutor.jsonPost(executorContext, uri, jsonString, false);
    }

    public static String jsonPost(HttpExecutorContext executorContext, String uri, Object obj) throws IOException {
        return HttpExecutor.jsonPost(executorContext, uri, obj, false);
    }

    public static String jsonPost(HttpExecutorContext executorContext, String uri, JSON jsonEntity) throws IOException {
        return HttpExecutor.jsonPost(executorContext, uri, jsonEntity, false);
    }

    public static String jsonPut(HttpExecutorContext executorContext, String uri, String jsonString) throws IOException {
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setHeader("Content-Type", applicationJSONHead);
        if (jsonString != null && !"".equals(jsonString)) {
            StringEntity entity = new StringEntity(jsonString, Consts.UTF_8);
            httpPut.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpPut);
    }

    public static String xmlPost(HttpExecutorContext executorContext, String uri, String xmlEntity, boolean asPutMethod) throws IOException {
        HttpPost httpPost = new HttpPost(asPutMethod ? HttpExecutor.urlAddMethodParameter(uri, "PUT") : uri);
        httpPost.setHeader("Content-Type", xmlTextHead);
        if (xmlEntity != null) {
            StringEntity entity = new StringEntity(xmlEntity, Consts.UTF_8);
            httpPost.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpPost);
    }

    public static String xmlPost(HttpExecutorContext executorContext, String uri, String xmlEntity) throws IOException {
        return HttpExecutor.xmlPost(executorContext, uri, xmlEntity, false);
    }

    public static String xmlPut(HttpExecutorContext executorContext, String uri, String xmlEntity) throws IOException {
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setHeader("Content-Type", xmlTextHead);
        if (xmlEntity != null && !"".equals(xmlEntity)) {
            StringEntity entity = new StringEntity(xmlEntity, Consts.UTF_8);
            httpPut.setEntity((HttpEntity)entity);
        }
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpPut);
    }

    public static String urlAddMethodParameter(String url, String method) {
        String sUrl = url.indexOf(63) == -1 ? url + "?_method=" + method : (url.endsWith("?") ? url + "_method=" + method : url + "&_method=" + method);
        return sUrl;
    }

    public static String formPost(HttpExecutorContext executorContext, String uri, Object formData, boolean asPutMethod) throws IOException {
        HttpPost httpPost = new HttpPost(asPutMethod ? HttpExecutor.urlAddMethodParameter(uri, "PUT") : uri);
        httpPost.setHeader("Content-Type", applicationFormHead);
        if (formData != null) {
            EntityBuilder eb = EntityBuilder.create();
            eb.setContentType(APPLICATION_FORM_URLENCODED);
            eb.setContentEncoding("utf-8");
            List<NameValuePair> params = HttpExecutor.makeRequectParams(formData, "");
            eb.setParameters(params);
            httpPost.setEntity(eb.build());
        }
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpPost);
    }

    public static String formPost(HttpExecutorContext executorContext, String uri, Object formData) throws IOException {
        return HttpExecutor.formPost(executorContext, uri, formData, false);
    }

    public static String multiFormPost(HttpExecutorContext executorContext, String uri, Object[] formObjects, Map<String, Object> extFormObjects, boolean asPutMethod) throws IOException {
        HttpPost httpPost = new HttpPost(asPutMethod ? HttpExecutor.urlAddMethodParameter(uri, "PUT") : uri);
        httpPost.setHeader("Content-Type", applicationFormHead);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (formObjects != null) {
            for (int i = 0; i < formObjects.length; ++i) {
                if (formObjects[i] == null) continue;
                List<NameValuePair> subNP = HttpExecutor.makeRequectParams(formObjects[i], "");
                params.addAll(subNP);
            }
        }
        if (extFormObjects != null) {
            List<NameValuePair> subNP = HttpExecutor.makeRequectParams(extFormObjects, "");
            params.addAll(subNP);
        }
        EntityBuilder eb = EntityBuilder.create();
        eb.setContentType(APPLICATION_FORM_URLENCODED);
        eb.setContentEncoding("utf-8");
        eb.setParameters(params);
        httpPost.setEntity(eb.build());
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpPost);
    }

    public static String multiFormPost(HttpExecutorContext executorContext, String uri, Object formObject, Map<String, Object> extFormObjects, boolean asPutMethod) throws IOException {
        return HttpExecutor.multiFormPost(executorContext, uri, new Object[]{formObject}, extFormObjects, asPutMethod);
    }

    public static String multiFormPost(HttpExecutorContext executorContext, String uri, Object[] formObjects, Map<String, Object> extFormObjects) throws IOException {
        return HttpExecutor.multiFormPost(executorContext, uri, formObjects, extFormObjects, false);
    }

    public static String multiFormPost(HttpExecutorContext executorContext, String uri, Object formObject, Map<String, Object> extFormObjects) throws IOException {
        return HttpExecutor.multiFormPost(executorContext, uri, new Object[]{formObject}, extFormObjects, false);
    }

    public static String inputStreamUpload(HttpExecutorContext executorContext, String uri, InputStream inputStream) throws IOException {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader("Content-Type", applicationOctetStream);
        InputStreamEntity entity = new InputStreamEntity(inputStream);
        httpPost.setEntity((HttpEntity)entity);
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpPost);
    }

    public static String inputStreamUpload(HttpExecutorContext executorContext, String uri, Map<String, Object> formObjects, InputStream inputStream) throws IOException {
        String paramsUrl = null;
        if (formObjects != null) {
            List<NameValuePair> params = HttpExecutor.makeRequectParams(formObjects, "");
            paramsUrl = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(params, Consts.UTF_8));
        }
        return HttpExecutor.inputStreamUpload(executorContext, UrlOptUtils.appendParamToUrl(uri, paramsUrl), inputStream);
    }

    public static String formPostWithFileUpload(HttpExecutorContext executorContext, String uri, Map<String, Object> formObjects, Map<String, File> files) throws IOException {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader("Content-Type", multiPartTypeHead);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setBoundary(BOUNDARY);
        if (formObjects != null) {
            for (Map.Entry<String, Object> entry : formObjects.entrySet()) {
                builder.addTextBody(entry.getKey(), JSONOpt.objectToJSONString(entry.getValue()));
            }
        }
        if (files != null) {
            for (Map.Entry<String, Object> entry : files.entrySet()) {
                builder.addBinaryBody(entry.getKey(), (File)entry.getValue());
            }
        }
        httpPost.setEntity(builder.build());
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpPost);
    }

    public static String fileUpload(HttpExecutorContext executorContext, String uri, File file) throws IOException {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader("Content-Type", applicationOctetStream);
        InputStreamEntity entity = new InputStreamEntity((InputStream)new FileInputStream(file));
        httpPost.setEntity((HttpEntity)entity);
        return HttpExecutor.httpExecute(executorContext, (HttpRequestBase)httpPost);
    }

    public static String fileUpload(HttpExecutorContext executorContext, String uri, Map<String, Object> formObjects, File file) throws IOException {
        String paramsUrl = null;
        if (formObjects != null) {
            List<NameValuePair> params = HttpExecutor.makeRequectParams(formObjects, "");
            paramsUrl = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(params, Consts.UTF_8));
        }
        return HttpExecutor.fileUpload(executorContext, UrlOptUtils.appendParamToUrl(uri, paramsUrl), file);
    }

    protected static String extraFileName(CloseableHttpResponse response) {
        Header[] contentDispositionHeader = response.getHeaders("Content-disposition");
        Matcher m = Pattern.compile(".*filename=\"(.*)\"").matcher(contentDispositionHeader[0].getValue());
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static <T> T fetchInputStreamByUrl(HttpExecutorContext executorContext, String uri, String queryParam, DoOperateInputStream<T> operate) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> T fetchInputStreamByUrl(HttpExecutorContext executorContext, String uri, DoOperateInputStream<T> operate) throws IOException {
        return HttpExecutor.fetchInputStreamByUrl(executorContext, uri, null, operate);
    }

    public static <T> T fetchInputStreamByUrl(String uri, DoOperateInputStream<T> operate) throws IOException {
        try (CloseableHttpClient httpClient = HttpExecutor.createHttpClient();){
            T t = HttpExecutor.fetchInputStreamByUrl(HttpExecutorContext.create(httpClient), uri, null, operate);
            return t;
        }
    }

    public static boolean fileDownload(HttpExecutorContext executorContext, String uri, String queryParam, String filePath) throws IOException {
        return HttpExecutor.fetchInputStreamByUrl(executorContext, uri, queryParam, inputStream -> FileSystemOpt.createFile(inputStream, filePath));
    }

    public static boolean fileDownload(HttpExecutorContext executorContext, String uri, String filePath) throws IOException {
        return HttpExecutor.fileDownload(executorContext, uri, null, filePath);
    }

    public static boolean fileDownload(String uri, String queryParam, String filePath) throws IOException {
        return HttpExecutor.fileDownload(HttpExecutorContext.create(), uri, queryParam, filePath);
    }

    public static boolean fileDownload(String uri, String filePath) throws IOException {
        return HttpExecutor.fileDownload(HttpExecutorContext.create(), uri, null, filePath);
    }

    public static interface DoOperateInputStream<T> {
        public T doOperate(InputStream var1) throws IOException;
    }
}

