/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.security;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AESSecurityUtils {
    protected static final Logger logger = LoggerFactory.getLogger(AESSecurityUtils.class);

    private AESSecurityUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static Cipher createEncryptCipher(String keyValue) throws GeneralSecurityException {
        SecretKey key = AESSecurityUtils.getKey(keyValue);
        Cipher encryptCipher = Cipher.getInstance("AES");
        encryptCipher.init(1, key);
        return encryptCipher;
    }

    public static Cipher createDencryptCipher(String keyValue) throws GeneralSecurityException {
        SecretKey key = AESSecurityUtils.getKey(keyValue);
        Cipher decryptCipher = Cipher.getInstance("AES");
        decryptCipher.init(2, key);
        return decryptCipher;
    }

    private static SecretKey getKey(String secret) throws GeneralSecurityException {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(secret.getBytes());
        kgen.init(128, secureRandom);
        return kgen.generateKey();
    }

    public static byte[] encrypt(byte[] arrB, String keyValue) throws GeneralSecurityException {
        return AESSecurityUtils.createEncryptCipher(keyValue).doFinal(arrB);
    }

    public static byte[] decrypt(byte[] arrB, String keyValue) throws GeneralSecurityException {
        return AESSecurityUtils.createDencryptCipher(keyValue).doFinal(arrB);
    }

    public static String encryptAndBase64(String str, String keyValue) {
        try {
            return new String(Base64.encodeBase64((byte[])AESSecurityUtils.encrypt(str.getBytes(), keyValue)));
        }
        catch (GeneralSecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String decryptBase64String(String str, String keyValue) {
        try {
            return new String(AESSecurityUtils.decrypt(Base64.decodeBase64((byte[])str.getBytes()), keyValue));
        }
        catch (GeneralSecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

