/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.file;

import com.alibaba.fastjson.JSON;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;

public abstract class FileIOOpt {
    public static int writeInputStreamToOutputStream(InputStream in, OutputStream out) throws IOException {
        int read = 0;
        int length = 0;
        byte[] bytes = new byte[10240];
        while ((read = in.read(bytes)) != -1) {
            out.write(bytes, 0, read);
            length += read;
        }
        return length;
    }

    public static int writeInputStreamToFile(InputStream in, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file, true);){
            int n = FileIOOpt.writeInputStreamToOutputStream(in, out);
            return n;
        }
    }

    public static int writeInputStreamToFile(InputStream in, String filePath) throws IOException {
        return FileIOOpt.writeInputStreamToFile(in, new File(filePath));
    }

    public static void writeStringToOutputStream(String strData, OutputStream io) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(io);){
            writer.write(strData);
        }
    }

    public static void writeStringToFile(String strData, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            writer.write(strData);
        }
    }

    public static void writeStringToFile(String strData, String fileName) throws IOException {
        FileIOOpt.writeStringToFile(strData, new File(fileName));
    }

    public static String readStringFromRead(Reader reader) throws IOException {
        try (StringWriter writer = new StringWriter();){
            int len;
            char[] buf = new char[1024];
            while ((len = reader.read(buf)) != -1) {
                writer.write(buf, 0, len);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String readStringFromInputStream(InputStream is, String charsetName) throws IOException {
        return FileIOOpt.readStringFromRead(new InputStreamReader(is, charsetName));
    }

    public static String readStringFromInputStream(InputStream is) throws IOException {
        return FileIOOpt.readStringFromRead(new InputStreamReader(is));
    }

    public static String readStringFromFile(File file, String charsetName) throws IOException {
        return FileIOOpt.readStringFromRead(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
    }

    public static String readStringFromFile(File file) throws IOException {
        return FileIOOpt.readStringFromRead(new InputStreamReader(new FileInputStream(file)));
    }

    public static String readStringFromFile(String fileName, String charsetName) throws IOException {
        return FileIOOpt.readStringFromFile(new File(fileName), charsetName);
    }

    public static String readStringFromFile(String fileName) throws IOException {
        return FileIOOpt.readStringFromFile(new File(fileName));
    }

    public static void writeObjectToFile(Object obj, String fileName) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(fileName));){
            oos.writeObject(obj);
        }
    }

    public static Object readObjectFromFile(String fileName) throws IOException, ClassNotFoundException {
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(fileName));){
            Object object = ois.readObject();
            return object;
        }
    }

    public static void writeObjectAsJsonToFile(Object obj, String fileName) throws IOException {
        String sjson = JSON.toJSONString((Object)obj);
        FileIOOpt.writeStringToFile(sjson, fileName);
    }

    public static <T> T readObjectAsJsonFromFile(String fileName, Class<T> clazz) throws IOException, ClassNotFoundException {
        String sjson = FileIOOpt.readStringFromFile(fileName);
        return (T)JSON.parseObject((String)sjson, clazz);
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

