/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileMD5Maker {
    protected static final Logger logger = LoggerFactory.getLogger(FileMD5Maker.class);

    public static String makeFileMD5(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            String string = FileMD5Maker.makeFileMD5(fis);
            return string;
        }
    }

    public static String makeFileMD5(InputStream is) throws IOException {
        try {
            int length;
            MessageDigest MD5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            while ((length = is.read(buffer)) != -1) {
                MD5.update(buffer, 0, length);
            }
            return new String(Hex.encodeHex((byte[])MD5.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

