/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class FileSystemOpt {
    public static List<File> findFilesByExt(String dir, String extName) {
        File dirFile = new File(dir);
        File[] fileArray = dirFile.listFiles();
        ArrayList<File> resFiles = new ArrayList<File>();
        if (null == fileArray) {
            return resFiles;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isFile() || !fileArray[i].getName().endsWith(extName)) continue;
            resFiles.add(fileArray[i]);
        }
        return resFiles;
    }

    public static List<File> findFiles(String s) {
        return FileSystemOpt.findFiles("./", s);
    }

    public static List<File> findFiles(String dir, String s) {
        File file = new File(dir);
        s = s.replace('.', '#');
        s = s.replaceAll("#", "\\\\.");
        s = s.replace('*', '#');
        s = s.replaceAll("#", ".*");
        s = s.replace('?', '#');
        s = s.replaceAll("#", ".?");
        s = "^" + s + "$";
        Pattern p = Pattern.compile(s);
        return FileSystemOpt.filePattern(file, p);
    }

    private static List<File> filePattern(File file, Pattern p) {
        File[] files;
        if (file == null) {
            return null;
        }
        if (file.isFile()) {
            Matcher fMatcher = p.matcher(file.getName());
            if (fMatcher.matches()) {
                ArrayList<File> list = new ArrayList<File>();
                list.add(file);
                return list;
            }
        } else if (file.isDirectory() && (files = file.listFiles()) != null && files.length > 0) {
            ArrayList<File> list = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                List<File> rlist = FileSystemOpt.filePattern(files[i], p);
                if (rlist == null) continue;
                list.addAll(rlist);
            }
            return list;
        }
        return null;
    }

    public static boolean existFile(String sFilePath) {
        File f = new File(sFilePath);
        return f.exists();
    }

    public static boolean createDirect(File f) {
        if (f.exists()) {
            return true;
        }
        return f.mkdirs();
    }

    public static boolean createDirect(String sDirPath) {
        return FileSystemOpt.createDirect(new File(sDirPath));
    }

    public static String extractFullFileName(String filePath) {
        int nl;
        int nPos;
        if (filePath == null) {
            return "";
        }
        for (nPos = nl = filePath.length(); nPos > 0 && filePath.charAt(nPos - 1) != '\\' && filePath.charAt(nPos - 1) != '/'; --nPos) {
        }
        return filePath.substring(nPos);
    }

    public static String extractFileName(String filePath) {
        int nl;
        int nPos;
        if (filePath == null) {
            return "";
        }
        String fullFileName = FileSystemOpt.extractFullFileName(filePath);
        for (nPos = nl = fullFileName.length(); nPos > 0 && fullFileName.charAt(nPos - 1) != '.'; --nPos) {
        }
        if (nPos > 1) {
            return fullFileName.substring(0, nPos - 1);
        }
        return fullFileName;
    }

    public static void fileCopy(File in, File out) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(in);
             FileChannel inChannel = fileInputStream.getChannel();
             FileOutputStream fileOutputStream = new FileOutputStream(out);
             FileChannel outChannel = fileOutputStream.getChannel();){
            int maxCount = 67076096;
            long size = inChannel.size();
            for (long position = 0L; position < size; position += inChannel.transferTo(position, maxCount, outChannel)) {
            }
        }
    }

    public static void fileCopy(String souFile, String destFile) throws IOException {
        if (StringUtils.equalsIgnoreCase((CharSequence)souFile, (CharSequence)destFile)) {
            return;
        }
        FileSystemOpt.fileCopy(new File(souFile), new File(destFile));
    }

    public static boolean deleteDirect(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileSystemOpt.deleteDirect(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean deleteDirect(String dirPath) {
        return FileSystemOpt.deleteDirect(new File(dirPath));
    }

    public static boolean deleteFile(File file) {
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    public static boolean deleteFile(String filePath) {
        return FileSystemOpt.deleteFile(new File(filePath));
    }

    public static File createTmpFile(InputStream inputStream, String name, String ext, File tmpDirFile) throws IOException {
        File tmpFile = tmpDirFile == null ? File.createTempFile(name, '.' + ext) : File.createTempFile(name, '.' + ext, tmpDirFile);
        tmpFile.deleteOnExit();
        try (FileOutputStream fos = new FileOutputStream(tmpFile);){
            int read = 0;
            byte[] bytes = new byte[102400];
            while ((read = inputStream.read(bytes)) != -1) {
                fos.write(bytes, 0, read);
            }
            fos.flush();
            File file = tmpFile;
            return file;
        }
    }

    public static File createTmpFile(InputStream inputStream, String name, String ext) throws IOException {
        return FileSystemOpt.createTmpFile(inputStream, name, ext, null);
    }

    public static boolean createFile(InputStream inputStream, String filePath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(filePath);){
            int read = 0;
            byte[] bytes = new byte[102400];
            while ((read = inputStream.read(bytes)) != -1) {
                fos.write(bytes, 0, read);
            }
            fos.flush();
            boolean bl = true;
            return bl;
        }
    }
}

