/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.file;

import com.centit.support.algorithm.DatetimeOpt;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxtLogFile {
    protected static final Logger logger = LoggerFactory.getLogger(TxtLogFile.class);
    private BufferedWriter logWriter;

    public static void writeLog(String sLogFileName, String slog, boolean bNewLine, boolean bShowTime) {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(sLogFileName));){
            if (bShowTime) {
                bw.write(DatetimeOpt.convertDateToString(DatetimeOpt.currentUtilDate(), DatetimeOpt.getDateTimePattern()));
            }
            if (bNewLine) {
                bw.write(slog + "\r\n");
            } else {
                bw.write(slog);
            }
            bw.flush();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void writeLogEx(String sLogFileName, String slog, boolean bNewLine, boolean bShowTime) {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(sLogFileName));){
            if (bShowTime) {
                bw.write(DatetimeOpt.convertDateToString(DatetimeOpt.currentUtilDate(), DatetimeOpt.getDateTimePattern()));
                System.out.print(DatetimeOpt.convertDateToString(DatetimeOpt.currentUtilDate(), DatetimeOpt.getDateTimePattern()));
            }
            if (bNewLine) {
                bw.write(slog + "\r\n");
                System.out.println(slog);
            } else {
                bw.write(slog);
                System.out.print(slog);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void writeLog(String sLogFileName, String slog) {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(sLogFileName));){
            bw.write(slog);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean openLogFile(String sLogFileName) {
        this.closeLogFile();
        boolean bOpened = false;
        try {
            this.logWriter = new BufferedWriter(new FileWriter(sLogFileName));
            bOpened = true;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return bOpened;
    }

    public boolean closeLogFile() {
        boolean bClosed = false;
        try {
            if (this.logWriter != null) {
                this.logWriter.close();
            }
            this.logWriter = null;
            bClosed = true;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return bClosed;
    }

    public void writeLog(String slog, boolean bNewLine, boolean bShowTime) {
        try {
            if (bShowTime) {
                this.logWriter.write(DatetimeOpt.convertDateToString(DatetimeOpt.currentUtilDate(), DatetimeOpt.getDateTimePattern()));
            }
            if (bNewLine) {
                this.logWriter.write(slog + "\r\n");
            } else {
                this.logWriter.write(slog);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void writeLogEx(String slog, boolean bNewLine, boolean bShowTime) {
        try {
            if (bShowTime) {
                this.logWriter.write(DatetimeOpt.convertDateToString(DatetimeOpt.currentUtilDate(), DatetimeOpt.getDateTimePattern()));
                System.out.print(DatetimeOpt.convertDateToString(DatetimeOpt.currentUtilDate(), DatetimeOpt.getDateTimePattern()));
            }
            if (bNewLine) {
                this.logWriter.write(slog + "\r\n");
                System.out.println(slog);
            } else {
                this.logWriter.write(slog);
                System.out.print(slog);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

