/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.security;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.util.HashMap;
import javax.crypto.Cipher;
import org.apache.commons.net.util.Base64;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.rsa.RSAPublicKeyImpl;

public abstract class RSASecurityUtils {
    private static final String ALGORITHM = "RSA";
    private static final int KEYSIZE = 1024;

    public static KeyPair generateKeyPair() throws Exception {
        return RSASecurityUtils.generateKeyPair(1024);
    }

    public static KeyPair generateKeyPair(int keysize) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM);
        keyPairGenerator.initialize(keysize);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    public static String encrypt(String source, Key key) throws Exception {
        RSASecurityUtils.generateKeyPair();
        Key publicKey = key;
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, publicKey);
        byte[] b = source.getBytes();
        byte[] b1 = cipher.doFinal(b);
        return Base64.encodeBase64String((byte[])b1);
    }

    public static String decrypt(String cryptograph, Key key) throws Exception {
        Key privateKey = key;
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, privateKey);
        byte[] b1 = Base64.decodeBase64((String)cryptograph);
        byte[] b = cipher.doFinal(b1);
        return new String(b);
    }

    public static String keyPairToJson(KeyPair keyPair) {
        HashMap<String, String> keyJson = new HashMap<String, String>();
        keyJson.put("private", Base64.encodeBase64String((byte[])keyPair.getPrivate().getEncoded()));
        keyJson.put("public", Base64.encodeBase64String((byte[])keyPair.getPublic().getEncoded()));
        return JSON.toJSONString(keyJson);
    }

    public static KeyPair keyPairFromJson(String keyJsonString) throws InvalidKeyException {
        JSONObject keyJson = JSON.parseObject((String)keyJsonString);
        return new KeyPair(new RSAPublicKeyImpl(Base64.decodeBase64((String)keyJson.getString("public"))), RSAPrivateCrtKeyImpl.newKey((byte[])Base64.decodeBase64((String)keyJson.getString("private"))));
    }
}

