/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.TreeNode;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public abstract class ListOpt {
    private ListOpt() {
        throw new IllegalAccessError("Utility class");
    }

    public static <T> void changeListItem(List<T> list, int p1, int p2) {
        if (p1 == p2) {
            return;
        }
        Collections.swap(list, p1, p2);
    }

    public static <T> void moveListItem(List<T> list, int item, int pos) {
        if (item == pos || item < 0 || pos < 0 || item >= list.size() || pos >= list.size()) {
            return;
        }
        if (item > pos) {
            T tmp = list.get(item);
            for (int i = item; i > pos; --i) {
                list.set(i, list.get(i - 1));
            }
            list.set(pos, tmp);
        } else {
            T tmp = list.get(item);
            for (int i = item; i < pos; ++i) {
                list.set(i, list.get(i + 1));
            }
            list.set(pos, tmp);
        }
    }

    public static <T> void sortAsTree(List<T> list, ParentChild<? super T> c) {
        int n = list.size();
        if (n < 2) {
            return;
        }
        int sortedInd = 0;
        int[] parentInds = new int[n];
        while (sortedInd < n - 1) {
            int parentInd = -1;
            for (int i = sortedInd; i < n; ++i) {
                boolean isParent = true;
                for (int j = sortedInd; j < n; ++j) {
                    if (i == j || !c.parentAndChild(list.get(j), list.get(i))) continue;
                    isParent = false;
                    break;
                }
                if (!isParent) continue;
                parentInd = i;
                break;
            }
            if (parentInd == -1) break;
            ListOpt.moveListItem(list, parentInd, sortedInd);
            parentInds[0] = sortedInd++;
            int pathDeep = 1;
            while (pathDeep > 0) {
                int newInsert = 0;
                for (int i = sortedInd; i < n; ++i) {
                    if (!c.parentAndChild(list.get(parentInds[pathDeep - 1]), list.get(i))) continue;
                    ListOpt.moveListItem(list, i, sortedInd);
                    parentInds[pathDeep] = sortedInd++;
                    ++pathDeep;
                    ++newInsert;
                }
                if (newInsert != 0) continue;
                --pathDeep;
            }
        }
    }

    public static <T> List<Integer> makeJqueryTreeIndex(List<T> list, ParentChild<? super T> c) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int ind = 0;
            for (int j = 0; j < i; ++j) {
                if (!c.parentAndChild(list.get(j), list.get(i))) continue;
                ind = j + 1;
                break;
            }
            indexes.add(ind);
        }
        return indexes;
    }

    public static <T> List<T> removeNullItem(List<T> list) {
        if (list == null || list.size() < 1) {
            return null;
        }
        ArrayList<T> retList = new ArrayList<T>();
        for (T t : list) {
            if (t == null) continue;
            retList.add(t);
        }
        return retList;
    }

    public static <T> T[] removeNullItem(T[] list) {
        if (list == null || list.length < 1) {
            return null;
        }
        int notNullItemPos = -1;
        int size = 0;
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            ++size;
            notNullItemPos = i;
        }
        if (notNullItemPos < 0) {
            return null;
        }
        Object[] ta = (Object[])Array.newInstance(list[notNullItemPos].getClass(), size);
        size = 0;
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            ta[size] = list[i];
            ++size;
        }
        return ta;
    }

    public static List<String> removeBlankString(List<String> list) {
        if (list == null || list.size() < 1) {
            return null;
        }
        ArrayList<String> retList = new ArrayList<String>();
        for (String t : list) {
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{t})) continue;
            retList.add(t);
        }
        return retList;
    }

    public static String[] removeBlankString(String[] list) {
        if (list == null || list.length < 1) {
            return null;
        }
        int notNullItemPos = -1;
        int size = 0;
        for (int i = 0; i < list.length; ++i) {
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{list[i]})) continue;
            ++size;
            notNullItemPos = i;
        }
        if (notNullItemPos < 0) {
            return null;
        }
        String[] ta = new String[size];
        size = 0;
        for (int i = 0; i < list.length; ++i) {
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{list[i]})) continue;
            ta[size] = list[i];
            ++size;
        }
        return ta;
    }

    public static <T> JSONArray treeToJSONArray(List<T> treeList, ParentChild<? super T> c, String childrenPropertyName) {
        JSONArray jsonTree = new JSONArray();
        Stack<T> treePath = new Stack<T>();
        Stack<JSONObject> jsonPath = new Stack<JSONObject>();
        int pathSum = 0;
        block0: for (T treeNode : treeList) {
            JSONObject jsonNode;
            if (ReflectionOpt.isScalarType(treeNode.getClass())) {
                jsonNode = new JSONObject();
                jsonNode.put("value", (Object)StringBaseOpt.objectToString(treeNode));
            } else {
                jsonNode = (JSONObject)JSON.toJSON(treeNode);
            }
            while (true) {
                if (pathSum == 0 || pathSum > 0 && c.parentAndChild(treePath.peek(), treeNode)) {
                    if (pathSum == 0) {
                        jsonTree.add((Object)jsonNode);
                    } else {
                        JSONObject parentJson = (JSONObject)jsonPath.peek();
                        JSONArray children = (JSONArray)parentJson.get((Object)childrenPropertyName);
                        if (children == null) {
                            children = new JSONArray();
                        }
                        children.add((Object)jsonNode);
                        parentJson.put(childrenPropertyName, (Object)children);
                    }
                    treePath.push(treeNode);
                    jsonPath.push(jsonNode);
                    ++pathSum;
                    continue block0;
                }
                treePath.pop();
                jsonPath.pop();
                --pathSum;
            }
        }
        return jsonTree;
    }

    public static <T> JSONArray srotAsTreeAndToJSON(List<T> treeList, ParentChild<? super T> c, String childrenPropertyName) {
        ListOpt.sortAsTree(treeList, c);
        return ListOpt.treeToJSONArray(treeList, c, childrenPropertyName);
    }

    public static <T> List<TreeNode<T>> storedAsTree(List<T> list, ParentChild<? super T> c) {
        ArrayList<TreeNode<T>> treeList = new ArrayList<TreeNode<T>>();
        for (T t : list) {
            treeList.add(new TreeNode<T>(t));
        }
        block1: for (TreeNode treeNode : treeList) {
            for (TreeNode treeNode2 : treeList) {
                if (treeNode2 == treeNode || !c.parentAndChild(treeNode2.getValue(), treeNode.getValue())) continue;
                treeNode2.addChild(treeNode);
                continue block1;
            }
        }
        ArrayList<TreeNode<T>> resList = new ArrayList<TreeNode<T>>();
        for (TreeNode treeNode : treeList) {
            if (!treeNode.isRoot()) continue;
            resList.add(treeNode);
        }
        return resList;
    }

    public static <T> JSONArray treeToJSONArray(List<TreeNode<T>> treeList, String childrenPropertyName) {
        if (treeList == null || treeList.size() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (TreeNode<T> c : treeList) {
            ja.add((Object)c.toJSONObject(childrenPropertyName));
        }
        return ja;
    }

    public static <T> JSONArray srotAsTreeAndToJSON2(List<T> treeList, ParentChild<? super T> c, String childrenPropertyName) {
        List<TreeNode<T>> sortTree = ListOpt.storedAsTree(treeList, c);
        return ListOpt.treeToJSONArray(sortTree, childrenPropertyName);
    }

    public static <T> List<T> cloneList(List<T> souList) {
        if (souList == null) {
            return null;
        }
        ArrayList<T> deslist = new ArrayList<T>(souList.size() + 1);
        deslist.addAll(souList);
        return deslist;
    }

    public static <T> T[] cloneArray(T[] souList) {
        if (souList == null) {
            return null;
        }
        return (Object[])souList.clone();
    }

    public static <T> Triple<List<T>, List<Pair<T, T>>, List<T>> compareTwoList(List<T> oldList, List<T> newList, Comparator<T> compare) {
        if (oldList == null || oldList.size() == 0) {
            return new ImmutableTriple(newList, null, null);
        }
        if (newList == null || newList.size() == 0) {
            return new ImmutableTriple(null, null, oldList);
        }
        List<T> souList = ListOpt.cloneList(oldList);
        List<T> desList = ListOpt.cloneList(newList);
        Collections.sort(souList, compare);
        Collections.sort(desList, compare);
        int i = 0;
        int sl = souList.size();
        int j = 0;
        int dl = desList.size();
        ArrayList<T> insertList = new ArrayList<T>();
        ArrayList<T> delList = new ArrayList<T>();
        ArrayList<ImmutablePair> updateList = new ArrayList<ImmutablePair>();
        while (i < sl && j < dl) {
            int n = compare.compare(souList.get(i), desList.get(j));
            if (n < 0) {
                delList.add(souList.get(i));
                ++i;
                continue;
            }
            if (n == 0) {
                updateList.add(new ImmutablePair(souList.get(i), desList.get(j)));
                ++i;
                ++j;
                continue;
            }
            insertList.add(desList.get(j));
            ++j;
        }
        while (i < sl) {
            delList.add(souList.get(i));
            ++i;
        }
        while (j < dl) {
            insertList.add(desList.get(j));
            ++j;
        }
        return new ImmutableTriple(insertList, updateList, delList);
    }

    public static <T> T[] listToArray(Collection<T> listObj) {
        if (listObj == null || listObj.size() == 0) {
            return null;
        }
        Object[] ta = (Object[])Array.newInstance(listObj.iterator().next().getClass(), listObj.size());
        return listObj.toArray(ta);
    }

    public static <T> List<T> arrayToList(T[] arrayObj) {
        if (arrayObj == null || arrayObj.length == 0) {
            return null;
        }
        ArrayList<T> listObj = new ArrayList<T>(arrayObj.length);
        for (T obj : arrayObj) {
            listObj.add(obj);
        }
        return listObj;
    }

    public static interface ParentChild<T> {
        public boolean parentAndChild(T var1, T var2);
    }
}

