/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.file.FileType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReflectionOpt {
    protected static final Logger logger = LoggerFactory.getLogger(ReflectionOpt.class);

    private ReflectionOpt() {
        throw new IllegalAccessError("Utility class");
    }

    public static Field getDeclaredField(Object object, String propertyName) throws NoSuchFieldException {
        assert (object != null);
        assert (propertyName != null && !propertyName.isEmpty());
        return ReflectionOpt.getDeclaredField(object.getClass(), propertyName);
    }

    public static Field getDeclaredField(Class<?> clazz, String propertyName) throws NoSuchFieldException {
        assert (clazz != null);
        assert (propertyName != null && !propertyName.isEmpty());
        for (Class<?> superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field f = superClass.getDeclaredField(propertyName);
                if (f == null) continue;
                return f;
            }
            catch (NoSuchFieldException e) {
                logger.debug(e.getMessage());
            }
        }
        throw new NoSuchFieldException("No such field: " + clazz.getName() + '.' + propertyName);
    }

    public static Object forceGetFieldValue(Object object, Field field) {
        assert (object != null);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            logger.info("error wont' happen." + e.getMessage());
        }
        field.setAccessible(accessible);
        return result;
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        Method md = null;
        try {
            md = obj.getClass().getMethod("get" + StringUtils.capitalize((String)fieldName), new Class[0]);
        }
        catch (NoSuchMethodException noGet) {
            try {
                md = obj.getClass().getMethod("is" + StringUtils.capitalize((String)fieldName), new Class[0]);
            }
            catch (Exception e) {
                logger.error(noGet.getMessage() + e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (md == null) {
            try {
                return ReflectionOpt.forceGetProperty(obj, fieldName);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                return md.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static boolean setFieldValue(Object object, String fieldName, Object newValue, Class<?> paramType) {
        Class<?> relParamType = paramType != null ? paramType : (newValue != null ? newValue.getClass() : null);
        boolean hasSetValue = false;
        if (relParamType != null) {
            try {
                Method md = object.getClass().getMethod("set" + StringUtils.capitalize((String)fieldName), relParamType);
                md.invoke(object, newValue);
                hasSetValue = true;
            }
            catch (NoSuchMethodException noSet) {
                logger.error(noSet.getMessage(), (Throwable)noSet);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (!hasSetValue) {
            try {
                ReflectionOpt.forceSetProperty(object, fieldName, newValue);
                hasSetValue = true;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return hasSetValue;
    }

    public static boolean setFieldValue(Object object, String fieldName, Object newValue) {
        return ReflectionOpt.setFieldValue(object, fieldName, newValue, null);
    }

    public static Object getFieldValue(Object obj, Field field) {
        try {
            return field.get(obj);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object forceGetProperty(Object object, String propertyName) throws NoSuchFieldException {
        assert (object != null);
        assert (propertyName != null && !propertyName.isEmpty());
        Field field = ReflectionOpt.getDeclaredField(object, propertyName);
        return ReflectionOpt.forceGetFieldValue(object, field);
    }

    public static void forceSetProperty(Object object, String propertyName, Object newValue) throws NoSuchFieldException {
        assert (object != null);
        assert (propertyName != null && !propertyName.isEmpty());
        Field field = ReflectionOpt.getDeclaredField(object, propertyName);
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
        }
        try {
            field.set(object, newValue);
        }
        catch (IllegalAccessException e) {
            logger.error("Error won't happen." + e.getMessage(), (Throwable)e);
        }
        if (!accessible) {
            field.setAccessible(accessible);
        }
    }

    public static Object invokePrivateMethod(Object object, String methodName, Object ... params) throws NoSuchMethodException {
        assert (object != null);
        assert (methodName != null && !methodName.isEmpty());
        Class[] types = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            types[i] = params[i].getClass();
        }
        Class<?> clazz = object.getClass();
        AccessibleObject method = null;
        for (Class<?> superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                method = superClass.getDeclaredMethod(methodName, types);
                break;
            }
            catch (NoSuchMethodException e) {
                logger.debug("\u65b9\u6cd5\u4e0d\u5728\u5f53\u524d\u7c7b\u5b9a\u4e49,\u7ee7\u7eed\u5411\u4e0a\u8f6c\u578b");
                continue;
            }
        }
        if (method == null) {
            throw new NoSuchMethodException("No Such Method:" + clazz.getSimpleName() + methodName);
        }
        boolean accessible = method.isAccessible();
        ((Method)method).setAccessible(true);
        Object result = null;
        try {
            result = ((Method)method).invoke(object, params);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
        }
        ((Method)method).setAccessible(accessible);
        return result;
    }

    public static Field[] getFields(Object object) {
        return object.getClass().getDeclaredFields();
    }

    public static List<Field> getFieldsByType(Object object, Class<?> type) {
        Field[] fields;
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            if (!type.isAssignableFrom(field.getType())) continue;
            list.add(field);
        }
        return list;
    }

    public static Class<?> getPropertyType(Class<?> type, String name) throws NoSuchFieldException {
        return ReflectionOpt.getDeclaredField(type, name).getType();
    }

    public static String methodNameToField(String methodName) {
        if (methodName == null) {
            return null;
        }
        int sl = methodName.length();
        if (sl > 3 && (methodName.startsWith("get") || methodName.startsWith("set"))) {
            return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        }
        if (sl > 2 && methodName.startsWith("is")) {
            return methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
        }
        return methodName;
    }

    public static Method getGetterMethod(Class<?> classType, Class<?> propertyType, String fieldName) {
        try {
            String getFuncName = Boolean.TYPE.equals(propertyType) || Boolean.class.isAssignableFrom(propertyType) ? "is" + StringUtils.capitalize((String)fieldName) : "get" + StringUtils.capitalize((String)fieldName);
            Method md = classType.getMethod(getFuncName, new Class[0]);
            if (propertyType.isAssignableFrom(md.getReturnType())) {
                return md;
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Method getGetterMethod(Class<?> classType, String fieldName) {
        try {
            Method md = classType.getMethod("get" + StringUtils.capitalize((String)fieldName), new Class[0]);
            if (Void.TYPE.equals(md.getReturnType())) {
                return null;
            }
            return md;
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Method getSetterMethod(Class<?> classType, Class<?> propertyType, String fieldName) {
        try {
            return classType.getMethod("set" + StringUtils.capitalize((String)fieldName), propertyType);
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object attainExpressionValue(Object sourceObj, String expression) {
        String fieldValue;
        if (sourceObj == null || expression == null || "".equals(expression)) {
            return null;
        }
        if (".".equals(expression)) {
            return sourceObj;
        }
        int nPos = expression.indexOf(46);
        String restExpression = ".";
        if (nPos > 0) {
            fieldValue = expression.substring(0, nPos);
            if (expression.length() > nPos + 1) {
                restExpression = expression.substring(nPos + 1);
            }
        } else {
            fieldValue = expression;
        }
        int nAarrayInd = -1;
        nPos = fieldValue.indexOf(91);
        if (nPos > 0) {
            String sArrayInd = fieldValue.substring(nPos + 1, fieldValue.length() - 1);
            if (StringRegularOpt.isNumber(sArrayInd)) {
                nAarrayInd = Double.valueOf(sArrayInd).intValue();
            }
            fieldValue = fieldValue.substring(0, nPos);
        }
        Object retObj = null;
        if (sourceObj instanceof Map) {
            Map objMap = (Map)sourceObj;
            retObj = objMap.get(fieldValue);
        } else {
            if (ReflectionOpt.isScalarType(sourceObj.getClass())) {
                return null;
            }
            retObj = ReflectionOpt.getFieldValue(sourceObj, fieldValue);
        }
        if (retObj == null) {
            return null;
        }
        if (retObj instanceof Collection) {
            Collection objlist = (Collection)retObj;
            int objSize = objlist.size();
            if (objSize < 1) {
                return null;
            }
            if (nAarrayInd >= 0) {
                if (nAarrayInd < objSize) {
                    int i = 0;
                    for (Object obj : objlist) {
                        if (nAarrayInd == i) {
                            return ReflectionOpt.attainExpressionValue(obj, restExpression);
                        }
                        ++i;
                    }
                }
                return null;
            }
            Object[] retObjArray = new Object[objSize];
            int i = 0;
            for (Object obj : objlist) {
                retObjArray[i] = ReflectionOpt.attainExpressionValue(obj, restExpression);
                ++i;
            }
            return retObjArray;
        }
        if (retObj instanceof Object[]) {
            Object[] objs = (Object[])retObj;
            int objSize = objs.length;
            if (objSize < 1) {
                return null;
            }
            if (nAarrayInd >= 0) {
                if (nAarrayInd < objSize) {
                    return ReflectionOpt.attainExpressionValue(objs[nAarrayInd], restExpression);
                }
                return null;
            }
            Object[] retObjArray = new Object[objSize];
            int i = 0;
            for (Object obj : objs) {
                retObjArray[i] = ReflectionOpt.attainExpressionValue(obj, restExpression);
                ++i;
            }
            return retObjArray;
        }
        return ReflectionOpt.attainExpressionValue(retObj, restExpression);
    }

    public static Boolean getBooleanFieldValue(Object obj, String fieldName) {
        try {
            Method md = obj.getClass().getMethod("is" + StringUtils.capitalize((String)fieldName), new Class[0]);
            if (md == null) {
                return null;
            }
            Object objValue = md.invoke(obj, new Object[0]);
            if (objValue == null) {
                return null;
            }
            if (objValue instanceof Boolean) {
                return (Boolean)objValue;
            }
            return Boolean.valueOf(objValue.toString());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Method getBooleanGetterMethod(Class<?> classType, String fieldName) {
        try {
            return classType.getMethod("is" + StringUtils.capitalize((String)fieldName), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<Method> getAllGetterMethod(Class<?> type) {
        try {
            Method[] mths = type.getMethods();
            ArrayList<Method> getMths = new ArrayList<Method>();
            for (Method mth : mths) {
                if (!mth.getName().startsWith("get") && !mth.getName().startsWith("is") || mth.getName().equals("getClass") || Void.TYPE.equals(mth.getReturnType()) || mth.getGenericParameterTypes().length >= 1) continue;
                getMths.add(mth);
            }
            return getMths;
        }
        catch (SecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<Method> getAllSetterMethod(Class<?> type) {
        try {
            Method[] mths = type.getMethods();
            ArrayList<Method> setMths = new ArrayList<Method>();
            for (Method mth : mths) {
                String methodName = mth.getName();
                if (!methodName.startsWith("set") || methodName.length() < 4 || mth.getGenericParameterTypes().length != 1) continue;
                setMths.add(mth);
            }
            return setMths;
        }
        catch (SecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void invokeNoParamFunc(Object demander, String smethod) {
        try {
            Method setV = demander.getClass().getMethod(smethod, new Class[0]);
            setV.invoke(demander, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static <T> void invokeBinaryOpt(T demander, String smethod, T param) {
        try {
            Method setV = demander.getClass().getMethod(smethod, demander.getClass());
            setV.invoke(demander, param);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz) {
        return ReflectionOpt.getSuperClassGenricType(clazz, 0);
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warn(clazz.getSimpleName() + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn(clazz.getSimpleName() + " not set the actual class on superclass generic parameter");
            return Object.class;
        }
        return (Class)params[index];
    }

    public static boolean isPrimitiveType(Class<?> tp) {
        return tp.isPrimitive() || tp.getName().startsWith("java.lang.");
    }

    public static boolean isScalarType(Class<?> tp) {
        if (tp.isPrimitive()) {
            return true;
        }
        String tpName = tp.getName();
        if (tpName.startsWith("java.lang.")) {
            return true;
        }
        if (tpName.startsWith("java.sql.")) {
            return true;
        }
        if (Date.class.isAssignableFrom(tp)) {
            return true;
        }
        return UUID.class.isAssignableFrom(tp);
    }

    public static boolean isNumberType(Class<?> tp) {
        return Number.class.isAssignableFrom(tp);
    }

    public static boolean isArray(Object obj) {
        Class<?> tp = obj.getClass();
        if (tp.isArray()) {
            return true;
        }
        return obj instanceof Collection;
    }

    public static boolean isArrayType(Class<?> tp) {
        if (tp.isArray()) {
            return true;
        }
        return Collection.class.isAssignableFrom(tp);
    }

    public static Object addTwoObject(Object a, Object b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).doubleValue() + ((Number)b).doubleValue();
        }
        return a.toString() + b.toString();
    }

    public static String getCurrentMethodName() {
        return Thread.currentThread().getStackTrace()[1].getMethodName();
    }

    public <T> T createObjectByMap(Class<T> clazz, Map<String, Object> properties) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        T obj = clazz.newInstance();
        try {
            Method[] mths;
            for (Method mth : mths = clazz.getMethods()) {
                Object value;
                Type[] paramTypes = mth.getGenericParameterTypes();
                String methodName = mth.getName();
                if (!methodName.startsWith("set") || methodName.length() < 4 || paramTypes.length != 1 || (value = properties.get(methodName.substring(3, 4).toLowerCase() + methodName.substring(4))) == null) continue;
                mth.invoke(obj, value);
            }
        }
        catch (SecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return obj;
    }

    public static String getJavaTypeName(Class<?> type) {
        String typeName = type.getTypeName();
        if (typeName.indexOf(46) < 1) {
            return typeName;
        }
        if (typeName.startsWith("java.lang.") || typeName.startsWith("java.sql.") || "java.util.Date".equals(typeName) || "java.util.UUID".equals(typeName) || "java.math.BigDecimal".equals(typeName) || "java.math.BigInteger".equals(typeName)) {
            return FileType.getFileExtName(typeName);
        }
        return typeName;
    }
}

