/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import java.util.UUID;

public abstract class UuidOpt {
    private UuidOpt() {
        throw new IllegalAccessError("Utility class");
    }

    public static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public static String uuidToString32(UUID uuid) {
        long leastSigBits = uuid.getLeastSignificantBits();
        long mostSigBits = uuid.getMostSignificantBits();
        return Long.toHexString(mostSigBits) + Long.toHexString(leastSigBits);
    }

    public static String uuidToString36(UUID uuid) {
        long leastSigBits = uuid.getLeastSignificantBits();
        long mostSigBits = uuid.getMostSignificantBits();
        return UuidOpt.digits(mostSigBits >> 32, 8) + "-" + UuidOpt.digits(mostSigBits >> 16, 4) + "-" + UuidOpt.digits(mostSigBits, 4) + "-" + UuidOpt.digits(leastSigBits >> 48, 4) + "-" + UuidOpt.digits(leastSigBits, 12);
    }

    public static String getUuidAsString36() {
        return UuidOpt.uuidToString36(UUID.randomUUID());
    }

    public static String getUuidAsString32() {
        return UuidOpt.uuidToString32(UUID.randomUUID());
    }

    public static String getUuidAsString() {
        return UuidOpt.uuidToString32(UUID.randomUUID());
    }
}

