/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.network;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UrlOptUtils {
    protected static final Logger logger = LoggerFactory.getLogger(UrlOptUtils.class);
    private static final String ALLOWED_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()";

    private UrlOptUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static final String getUrlParamter(String szUrl) {
        String sQuery;
        try {
            URL url = new URL(szUrl);
            sQuery = url.getQuery();
        }
        catch (MalformedURLException e) {
            int n = szUrl.indexOf(63);
            int nM = szUrl.lastIndexOf(35);
            if (nM > 0 && nM > n) {
                sQuery = n > 0 ? szUrl.substring(n + 1, nM) : szUrl.substring(0, nM);
            }
            sQuery = n > 0 ? szUrl.substring(n + 1) : "";
        }
        return sQuery;
    }

    public static final Map<String, String> splitUrlParamter(String szUrlParameter) {
        int n;
        HashMap<String, String> params = new HashMap<String, String>();
        int bpos = 0;
        while ((n = szUrlParameter.indexOf(61, bpos)) >= 0) {
            String value;
            String name = szUrlParameter.substring(bpos, n);
            int n2 = szUrlParameter.indexOf(38, n + 1);
            if (n2 < 0) {
                value = szUrlParameter.substring(n + 1);
                try {
                    value = URLDecoder.decode(value, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                params.put(name, value);
                break;
            }
            value = szUrlParameter.substring(n + 1, n2);
            try {
                value = URLDecoder.decode(value, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            params.put(name, value);
            bpos = n2 + 1;
        }
        return params;
    }

    public static String encodeURIComponent(String input) {
        if (StringUtils.isEmpty((CharSequence)input)) {
            return input;
        }
        int l = input.length();
        StringBuilder o = new StringBuilder(l * 3);
        try {
            for (int i = 0; i < l; ++i) {
                String e = input.substring(i, i + 1);
                if (ALLOWED_CHARS.indexOf(e) == -1) {
                    byte[] b = e.getBytes("utf-8");
                    o.append(UrlOptUtils.getHex(b));
                    continue;
                }
                o.append(e);
            }
            return o.toString();
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return input;
        }
    }

    private static String getHex(byte[] buf) {
        StringBuilder o = new StringBuilder(buf.length * 3);
        for (int i = 0; i < buf.length; ++i) {
            int n = buf[i] & 0xFF;
            o.append("%");
            if (n < 16) {
                o.append("0");
            }
            o.append(Long.toString(n, 16).toUpperCase());
        }
        return o.toString();
    }

    public static String getUrlDomain(String curl) {
        try {
            return new URL(curl).getHost();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

