/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PropertiesReader {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesReader.class);

    private PropertiesReader() {
        throw new IllegalAccessError("Utility class");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getClassPathProperty(String fileName, String key) {
        try (InputStream in = PropertiesReader.class.getResourceAsStream(fileName);){
            String string = PropertiesReader.getPropertyValue(in, key);
            return string;
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getClassPathProperty(Class<?> clazz, String fileName, String key) {
        try (InputStream in = clazz.getResourceAsStream(fileName);){
            String string = PropertiesReader.getPropertyValue(in, key);
            return string;
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFilePathProperty(String fileName, String key) {
        try (FileInputStream fis = new FileInputStream(new File(fileName));){
            String string = PropertiesReader.getPropertyValue(fis, key);
            return string;
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties getClassPathProperties(String fileName) {
        try (InputStream in = PropertiesReader.class.getResourceAsStream(fileName);){
            Properties properties = PropertiesReader.loadProperties(in);
            return properties;
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties getClassPathProperties(Class<?> clazz, String fileName) {
        try (InputStream in = clazz.getResourceAsStream(fileName);){
            Properties properties = PropertiesReader.loadProperties(in);
            return properties;
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties getFilePathProperties(String fileName) {
        try (FileInputStream fis = new FileInputStream(new File(fileName));){
            Properties properties = PropertiesReader.loadProperties(fis);
            return properties;
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    private static String getPropertyValue(InputStream resource, String key) throws IOException {
        Properties prop = new Properties();
        prop.load(resource);
        return prop.getProperty(key);
    }

    private static Properties loadProperties(InputStream resource) throws IOException {
        Properties prop = new Properties();
        prop.load(resource);
        return prop;
    }
}

