/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.security;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Sha1Encoder {
    protected static final Logger logger = LoggerFactory.getLogger(Sha1Encoder.class);

    private Sha1Encoder() {
        throw new IllegalAccessError("Utility class");
    }

    public static String encode(byte[] data) {
        try {
            MessageDigest SHA1 = MessageDigest.getInstance("SHA-1");
            SHA1.update(data, 0, data.length);
            return new String(Hex.encodeHex((byte[])SHA1.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String encode(String data) {
        try {
            return Sha1Encoder.encode(data.getBytes("utf8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

