/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import com.alibaba.fastjson2.JSON;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.file.FileIOOpt;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.Date;

public abstract class ByteBaseOpt {
    private ByteBaseOpt() {
        throw new IllegalAccessError("Utility class");
    }

    public static byte[] castObjectToBytes(Object obj) {
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            if (len == 0) {
                return null;
            }
            Object firstObj = Array.get(obj, 0);
            if (firstObj instanceof Byte) {
                byte[] bytes = new byte[len];
                for (int i = 0; i < len; ++i) {
                    Object bObj = Array.get(obj, i);
                    bytes[i] = (Byte)bObj;
                }
                return bytes;
            }
            if (firstObj instanceof Character) {
                byte[] bytes = new byte[len];
                for (int i = 0; i < len; ++i) {
                    Object bObj = Array.get(obj, i);
                    bytes[i] = (byte)((Character)bObj).charValue();
                }
                return bytes;
            }
            return JSON.toJSONString((Object)obj).getBytes(StandardCharsets.UTF_8);
        }
        if (obj instanceof Long) {
            byte[] buf = new byte[8];
            ByteBaseOpt.writeInt64(buf, (Long)obj, 0);
            return buf;
        }
        if (obj instanceof Integer) {
            byte[] buf = new byte[4];
            ByteBaseOpt.writeInt32(buf, (Integer)obj, 0);
            return buf;
        }
        if (obj instanceof Date) {
            byte[] buf = new byte[8];
            ByteBaseOpt.writeInt64(buf, ((Date)obj).getTime(), 0);
            return buf;
        }
        if (obj instanceof Float) {
            byte[] buf = new byte[4];
            ByteBaseOpt.writeFloat(buf, ((Float)obj).floatValue(), 0);
            return buf;
        }
        if (obj instanceof Double) {
            byte[] buf = new byte[8];
            ByteBaseOpt.writeDouble(buf, (Double)obj, 0);
            return buf;
        }
        if (obj instanceof InputStream) {
            try {
                return FileIOOpt.readBytesFromInputStream((InputStream)obj);
            }
            catch (IOException e) {
                return null;
            }
        }
        return JSON.toJSONString((Object)obj).getBytes(StandardCharsets.UTF_8);
    }

    public static int writeInt64(byte[] buf, long data, int offset) {
        for (int i = 0; i < 8; ++i) {
            buf[offset + 7 - i] = (byte)(data & 0xFFL);
            data >>= 8;
        }
        return offset + 8;
    }

    public static int writeLong(byte[] buf, long data, int offset) {
        return ByteBaseOpt.writeInt64(buf, data, offset);
    }

    public static int writeInt32(byte[] buf, int data, int offset) {
        for (int i = 0; i < 4; ++i) {
            buf[offset + 3 - i] = (byte)(data & 0xFF);
            data >>= 8;
        }
        return offset + 4;
    }

    public static int writeUInt32(byte[] buf, long data, int offset) {
        for (int i = 0; i < 4; ++i) {
            buf[offset + 3 - i] = (byte)(data & 0xFFL);
            data >>= 8;
        }
        return offset + 4;
    }

    public static int writeInt(byte[] buf, int data, int offset) {
        return ByteBaseOpt.writeInt32(buf, data, offset);
    }

    public static int writeInt16(byte[] buf, short data, int offset) {
        for (int i = 0; i < 2; ++i) {
            buf[offset + 1 - i] = Integer.valueOf(data & 0xFF).byteValue();
            data = (short)(data >> 8);
        }
        return offset + 2;
    }

    public static int writeUInt16(byte[] buf, int data, int offset) {
        for (int i = 0; i < 2; ++i) {
            buf[offset + 1 - i] = (byte)(data & 0xFF);
            data = (short)(data >> 8);
        }
        return offset + 2;
    }

    public static int writeShort(byte[] buf, short data, int offset) {
        return ByteBaseOpt.writeInt16(buf, data, offset);
    }

    public static int writeFloat(byte[] buf, float data, int offset) {
        int intDate = Float.floatToIntBits(data);
        return ByteBaseOpt.writeInt32(buf, intDate, offset);
    }

    public static int writeDouble(byte[] buf, double data, int offset) {
        long longDate = Double.doubleToLongBits(data);
        return ByteBaseOpt.writeInt64(buf, longDate, offset);
    }

    public static int writeStringAsBytes(byte[] buf, String data, int offset) {
        byte[] strBytes = data.getBytes();
        System.arraycopy(strBytes, 0, buf, offset, strBytes.length);
        return offset + data.length();
    }

    public static int writeString(byte[] buf, String data, int offset) {
        for (int i = 0; i < data.length(); ++i) {
            buf[offset + i] = (byte)data.charAt(i);
        }
        return offset + data.length();
    }

    public static int writeString(byte[] buf, char[] data, int offset) {
        for (int i = 0; i < data.length; ++i) {
            buf[offset + i] = (byte)data[i];
        }
        return offset + data.length;
    }

    public static int writeStringApendSpace(byte[] buf, String data, int len, int offset) {
        int i;
        int dataLen;
        int n = dataLen = data.length() < len ? data.length() : len;
        for (i = 0; i < dataLen; ++i) {
            buf[offset + i] = (byte)data.charAt(i);
        }
        while (i < len) {
            buf[offset + i] = 32;
            ++i;
        }
        return offset + data.length();
    }

    public static int writeStringApendSpace(byte[] buf, char[] data, int len, int offset) {
        int i;
        int dataLen;
        int n = dataLen = data.length < len ? data.length : len;
        for (i = 0; i < dataLen; ++i) {
            buf[offset + i] = (byte)data[i];
        }
        while (i < len) {
            buf[offset + i] = 32;
            ++i;
        }
        return offset + data.length;
    }

    public static int writeDate(byte[] buf, Date data, int offset) {
        return ByteBaseOpt.writeLong(buf, data.getTime(), offset);
    }

    public static int writeDateAsInt32(byte[] buf, Date data, int offset) {
        int intDate = DatetimeOpt.getYear(data) * 10000 + DatetimeOpt.getMonth(data) * 100 + DatetimeOpt.getDay(data);
        return ByteBaseOpt.writeInt32(buf, intDate, offset);
    }

    public static int writeDatetimeAsInt64(byte[] buf, Date data, int offset) {
        long longDate = (long)DatetimeOpt.getYear(data) * 10000000000L + (long)DatetimeOpt.getMonth(data) * 100000000L + (long)DatetimeOpt.getDay(data) * 1000000L + (long)DatetimeOpt.getHour(data) * 10000L + (long)DatetimeOpt.getMinute(data) * 100L + (long)DatetimeOpt.getSecond(data);
        return ByteBaseOpt.writeInt64(buf, longDate, offset);
    }

    public static int writeTimestampAsInt64(byte[] buf, Date data, int offset) {
        long longDate = (long)DatetimeOpt.getYear(data) * 10000000000000L + (long)DatetimeOpt.getMonth(data) * 100000000000L + (long)DatetimeOpt.getDay(data) * 1000000000L + (long)DatetimeOpt.getHour(data) * 10000000L + (long)DatetimeOpt.getMinute(data) * 100000L + (long)DatetimeOpt.getSecond(data) * 1000L + (long)DatetimeOpt.getMilliSecond(data);
        return ByteBaseOpt.writeInt64(buf, longDate, offset);
    }

    public static long readInt64(byte[] buf, int offset) {
        long longData = 0L;
        for (int i = 0; i < 8; ++i) {
            longData <<= 8;
            longData += (long)(buf[offset + i] & 0xFF);
        }
        return longData;
    }

    public static long readLong(byte[] buf, int offset) {
        return ByteBaseOpt.readInt64(buf, offset);
    }

    public static int readInt32(byte[] buf, int offset) {
        int intData = 0;
        for (int i = 0; i < 4; ++i) {
            intData <<= 8;
            intData += buf[offset + i] & 0xFF;
        }
        return intData;
    }

    public static long readUInt32(byte[] buf, int offset) {
        long intData = 0L;
        for (int i = 0; i < 4; ++i) {
            intData <<= 8;
            intData += (long)(buf[offset + i] & 0xFF);
        }
        return intData;
    }

    public static int readInt(byte[] buf, int offset) {
        return ByteBaseOpt.readInt32(buf, offset);
    }

    public static short readInt16(byte[] buf, int offset) {
        short intData = 0;
        for (int i = 0; i < 2; ++i) {
            intData = (short)(intData << 8);
            intData = (short)(intData + (buf[offset + i] & 0xFF));
        }
        return intData;
    }

    public static int readUInt16(byte[] buf, int offset) {
        int intData = 0;
        for (int i = 0; i < 2; ++i) {
            intData <<= 8;
            intData += buf[offset + i] & 0xFF;
        }
        return intData;
    }

    public static short readShort(byte[] buf, int offset) {
        return ByteBaseOpt.readInt16(buf, offset);
    }

    public static float readFloat(byte[] buf, int offset) {
        int intData = ByteBaseOpt.readInt32(buf, offset);
        return Float.intBitsToFloat(intData);
    }

    public static double readDouble(byte[] buf, int offset) {
        long longData = ByteBaseOpt.readInt64(buf, offset);
        return Double.longBitsToDouble(longData);
    }

    public static String readString(byte[] buf, int length, int offset) {
        char[] str = new char[length];
        for (int i = 0; i < length; ++i) {
            str[i] = (char)buf[offset + i];
        }
        return String.valueOf(str);
    }

    public static Date readDate(byte[] buf, int offset) {
        long dateTime = ByteBaseOpt.readLong(buf, offset);
        return new Date(dateTime);
    }

    public static Date readDateAsInt32(byte[] buf, int offset) {
        int intDate = ByteBaseOpt.readInt32(buf, offset);
        return DatetimeOpt.createUtilDate(intDate / 10000, intDate / 100 % 100, intDate % 100);
    }

    public static Date readDatetimeAsInt64(byte[] buf, int offset) {
        long longDate = ByteBaseOpt.readInt64(buf, offset);
        return DatetimeOpt.createUtilDate((int)(longDate / 10000000000L), (int)(longDate / 100000000L % 100L), (int)(longDate / 1000000L % 100L), (int)(longDate / 10000L % 100L), (int)(longDate / 100L % 100L), (int)(longDate % 100L));
    }

    public static Date readTimestampAsInt64(byte[] buf, int offset) {
        long longDate = ByteBaseOpt.readInt64(buf, offset);
        return DatetimeOpt.createUtilDate((int)(longDate / 10000000000000L), (int)(longDate / 100000000000L % 100L), (int)(longDate / 1000000000L % 100L), (int)(longDate / 10000000L % 100L), (int)(longDate / 100000L % 100L), (int)(longDate / 1000L % 100L), (int)(longDate % 1000L));
    }
}

