/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import com.alibaba.fastjson2.JSON;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.file.FileIOOpt;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.sourceforge.pinyin4j.PinyinHelper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StringBaseOpt {
    protected static final Logger logger = LoggerFactory.getLogger(StringBaseOpt.class);
    private static final int[] li_SecPosValue = new int[]{1601, 1637, 1833, 2078, 2274, 2302, 2433, 2594, 2787, 3106, 3212, 3472, 3635, 3722, 3730, 3858, 4027, 4086, 4390, 4558, 4684, 4925, 5249, 5590};
    private static final String[] lc_FirstLetter = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "w", "x", "y", "z"};

    private StringBaseOpt() {
        throw new IllegalAccessError("Utility class");
    }

    public static String encodeBase64(String str) {
        return new String(Base64.encodeBase64((byte[])str.getBytes()));
    }

    public static String decodeBase64(String str) {
        return new String(Base64.decodeBase64((byte[])str.getBytes()));
    }

    public static byte[] compress(String str) throws IOException {
        if (null == str || str.length() <= 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(str.getBytes());
        gzip.close();
        return out.toByteArray();
    }

    public static String unCompress(byte[] str) throws IOException {
        int n;
        if (null == str || str.length <= 0) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(str);
        GZIPInputStream gzip = new GZIPInputStream(in);
        byte[] buffer = new byte[256];
        while ((n = gzip.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
        return out.toString("utf-8");
    }

    public static String concat(Object ... objs) {
        StringBuilder sb = new StringBuilder();
        if (objs != null && objs.length > 0) {
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] == null) continue;
                sb.append(StringBaseOpt.objectToString(objs[i]));
            }
        }
        return sb.toString();
    }

    public static String concat(Object[] objs, String separator) {
        StringBuilder sb = new StringBuilder();
        int objInd = 0;
        if (objs != null && objs.length > 0) {
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] == null) continue;
                if (objInd > 0) {
                    sb.append(separator);
                }
                ++objInd;
                sb.append(StringBaseOpt.objectToString(objs[i]));
            }
        }
        return sb.toString();
    }

    public static String concat(Collection<Object> objs, String separator) {
        StringBuilder sb = new StringBuilder();
        if (objs != null && objs.size() > 0) {
            int i = 0;
            for (Object obj : objs) {
                if (obj == null) continue;
                if (i > 0) {
                    sb.append(separator);
                }
                ++i;
                sb.append(StringBaseOpt.objectToString(obj));
            }
        }
        return sb.toString();
    }

    public static boolean contains(String[] strs, String str) {
        if (strs == null) {
            return false;
        }
        for (String str1 : strs) {
            if (!str1.contains(str)) continue;
            return true;
        }
        return false;
    }

    public static String deleteStringByQuote(String str, String quote) {
        if (null == str || "".equals(str)) {
            return "";
        }
        return StringUtils.replace((String)str.trim(), (String)("_" + quote), (String)"");
    }

    public static int indexOf(String[] strs, String str) {
        int index = -1;
        if (null != strs) {
            for (int i = 0; i < strs.length; ++i) {
                if (!strs[i].contains(str)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public static boolean isNvl(String str) {
        return StringUtils.isBlank((CharSequence)str);
    }

    public static String nvlAsBlank(String str) {
        return str == null ? "" : str;
    }

    public static String emptyValue(String str, String emptyValue) {
        return StringUtils.isBlank((CharSequence)str) ? emptyValue : str;
    }

    public static String fillZeroForString(String str, int size) {
        return StringUtils.leftPad((String)str, (int)size, (char)'0');
    }

    public static String midPad(String str, int size, String prefix, char padChar) {
        return prefix == null ? StringUtils.leftPad((String)str, (int)size, (char)padChar) : prefix + StringUtils.leftPad((String)str, (int)(size - prefix.length()), (char)padChar);
    }

    public static String midPad(String str, int size, String prefix, String padChar) {
        return prefix == null ? StringUtils.leftPad((String)str, (int)size, (String)padChar) : prefix + StringUtils.leftPad((String)str, (int)(size - prefix.length()), (String)padChar);
    }

    public static String multiplyString(String str, int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    @Deprecated
    public static String clacDocumentNo(String templet, long currNo, Map<String, String> params) {
        if (StringRegularOpt.isNvl(templet)) {
            return String.valueOf(currNo);
        }
        String sDocNo = templet;
        if (sDocNo.contains("$N")) {
            int firstBegin = sDocNo.indexOf("$N");
            int firstEnd = firstBegin + 2;
            int secondBegin = sDocNo.indexOf("$", firstEnd);
            int nunber = 0;
            if (secondBegin > firstEnd) {
                nunber = Integer.parseInt(sDocNo.substring(firstEnd, secondBegin));
            }
            sDocNo = sDocNo.substring(0, firstBegin) + StringBaseOpt.fillZeroForString(String.valueOf(currNo), nunber) + sDocNo.substring(secondBegin + 1);
        }
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                sDocNo = sDocNo.replaceAll("\\$" + param.getKey() + "\\$", param.getValue());
            }
        }
        sDocNo = sDocNo.replaceAll("\\$year\\$", String.valueOf(DatetimeOpt.getYear(DatetimeOpt.currentUtilDate())));
        sDocNo = sDocNo.replaceAll("\\$Y2\\$", String.valueOf(DatetimeOpt.getYear(DatetimeOpt.currentUtilDate())).substring(2, 4));
        return sDocNo;
    }

    public static String prevCode(String sCode) {
        int nSL = sCode.length();
        String sRes = "";
        int i = nSL;
        while (i > 0) {
            char c;
            if ((c = sCode.charAt(--i)) == '0') {
                sRes = '9' + sRes;
                continue;
            }
            if (c == 'a') {
                sRes = 'z' + sRes;
                continue;
            }
            if (c == 'A') {
                sRes = 'Z' + sRes;
                continue;
            }
            c = (char)(c - '\u0001');
            sRes = c + sRes;
            break;
        }
        if (i > 0) {
            sRes = sCode.substring(0, i) + sRes;
        }
        return sRes;
    }

    public static String nextCode(String sCode) {
        int nSL = sCode.length();
        String sRes = "";
        int i = nSL;
        while (i > 0) {
            char c;
            if ((c = sCode.charAt(--i)) == '9') {
                sRes = '0' + sRes;
                continue;
            }
            if (c == 'z') {
                sRes = 'a' + sRes;
                continue;
            }
            if (c == 'Z') {
                sRes = 'A' + sRes;
                continue;
            }
            c = (char)(c + '\u0001');
            sRes = c + sRes;
            break;
        }
        if (i > 0) {
            sRes = sCode.substring(0, i) + sRes;
        }
        return sRes;
    }

    private static char getPinYinShenMu(char ch) {
        String[] res1 = PinyinHelper.toHanyuPinyinStringArray((char)ch);
        if (res1.length > 0) {
            return res1[0].charAt(0);
        }
        return ' ';
    }

    public static String getFirstLetter(String oriStr) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < oriStr.length(); ++i) {
            sb.append(StringBaseOpt.getPinYinShenMu(oriStr.charAt(i)));
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFileToBuffer(String sFileName) {
        try (FileInputStream in = new FileInputStream(sFileName);){
            int len;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            byte[] readBytes = out.toByteArray();
            String string = new String(readBytes);
            return string;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String readJarResourceToBuffer(Class<?> clazz, String sResourceName) {
        StringBuilder buffer = new StringBuilder();
        try {
            InputStream in = clazz.getResourceAsStream(sResourceName);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String line = br.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append("\r\n");
                line = br.readLine();
            }
            br.close();
            in.close();
            return buffer.toString();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String objectToString(Object objValue) {
        if (objValue == null) {
            return null;
        }
        if (objValue instanceof String) {
            return (String)objValue;
        }
        if (objValue instanceof byte[]) {
            return new String((byte[])objValue);
        }
        if (objValue instanceof Date) {
            return DatetimeOpt.convertTimestampToString((Date)objValue);
        }
        if (objValue instanceof InputStream) {
            try {
                return FileIOOpt.readStringFromInputStream((InputStream)objValue);
            }
            catch (IOException e) {
                return "";
            }
        }
        Class<?> clazz = objValue.getClass();
        if (clazz.isEnum()) {
            return ((Enum)objValue).name();
        }
        if (ReflectionOpt.isScalarType(clazz)) {
            return objValue.toString();
        }
        if (clazz.isArray()) {
            int len = Array.getLength(objValue);
            StringBuilder sb = new StringBuilder();
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(StringBaseOpt.objectToString(Array.get(objValue, i)));
                }
                return sb.toString();
            }
            return null;
        }
        if (objValue instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            int vc = 0;
            Collection valueList = (Collection)objValue;
            for (Object ov : valueList) {
                if (ov == null) continue;
                if (vc > 0) {
                    sb.append(",");
                }
                sb.append(StringBaseOpt.objectToString(ov));
                ++vc;
            }
            return sb.toString();
        }
        return JSON.toJSONString((Object)objValue);
    }

    public static String[] objectToStringArray(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            String[] stringList = new String[]{StringBaseOpt.castObjectToString(object)};
            return stringList;
        }
        if (object.getClass().isArray()) {
            int len = Array.getLength(object);
            String[] stringList = new String[len];
            for (int i = 0; i < len; ++i) {
                Object obj = Array.get(object, i);
                stringList[i++] = StringBaseOpt.castObjectToString(obj);
            }
            return stringList;
        }
        if (object instanceof Collection) {
            String[] stringList = new String[((Collection)object).size()];
            int i = 0;
            for (Object po : (Collection)object) {
                stringList[i++] = StringBaseOpt.castObjectToString(po);
            }
            return stringList;
        }
        if (object instanceof String) {
            return ((String)object).split(",");
        }
        String[] stringList = new String[]{StringBaseOpt.castObjectToString(object)};
        return stringList;
    }

    public static List<String> objectToStringList(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            ArrayList<String> stringList = new ArrayList<String>(1);
            stringList.add(StringBaseOpt.castObjectToString(object));
            return stringList;
        }
        if (object.getClass().isArray()) {
            int len = Array.getLength(object);
            ArrayList<String> stringList = new ArrayList<String>(len + 1);
            for (int i = 0; i < len; ++i) {
                Object obj = Array.get(object, i);
                stringList.add(StringBaseOpt.castObjectToString(obj));
            }
            return stringList;
        }
        if (object instanceof Collection) {
            ArrayList<String> stringList = new ArrayList<String>(((Collection)object).size() + 1);
            for (Object po : (Collection)object) {
                stringList.add(StringBaseOpt.castObjectToString(po));
            }
            return stringList;
        }
        if (object instanceof String) {
            String[] ss = ((String)object).split(",");
            ArrayList<String> stringList = new ArrayList<String>(ss.length);
            stringList.addAll(Arrays.asList(ss));
            return stringList;
        }
        ArrayList<String> stringList = new ArrayList<String>(1);
        stringList.add(StringBaseOpt.castObjectToString(object));
        return stringList;
    }

    public static Set<String> objectToStringSet(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            int len = Array.getLength(object);
            HashSet<String> stringSet = new HashSet<String>(len + 1);
            for (int i = 0; i < len; ++i) {
                Object obj = Array.get(object, i);
                stringSet.add(StringBaseOpt.castObjectToString(obj));
            }
            return stringSet;
        }
        if (object instanceof Collection) {
            HashSet<String> stringSet = new HashSet<String>(((Collection)object).size() + 1);
            for (Object po : (Collection)object) {
                stringSet.add(StringBaseOpt.castObjectToString(po));
            }
            return stringSet;
        }
        if (object instanceof String) {
            String[] ss = ((String)object).split(",");
            HashSet<String> stringList = new HashSet<String>(ss.length);
            for (String s : ss) {
                stringList.add(s);
            }
            return stringList;
        }
        HashSet<String> stringSet = new HashSet<String>(1);
        stringSet.add(StringBaseOpt.castObjectToString(object));
        return stringSet;
    }

    public static Map<String, Set<String>> objectToMapStrSet(Object object) {
        Map<String, Object> objMap = CollectionsOpt.objectToMap(object);
        HashMap<String, Set<String>> strMap = new HashMap<String, Set<String>>(objMap.size() + 1);
        for (Map.Entry<String, Object> ent : objMap.entrySet()) {
            strMap.put(ent.getKey(), StringBaseOpt.objectToStringSet(ent.getValue()));
        }
        return strMap;
    }

    public static Map<String, List<String>> objectToMapStrArray(Object object) {
        Map<String, Object> objMap = CollectionsOpt.objectToMap(object);
        HashMap<String, List<String>> strMap = new HashMap<String, List<String>>(objMap.size() + 1);
        for (Map.Entry<String, Object> ent : objMap.entrySet()) {
            strMap.put(ent.getKey(), StringBaseOpt.objectToStringList(ent.getValue()));
        }
        return strMap;
    }

    public static String castObjectToString(Object obj) {
        return StringBaseOpt.objectToString(obj);
    }

    public static String castObjectToString(Object obj, String defaultValue) {
        return GeneralAlgorithm.nvl(StringBaseOpt.objectToString(obj), defaultValue);
    }

    public static <T> T stringToScalarData(String sdata, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)sdata)) {
            return null;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return (T)Integer.valueOf(sdata);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return (T)Long.valueOf(sdata);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return (T)Double.valueOf(sdata);
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return (T)Boolean.valueOf(sdata);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return (T)Float.valueOf(sdata);
        }
        if (clazz == String.class) {
            return (T)sdata;
        }
        if (clazz == Date.class) {
            return (T)DatetimeOpt.smartPraseDate(sdata);
        }
        if (clazz == UUID.class) {
            return (T)UUID.fromString(sdata);
        }
        return null;
    }
}

