/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import java.io.Serializable;
import java.util.Date;

public class WorkTimeSpan
extends Number
implements Serializable {
    public static final long DEFAULT_DAY_WORK_MILLISECONDS = 28800000L;
    public static final long DEFAULT_DAY_WORK_MINUTES = 480L;
    public static final long DAY_MILLISECONDS = 86400000L;
    public static final long HOUR_MILLISECONDS = 3600000L;
    public static final long MINUTE_MILLISECONDS = 60000L;
    public static final long SECOND_MILLISECONDS = 1000L;
    private static final long serialVersionUID = 1L;
    private long dayWorkMilliseconds;
    private long timeSpan;

    public WorkTimeSpan() {
        this.dayWorkMilliseconds = 28800000L;
        this.timeSpan = 0L;
    }

    @Override
    public int intValue() {
        return Long.valueOf(this.timeSpan).intValue();
    }

    @Override
    public long longValue() {
        return this.timeSpan;
    }

    @Override
    public float floatValue() {
        return this.timeSpan;
    }

    @Override
    public double doubleValue() {
        return this.timeSpan;
    }

    public WorkTimeSpan(Date beginDate, Date endDate, long dayWorkMinutes) {
        this.dayWorkMilliseconds = dayWorkMinutes * 60000L;
        this.fromDatatimeSpan(beginDate, endDate);
    }

    public WorkTimeSpan(Date beginDate, Date endDate) {
        this(beginDate, endDate, 480L);
    }

    public WorkTimeSpan(String sTimeSpan) {
        this.dayWorkMilliseconds = 28800000L;
        this.fromString(sTimeSpan);
    }

    public WorkTimeSpan(String sign, long dayWorkMinutes, long days, long hours, long minutes, long second, long millisecond) {
        this.dayWorkMilliseconds = dayWorkMinutes * 60000L;
        this.timeSpan = days * 86400000L + hours * 3600000L + minutes * 60000L + second * 1000L + millisecond;
        if ("-".equals(sign)) {
            this.timeSpan = 0L - this.timeSpan;
        }
    }

    public WorkTimeSpan(long dayWorkMinutes, long days, long hours, long minutes, long second, long millisecond) {
        this("", dayWorkMinutes, days, hours, minutes, second, millisecond);
    }

    public WorkTimeSpan(String sign, long days, long hours, long minutes, long second, long millisecond) {
        this(sign, 480L, days, hours, minutes, second, millisecond);
    }

    public WorkTimeSpan(String sign, long dayWorkMinutes, long days, long hours, long minutes) {
        this(sign, dayWorkMinutes, days, hours, minutes, 0L, 0L);
    }

    public WorkTimeSpan(long dayWorkMinutes, long days, long hours, long minutes) {
        this("", dayWorkMinutes, days, hours, minutes, 0L, 0L);
    }

    public WorkTimeSpan(String sign, long days, long hours, long minutes) {
        this(sign, 480L, days, hours, minutes, 0L, 0L);
    }

    public WorkTimeSpan(long days, long hours, long minutes) {
        this("", 480L, days, hours, minutes, 0L, 0L);
    }

    public WorkTimeSpan(long dayWorkMinutes) {
        this.dayWorkMilliseconds = dayWorkMinutes * 60000L;
        this.timeSpan = 0L;
    }

    public static WorkTimeSpan calcDatatimeSpan(Date beginDate, Date endDate) {
        WorkTimeSpan wrokTimeSpan = new WorkTimeSpan();
        wrokTimeSpan.setDayWorkMilliseconds(86400000L);
        wrokTimeSpan.setTimeSpan(beginDate.getTime() - endDate.getTime());
        return wrokTimeSpan;
    }

    public static WorkTimeSpan calcWorkTimeSpan(Date beginDate, Date endDate, Long dayWorkMinutes) {
        WorkTimeSpan wrokTimeSpan = new WorkTimeSpan();
        wrokTimeSpan.setDayWorkMilliseconds(dayWorkMinutes * 60000L);
        wrokTimeSpan.setTimeSpan(beginDate.getTime() - endDate.getTime());
        return wrokTimeSpan;
    }

    public static WorkTimeSpan calcWorkTimeSpan(Date beginDate, Date endDate) {
        WorkTimeSpan wrokTimeSpan = new WorkTimeSpan();
        wrokTimeSpan.setDayWorkMilliseconds(28800000L);
        wrokTimeSpan.setTimeSpan(beginDate.getTime() - endDate.getTime());
        return wrokTimeSpan;
    }

    public long getTimeSpan() {
        return this.timeSpan;
    }

    public void setTimeSpan(long timeSpan) {
        this.timeSpan = timeSpan;
    }

    public long getDayWorkMilliseconds() {
        return this.dayWorkMilliseconds;
    }

    public void setDayWorkMilliseconds(long dayWorkMilliseconds) {
        this.dayWorkMilliseconds = dayWorkMilliseconds;
    }

    public long getDayWorkSeconds() {
        return this.dayWorkMilliseconds / 1000L;
    }

    public void setDayWorkSeconds(long dayWorkSeconds) {
        this.dayWorkMilliseconds = dayWorkSeconds * 1000L;
    }

    public long getDayWorkMinutes() {
        return this.dayWorkMilliseconds / 60000L;
    }

    public void setDayWorkMinutes(long dayWorkMinutes) {
        this.dayWorkMilliseconds = dayWorkMinutes * 60000L;
    }

    public long getDayWorkHours() {
        return this.dayWorkMilliseconds / 3600000L;
    }

    public void setDayWorkHours(long dayWorkHours) {
        this.dayWorkMilliseconds = dayWorkHours * 3600000L;
    }

    public WorkTimeSpan fromDatatimeSpan(Date beginDate, Date endDate) {
        this.setTimeSpan(beginDate.getTime() - endDate.getTime());
        return this;
    }

    public void fromString(String sTimeSpan) {
        int sp;
        int sign = 1;
        long nDays = 0L;
        long nHours = 0L;
        long nMinutes = 0L;
        long nSecond = 0L;
        long nMillisecond = 0L;
        if (sTimeSpan == null || "".equals(sTimeSpan)) {
            return;
        }
        char[] sc = sTimeSpan.toCharArray();
        int sl = sTimeSpan.length();
        for (sp = 0; sp < sl && sc[sp] == ' '; ++sp) {
        }
        if (sc[sp] == '-') {
            ++sp;
            sign = -1;
        }
        while (sp < sl) {
            while (sp < sl && !Character.isDigit(sc[sp])) {
                ++sp;
            }
            if (sp >= sl) break;
            int nb = sp;
            while (sp < sl && Character.isDigit(sc[sp])) {
                ++sp;
            }
            String digits = sTimeSpan.substring(nb, sp);
            while (sp < sl && !Character.isLetter(sc[sp]) && !Character.isDigit(sc[sp])) {
                ++sp;
            }
            if (sp >= sl) {
                if (nDays != 0L) break;
                nDays = Long.parseLong(digits);
                break;
            }
            if (Character.isDigit(sc[sp])) continue;
            switch (sc[sp]) {
                case 'D': 
                case 'd': {
                    nDays = Long.parseLong(digits);
                    break;
                }
                case 'H': 
                case 'h': {
                    nHours = Long.parseLong(digits);
                    break;
                }
                case 'M': 
                case 'm': {
                    nMinutes = Long.parseLong(digits);
                    break;
                }
                case 'S': {
                    nSecond = Long.parseLong(digits);
                    break;
                }
                case 's': {
                    nMillisecond = Long.parseLong(digits);
                    break;
                }
            }
        }
        this.timeSpan = (long)sign * (nDays * 86400000L + nHours * 3600000L + nMinutes * 60000L + nSecond * 1000L + nMillisecond);
    }

    public String getTimeSpanDesc() {
        return this.getSignString() + (this.getDays() != 0L ? this.getDays() + "\u5929" : "") + (this.getHours() != 0L ? this.getHours() + "\u5c0f\u65f6" : "") + (this.getMinutes() != 0L ? this.getMinutes() + "\u5206" : "");
    }

    public String getTimeSpanDescAsSecond() {
        return this.getSignString() + (this.getDays() != 0L ? this.getDays() + "\u5929" : "") + (this.getHours() != 0L ? this.getHours() + "\u5c0f\u65f6" : "") + (this.getMinutes() != 0L ? this.getMinutes() + "\u5206" : "") + (this.getSeconds() != 0L ? this.getSeconds() + "\u79d2" : "");
    }

    public String getTimeSpanDescAsMillisecond() {
        return this.getSignString() + (this.getDays() != 0L ? this.getDays() + "\u5929" : "") + (this.getHours() != 0L ? this.getHours() + "\u5c0f\u65f6" : "") + (this.getMinutes() != 0L ? this.getMinutes() + "\u5206" : "") + (this.getSeconds() != 0L ? this.getSeconds() + "\u79d2" : "") + (this.getMilliseconds() != 0L ? this.getMilliseconds() + "\u6beb\u79d2" : "");
    }

    public String toString() {
        return this.toStringAsMinute();
    }

    public String toStringAsMinute() {
        return this.getSignString() + (this.getDays() != 0L ? this.getDays() + "D" : "") + (this.getHours() != 0L ? this.getHours() + "H" : "") + (this.getMinutes() != 0L ? this.getMinutes() + "M" : "");
    }

    public String toStringAsSecond() {
        return this.getSignString() + (this.getDays() != 0L ? this.getDays() + "D" : "") + (this.getHours() != 0L ? this.getHours() + "H" : "") + (this.getMinutes() != 0L ? this.getMinutes() + "M" : "") + (this.getMinutes() != 0L ? this.getMinutes() + "S" : "");
    }

    public String toStringAsMillisecond() {
        return this.getSignString() + (this.getDays() != 0L ? this.getDays() + "D" : "") + (this.getHours() != 0L ? this.getHours() + "H" : "") + (this.getMinutes() != 0L ? this.getMinutes() + "M" : "") + (this.getSeconds() != 0L ? this.getSeconds() + "S" : "") + (this.getMilliseconds() != 0L ? this.getMilliseconds() + "s" : "");
    }

    private long toAbsNumberAsMillisecond() {
        return this.getDays() * this.dayWorkMilliseconds + this.getHours() * 3600000L + this.getMinutes() * 60000L + this.getSeconds() * 1000L + this.getMilliseconds();
    }

    public long toNumberAsMillisecond() {
        return this.getSign() * this.toAbsNumberAsMillisecond();
    }

    public long toNumberAsMinute() {
        return this.getSign() * (this.toAbsNumberAsMillisecond() / 60000L);
    }

    public long toNumberAsSecond() {
        return this.getSign() * (this.toAbsNumberAsMillisecond() / 1000L);
    }

    public void fromNumberAsMinute(long lSpan) {
        this.fromNumberAsMillisecond(lSpan * 60000L);
    }

    public void fromNumberAsHour(long lSpan) {
        this.fromNumberAsMillisecond(lSpan * 3600000L);
    }

    public void fromNumberAsSecond(long lSpan) {
        this.fromNumberAsMillisecond(lSpan * 1000L);
    }

    public void fromNumberAsMillisecond(long lSpan) {
        long nSign;
        long tempSpan;
        if (lSpan > 0L) {
            tempSpan = lSpan;
            nSign = 1L;
        } else {
            tempSpan = 0L - lSpan;
            nSign = -1L;
        }
        long nDays = tempSpan / this.dayWorkMilliseconds;
        long nRemainder = tempSpan % this.dayWorkMilliseconds;
        this.timeSpan = nSign * (nDays * 86400000L + nRemainder);
    }

    public long getSign() {
        return this.timeSpan > 0L ? 1L : -1L;
    }

    public String getSignString() {
        return this.timeSpan > 0L ? "" : "-";
    }

    public WorkTimeSpan changeSign() {
        this.timeSpan = 0L - this.timeSpan;
        return this;
    }

    public WorkTimeSpan addDays(long ndays) {
        this.fromNumberAsMillisecond(this.toNumberAsMillisecond() + ndays * this.dayWorkMilliseconds);
        return this;
    }

    public WorkTimeSpan addHours(long nHours) {
        this.fromNumberAsMillisecond(this.toNumberAsMillisecond() + nHours * 3600000L);
        return this;
    }

    public WorkTimeSpan addMinutes(long nMinutes) {
        this.fromNumberAsMillisecond(this.toNumberAsMillisecond() + nMinutes * 60000L);
        return this;
    }

    public WorkTimeSpan addSeconds(long nSeconds) {
        this.fromNumberAsMillisecond(this.toNumberAsMillisecond() + nSeconds * 1000L);
        return this;
    }

    public WorkTimeSpan addMilliseconds(long nMilliseconds) {
        this.fromNumberAsMillisecond(this.toNumberAsMillisecond() + nMilliseconds);
        return this;
    }

    public long getDays() {
        return this.timeSpan > 0L ? this.timeSpan / 86400000L : (0L - this.timeSpan) / 86400000L;
    }

    private long getRemainderMilliseconds() {
        return this.timeSpan > 0L ? this.timeSpan % 86400000L : (0L - this.timeSpan) % 86400000L;
    }

    public long getHours() {
        return this.getRemainderMilliseconds() / 3600000L;
    }

    public long getMinutes() {
        return this.getRemainderMilliseconds() % 3600000L / 60000L;
    }

    public long getSeconds() {
        return this.getRemainderMilliseconds() % 60000L / 1000L;
    }

    public long getMilliseconds() {
        return this.getRemainderMilliseconds() % 1000L;
    }
}

