/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.extend;

import com.alibaba.fastjson2.JSONArray;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSRuntimeContext {
    protected static final Logger logger = LoggerFactory.getLogger(JSRuntimeContext.class);
    private ScriptEngine scriptEngine;

    public JSRuntimeContext() {
        ScriptEngineManager sem = new ScriptEngineManager();
        this.scriptEngine = sem.getEngineByName("js");
    }

    public JSRuntimeContext compileScript(String js) {
        try {
            this.scriptEngine.eval(js);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return this;
    }

    public JSRuntimeContext compileScriptFile(String jsFileName) {
        try {
            FileReader reader = new FileReader(new File(jsFileName));
            this.scriptEngine.eval(reader);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return this;
    }

    public JSRuntimeContext compileScriptStream(InputStream is) {
        try {
            InputStreamReader reader = new InputStreamReader(is);
            this.scriptEngine.eval(reader);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return this;
    }

    public static Object checkArrayObject(Object object) {
        if (object instanceof Map) {
            Map objMap = (Map)object;
            JSONArray objArray = new JSONArray();
            boolean isArray = true;
            for (Map.Entry ent : objMap.entrySet()) {
                if (StringUtils.isNumeric((CharSequence)ent.getKey().toString())) {
                    objArray.add(ent.getValue());
                    continue;
                }
                isArray = false;
                break;
            }
            if (isArray && objArray.size() > 0) {
                return objArray;
            }
        }
        return object;
    }

    public Object callJsFunc(String funcName, Object ... args) throws ScriptException, NoSuchMethodException {
        Invocable invocable = (Invocable)((Object)this.scriptEngine);
        return JSRuntimeContext.checkArrayObject(invocable.invokeFunction(funcName, args));
    }

    public Object getJsObject(String objName) {
        return this.scriptEngine.get(objName);
    }

    public Object getJsObjectProperty(String objName, String propertyName) throws ScriptException {
        return JSRuntimeContext.checkArrayObject(this.scriptEngine.eval(objName + "." + propertyName));
    }

    public Object callJsObjectMethod(Object jsObject, String methodName, Object ... args) throws ScriptException, NoSuchMethodException {
        Invocable invocable = (Invocable)((Object)this.scriptEngine);
        return JSRuntimeContext.checkArrayObject(invocable.invokeMethod(jsObject, methodName, args));
    }
}

