/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.json;

import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.compiler.VariableTranslate;
import com.centit.support.json.JSONTransformDataSupport;
import java.util.ArrayList;
import java.util.List;

public class DefaultJSONTransformDataSupport
implements VariableTranslate,
JSONTransformDataSupport {
    private Object data;
    private int stackLength;
    private List<Object> stack;

    public DefaultJSONTransformDataSupport(Object obj) {
        this.data = obj;
        this.stackLength = 0;
        this.stack = new ArrayList<Object>(10);
    }

    @Override
    public Object attainExpressionValue(String expression) {
        if (expression == null) {
            return null;
        }
        VariableFormula variableFormula = new VariableFormula();
        variableFormula.setTrans(this);
        variableFormula.setFormula(expression);
        return variableFormula.calcFormula();
    }

    @Override
    public Object getVarValue(String labelName) {
        if (labelName.startsWith("/")) {
            return ReflectionOpt.attainExpressionValue(this.data, labelName.substring(1));
        }
        if (labelName.startsWith("..")) {
            return ReflectionOpt.attainExpressionValue(this.peekStackValue(1), labelName.substring(2));
        }
        if (labelName.startsWith(".")) {
            return ReflectionOpt.attainExpressionValue(this.currentValue(), labelName.substring(1));
        }
        return ReflectionOpt.attainExpressionValue(this.currentValue(), labelName);
    }

    @Override
    public String mapTemplateString(String templateString) {
        return templateString;
    }

    private Object currentValue() {
        return this.stackLength > 0 ? this.stack.get(this.stackLength - 1) : this.data;
    }

    private Object peekStackValue() {
        return this.stackLength > 0 ? this.stack.get(this.stackLength - 1) : null;
    }

    private Object peekStackValue(int n) {
        return this.stackLength > n ? this.stack.get(this.stackLength - n - 1) : null;
    }

    @Override
    public void pushStackValue(Object value) {
        if (this.stack.size() > this.stackLength) {
            this.stack.set(this.stackLength, value);
        } else {
            this.stack.add(value);
        }
        ++this.stackLength;
    }

    @Override
    public Object popStackValue() {
        Object obj;
        Object object = obj = this.stackLength > 0 ? this.stack.get(this.stackLength - 1) : null;
        if (this.stackLength > 0) {
            --this.stackLength;
        }
        return obj;
    }
}

