/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.network;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;

public class HttpExecutorContext {
    private CloseableHttpClient httpclient = null;
    private HttpContext httpContext = null;
    private Map<String, String> httpHeaders = null;
    private Map<String, String> httpCookies = null;
    private HttpHost httpProxy = null;
    private int timeout = -1;

    public static HttpExecutorContext create() {
        return new HttpExecutorContext();
    }

    public static HttpExecutorContext empty() {
        return new HttpExecutorContext();
    }

    public static HttpExecutorContext create(CloseableHttpClient httpclient) {
        HttpExecutorContext executorContext = new HttpExecutorContext();
        executorContext.httpclient = httpclient;
        return executorContext;
    }

    public HttpExecutorContext client(CloseableHttpClient httpclient) {
        this.httpclient = httpclient;
        return this;
    }

    public HttpExecutorContext context(HttpContext httpContext) {
        this.httpContext = httpContext;
        return this;
    }

    public HttpExecutorContext proxy(HttpHost httpProxy) {
        this.httpProxy = httpProxy;
        return this;
    }

    public HttpExecutorContext headers(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    public HttpExecutorContext header(String name, String value) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new HashMap<String, String>(6);
        }
        this.httpHeaders.put(name, value);
        return this;
    }

    public HttpExecutorContext cookies(Map<String, String> httpCookies) {
        this.httpCookies = httpCookies;
        return this;
    }

    public HttpExecutorContext cookie(String name, String value) {
        if (this.httpCookies == null) {
            this.httpCookies = new HashMap<String, String>(6);
        }
        this.httpCookies.put(name, value);
        return this;
    }

    public HttpExecutorContext timout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public CloseableHttpClient getHttpclient() {
        return this.httpclient;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public Map<String, String> getHttpCookies() {
        return this.httpCookies;
    }

    public HttpHost getHttpProxy() {
        return this.httpProxy;
    }
}

