/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.security;

import com.centit.support.security.AESSecurityUtils;
import com.centit.support.security.SM4Util;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecurityOptUtils {
    protected static final Logger logger = LoggerFactory.getLogger(SecurityOptUtils.class);

    public static Pair<String, String> makeCbcKey(String password, String algorithm) {
        if (StringUtils.isBlank((CharSequence)password)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"SM4", (CharSequence)algorithm)) {
                return new MutablePair((Object)"qbh07dTZ$sO7_wC1", (Object)"slEAYAe2@dh3otTO");
            }
            return new ImmutablePair((Object)"U2FsdGVkX1BymlPj", (Object)"WUG1TpTpkinX9pNs");
        }
        for (int strLen = password.length(); strLen < 32; strLen *= 2) {
            password = password + password;
        }
        return new ImmutablePair((Object)password.substring(0, 16), (Object)password.substring(16, 32));
    }

    public static String decodeSecurityString(String sStr) {
        if (StringUtils.isBlank((CharSequence)sStr)) {
            return "";
        }
        if ((sStr = sStr.trim()).startsWith("encode:")) {
            return new String(Base64.decodeBase64((String)sStr.substring(7))).trim();
        }
        if (sStr.startsWith("cipher:")) {
            return AESSecurityUtils.decryptBase64String(sStr.substring(7), "0123456789abcdefghijklmnopqrstuvwxyzABCDEF");
        }
        if (sStr.startsWith("aescbc:")) {
            return AESSecurityUtils.decryptAsCBCType(sStr.substring(7), "U2FsdGVkX1BymlPj", "WUG1TpTpkinX9pNs");
        }
        if (sStr.startsWith("sm4cbc:")) {
            return SM4Util.decryptAsCBCType(sStr.substring(7), "qbh07dTZ$sO7_wC1", "slEAYAe2@dh3otTO");
        }
        return sStr;
    }

    public static String encodeSecurityString(String sStr, String encType) {
        if (sStr == null) {
            return "";
        }
        switch (encType) {
            case "cipher": {
                return "cipher:" + AESSecurityUtils.encryptAndBase64(sStr, "0123456789abcdefghijklmnopqrstuvwxyzABCDEF");
            }
            case "base64": {
                return "encode:" + Base64.encodeBase64String((byte[])sStr.getBytes(StandardCharsets.UTF_8));
            }
            case "aescbc": {
                return "aescbc:" + AESSecurityUtils.encryptAsCBCType(sStr, "U2FsdGVkX1BymlPj", "WUG1TpTpkinX9pNs");
            }
            case "sm4cbc": {
                return "sm4cbc:" + SM4Util.encryptAsCBCType(sStr, "qbh07dTZ$sO7_wC1", "slEAYAe2@dh3otTO");
            }
        }
        return sStr;
    }
}

