/*
 * Decompiled with CFR 0.152.
 */
package com.centit.upload.controller;

import com.centit.core.controller.BaseController;
import com.centit.upload.po.FileAccessLog;
import com.centit.upload.po.FileStroeInfo;
import com.centit.upload.service.FileAccessLogManager;
import com.centit.upload.service.FileStoreInfoManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/download"})
public class DownLoadController
extends BaseController {
    @Resource
    private FileStoreInfoManager fileStoreInfoManager;
    @Resource
    private FileAccessLogManager fileAccessLogManager;

    @RequestMapping(value={"/{fileId}"})
    public ResponseEntity<byte[]> download(@PathVariable(value="fileId") String fileId, HttpServletResponse response, HttpServletRequest request) throws IOException {
        FileStroeInfo stroeInfo = (FileStroeInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileId));
        if (stroeInfo != null) {
            String path = stroeInfo.getFileStorePath();
            File f = new File(path);
            f.getName();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentDispositionFormData("attachment", new String(stroeInfo.getFileName().getBytes("UTF-8"), "iso-8859-1"));
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            return new ResponseEntity((Object)FileUtils.readFileToByteArray((File)f), (MultiValueMap)headers, HttpStatus.CREATED);
        }
        return null;
    }

    @RequestMapping(value={"/downloadByAccess/{accessId}/{fileId}"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> downloadByAccess(@PathVariable(value="accessId") String accessId, @PathVariable(value="fileId") String fileId, HttpServletResponse response, HttpServletRequest request) throws IOException {
        Map properties = DownLoadController.convertSearchColumn((HttpServletRequest)request);
        properties.put("accessId", accessId);
        properties.put("fileId", fileId);
        FileAccessLog fileAccessLog = (FileAccessLog)this.fileAccessLogManager.getObjectByProperties(properties);
        if (fileAccessLog != null) {
            FileStroeInfo stroeInfo = (FileStroeInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileAccessLog.getFileId()));
            if (stroeInfo != null) {
                String path = stroeInfo.getFileStorePath();
                File f = new File(path);
                HttpHeaders headers = new HttpHeaders();
                headers.setContentDispositionFormData("attachment", new String(stroeInfo.getFileName().getBytes("UTF-8"), "iso-8859-1"));
                headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
                return new ResponseEntity((Object)FileUtils.readFileToByteArray((File)f), (MultiValueMap)headers, HttpStatus.CREATED);
            }
            return null;
        }
        return null;
    }
}

