/*
 * Decompiled with CFR 0.152.
 */
package com.centit.upload.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.core.controller.BaseController;
import com.centit.upload.po.FileAccessLog;
import com.centit.upload.po.FileStroeInfo;
import com.centit.upload.service.FileAccessLogManager;
import com.centit.upload.service.FileStoreInfoManager;
import com.centit.upload.util.IoUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/fileAccess"})
public class FileAccessLogController
extends BaseController {
    @Resource
    private FileAccessLogManager fileAccessLogManager;
    @Resource
    private FileStoreInfoManager fileStoreInfoManager;

    @RequestMapping(method={RequestMethod.POST})
    public void accessFile(@RequestBody JSONArray array, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList<FileAccessLog> fileAccessLogList = new ArrayList<FileAccessLog>();
        ListIterator it = array.listIterator();
        while (it.hasNext()) {
            LinkedHashMap linkMap = (LinkedHashMap)it.next();
            FileAccessLog fileAccessLog = new FileAccessLog();
            String download_type = (String)linkMap.get("ORIGINAL");
            if ("0".equals(download_type)) {
                fileAccessLog.setFileId((String)linkMap.get("fileId"));
            } else if ("1".equals(download_type)) {
                HashMap properties = new HashMap();
                properties.put("relatedFileId", linkMap.get("fileId"));
                FileStroeInfo storeFile = (FileStroeInfo)this.fileStoreInfoManager.getObjectByProperties(properties);
                if (storeFile == null) continue;
                fileAccessLog.setFileId(storeFile.getFileId());
            }
            fileAccessLog.setAccessUsercode((String)linkMap.get("accessUsercode"));
            fileAccessLog.setAccessUsename((String)linkMap.get("accessUsename"));
            fileAccessLog.setAccessRight((String)linkMap.get("accessRight"));
            fileAccessLog.setLastAccessHost((String)linkMap.get("lastAccessHost"));
            fileAccessLog.setTokenExpireTime(new Date());
            fileAccessLog.setAccessTimes(1);
            fileAccessLog.setAccessToken("11");
            fileAccessLogList.add(fileAccessLog);
        }
        JSONArray jsonArray = new JSONArray();
        List<String> ids = this.fileAccessLogManager.saveAll(fileAccessLogList);
        for (String id : ids) {
            JSONObject object = new JSONObject();
            FileAccessLog fileAccessLog = (FileAccessLog)this.fileAccessLogManager.getObjectById((Serializable)((Object)id));
            if (fileAccessLog != null) {
                object.put("success", (Object)"true");
                object.put("accessId", (Object)fileAccessLog.getAccessId());
                object.put("fileId", (Object)fileAccessLog.getFileId());
            }
            jsonArray.add((Object)object);
        }
        response.getWriter().write(jsonArray.toString());
        IoUtil.close(response.getWriter());
    }
}

