/*
 * Decompiled with CFR 0.152.
 */
package com.centit.upload.service;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.file.FileMD5Maker;
import com.centit.support.file.FileType;
import com.centit.upload.exception.StreamException;
import com.centit.upload.po.FileStroeInfo;
import com.centit.upload.po.Range;
import com.centit.upload.util.Configurations;
import com.centit.upload.util.IoUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StreamServlet
extends HttpServlet {
    private static final long serialVersionUID = -8619685235661387895L;
    static final int BUFFER_LENGTH = 10240;
    static final String START_FIELD = "start";
    public static final String CONTENT_RANGE_HEADER = "content-range";

    public void init() throws ServletException {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doOptions(request, response);
        String token = request.getParameter("token");
        String size = request.getParameter("size");
        String fileName = request.getParameter("name");
        JSONObject json = new JSONObject();
        long start = 0L;
        boolean success = true;
        String message = "";
        Calendar today = Calendar.getInstance();
        String pathname = String.valueOf(Configurations.getFileRepository()) + File.separatorChar + today.get(1) + File.separator + (today.get(2) + 1) + File.separator + today.get(5) + File.pathSeparator;
        try {
            try {
                File f = IoUtil.getTokenedFile(token);
                start = f.length();
                if (token.endsWith("_0") && "0".equals(size) && 0L == start) {
                    f.renameTo(IoUtil.getFile(fileName, pathname));
                }
            }
            catch (FileNotFoundException fne) {
                message = "Error: " + fne.getMessage();
                success = false;
                try {
                    if (success) {
                        json.put(START_FIELD, (Object)start);
                    }
                    json.put("success", (Object)success);
                    json.put("message", (Object)message);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                response.getWriter().write(json.toString());
            }
        }
        finally {
            try {
                if (success) {
                    json.put(START_FIELD, (Object)start);
                }
                json.put("success", (Object)success);
                json.put("message", (Object)message);
            }
            catch (JSONException jSONException) {}
            response.getWriter().write(json.toString());
        }
    }

    /*
     * Loose catch block
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block37: {
            this.doOptions(request, response);
            String token = request.getParameter("token");
            String name = new String(request.getParameter("name").getBytes("ISO8859-1"), "utf-8");
            Range range = IoUtil.parseRange(request);
            FileOutputStream out = null;
            ServletInputStream content = null;
            JSONObject json = new JSONObject();
            long start = 0L;
            boolean success = true;
            String message = "";
            File f = IoUtil.getTokenedFile(token);
            try {
                if (f.length() != range.getFrom()) {
                    throw new StreamException(StreamException.ERROR_FILE_RANGE_START);
                }
                out = new FileOutputStream(f, true);
                content = request.getInputStream();
                int read = 0;
                byte[] bytes = new byte[10240];
                while ((read = content.read(bytes)) != -1) {
                    ((OutputStream)out).write(bytes, 0, read);
                }
                start = f.length();
            }
            catch (StreamException se) {
                success = StreamException.ERROR_FILE_RANGE_START == se.getCode();
                message = "Code: " + se.getCode();
                IoUtil.close(out);
                IoUtil.close((Closeable)content);
                if (range.getSize() != start) break block37;
                try {
                    Calendar today = Calendar.getInstance();
                    String pathname = String.valueOf(Configurations.getFileRepository()) + File.separatorChar + today.get(1) + File.separator + (today.get(2) + 1) + File.separator + today.get(5) + File.separator;
                    File dst = IoUtil.getFile(name, pathname);
                    dst.delete();
                    f.renameTo(dst);
                    FileStroeInfo info = new FileStroeInfo();
                    info.setFileMd5(FileMD5Maker.makeFileMD5((File)dst));
                    info.setFileName(name);
                    info.setFileType(FileType.getFileType((File)dst));
                    info.setFileStorePath(dst.getPath());
                    info.setCreateTime(new Date());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    if (success) {
                        json.put(START_FIELD, (Object)start);
                    }
                    json.put("success", (Object)success);
                    json.put("message", (Object)message);
                }
                catch (JSONException e) {
                    // empty catch block
                }
                response.getWriter().write(json.toString());
                IoUtil.close(response.getWriter());
                break block37;
            }
            catch (FileNotFoundException fne) {
                message = "Code: " + StreamException.ERROR_FILE_NOT_EXIST;
                success = false;
                IoUtil.close(out);
                IoUtil.close((Closeable)content);
                if (range.getSize() != start) break block37;
                try {
                    Calendar today = Calendar.getInstance();
                    String pathname = String.valueOf(Configurations.getFileRepository()) + File.separatorChar + today.get(1) + File.separator + (today.get(2) + 1) + File.separator + today.get(5) + File.separator;
                    File dst = IoUtil.getFile(name, pathname);
                    dst.delete();
                    f.renameTo(dst);
                    FileStroeInfo info = new FileStroeInfo();
                    info.setFileMd5(FileMD5Maker.makeFileMD5((File)dst));
                    info.setFileName(name);
                    info.setFileType(FileType.getFileType((File)dst));
                    info.setFileStorePath(dst.getPath());
                    info.setCreateTime(new Date());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    if (success) {
                        json.put(START_FIELD, (Object)start);
                    }
                    json.put("success", (Object)success);
                    json.put("message", (Object)message);
                }
                catch (JSONException e) {
                    // empty catch block
                }
                response.getWriter().write(json.toString());
                IoUtil.close(response.getWriter());
                break block37;
            }
            catch (IOException io) {
                message = "IO Error: " + io.getMessage();
                success = false;
                {
                    catch (Throwable throwable) {
                        IoUtil.close(out);
                        IoUtil.close(content);
                        if (range.getSize() == start) {
                            try {
                                Calendar today = Calendar.getInstance();
                                String pathname = String.valueOf(Configurations.getFileRepository()) + File.separatorChar + today.get(1) + File.separator + (today.get(2) + 1) + File.separator + today.get(5) + File.separator;
                                File dst = IoUtil.getFile(name, pathname);
                                dst.delete();
                                f.renameTo(dst);
                                FileStroeInfo info = new FileStroeInfo();
                                info.setFileMd5(FileMD5Maker.makeFileMD5((File)dst));
                                info.setFileName(name);
                                info.setFileType(FileType.getFileType((File)dst));
                                info.setFileStorePath(dst.getPath());
                                info.setCreateTime(new Date());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            try {
                                if (success) {
                                    json.put(START_FIELD, (Object)start);
                                }
                                json.put("success", (Object)success);
                                json.put("message", (Object)message);
                            }
                            catch (JSONException e) {
                                // empty catch block
                            }
                            response.getWriter().write(json.toString());
                            IoUtil.close(response.getWriter());
                        }
                        throw throwable;
                    }
                }
                IoUtil.close(out);
                IoUtil.close((Closeable)content);
                if (range.getSize() != start) break block37;
                try {
                    Calendar today = Calendar.getInstance();
                    String pathname = String.valueOf(Configurations.getFileRepository()) + File.separatorChar + today.get(1) + File.separator + (today.get(2) + 1) + File.separator + today.get(5) + File.separator;
                    File dst = IoUtil.getFile(name, pathname);
                    dst.delete();
                    f.renameTo(dst);
                    FileStroeInfo info = new FileStroeInfo();
                    info.setFileMd5(FileMD5Maker.makeFileMD5((File)dst));
                    info.setFileName(name);
                    info.setFileType(FileType.getFileType((File)dst));
                    info.setFileStorePath(dst.getPath());
                    info.setCreateTime(new Date());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    if (success) {
                        json.put(START_FIELD, (Object)start);
                    }
                    json.put("success", (Object)success);
                    json.put("message", (Object)message);
                }
                catch (JSONException e) {
                    // empty catch block
                }
                response.getWriter().write(json.toString());
                IoUtil.close(response.getWriter());
                break block37;
            }
            IoUtil.close(out);
            IoUtil.close((Closeable)content);
            if (range.getSize() == start) {
                try {
                    Calendar today = Calendar.getInstance();
                    String pathname = String.valueOf(Configurations.getFileRepository()) + File.separatorChar + today.get(1) + File.separator + (today.get(2) + 1) + File.separator + today.get(5) + File.separator;
                    File dst = IoUtil.getFile(name, pathname);
                    dst.delete();
                    f.renameTo(dst);
                    FileStroeInfo info = new FileStroeInfo();
                    info.setFileMd5(FileMD5Maker.makeFileMD5((File)dst));
                    info.setFileName(name);
                    info.setFileType(FileType.getFileType((File)dst));
                    info.setFileStorePath(dst.getPath());
                    info.setCreateTime(new Date());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    if (success) {
                        json.put(START_FIELD, (Object)start);
                    }
                    json.put("success", (Object)success);
                    json.put("message", (Object)message);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                response.getWriter().write(json.toString());
                IoUtil.close(response.getWriter());
            }
        }
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json");
        resp.setHeader("Access-Control-Allow-Headers", "Content-Range,Content-Type");
        resp.setHeader("Access-Control-Allow-Origin", "http://localhost:8089");
        resp.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS");
    }

    public void destroy() {
        super.destroy();
    }
}

