/*
 * Decompiled with CFR 0.152.
 */
package com.centit.upload.service.impl;

import com.centit.core.service.BaseEntityManagerImpl;
import com.centit.upload.dao.FileStoreInfoDao;
import com.centit.upload.po.FileStroeInfo;
import com.centit.upload.service.FileStoreInfoManager;
import com.centit.upload.util.Configurations;
import com.centit.upload.util.IoUtil;
import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FileStoreInfoManagerImpl
extends BaseEntityManagerImpl<FileStroeInfo, String, FileStoreInfoDao>
implements FileStoreInfoManager {
    @Resource(name="fileStoreInfoDao")
    @NotNull
    protected void setBaseDao(FileStoreInfoDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public void saveFile(FileStroeInfo originalFile, FileStroeInfo relatedFile) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("fileMd5", originalFile.getFileMd5());
        FileStroeInfo storeInfo = (FileStroeInfo)this.getObjectByProperties(properties);
        if (storeInfo == null) {
            ((FileStoreInfoDao)this.baseDao).saveObject(originalFile);
            if (relatedFile != null) {
                ((FileStoreInfoDao)this.baseDao).saveObject(relatedFile);
            }
        }
    }

    @Override
    public void deleteFile(FileStroeInfo originalFile, FileStroeInfo relatedFile) throws Exception {
        originalFile.setIsValid("F");
        ((FileStoreInfoDao)this.baseDao).saveObject(originalFile);
        if (relatedFile != null) {
            relatedFile.setIsValid("F");
            ((FileStoreInfoDao)this.baseDao).saveObject(relatedFile);
        }
    }

    @Override
    public void saveSynFile(FileStroeInfo file, String filePath) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("fileMd5", file.getFileMd5());
        FileStroeInfo storeInfo = (FileStroeInfo)this.getObjectByProperties(properties);
        if (storeInfo != null) {
            Calendar today = Calendar.getInstance();
            String pathname = String.valueOf(Configurations.getFileRepository()) + File.separatorChar + today.get(1) + File.separator + (today.get(2) + 1) + File.separator + today.get(5) + File.separator;
            File dst = IoUtil.getFile(file.getFileMd5(), pathname);
            dst.delete();
            new File(filePath).renameTo(dst);
            ((FileStoreInfoDao)this.baseDao).saveObject(storeInfo);
        }
    }
}

