/*
 * Decompiled with CFR 0.152.
 */
package com.centit.upload.util;

import com.centit.upload.po.Range;
import com.centit.upload.util.Configurations;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class IoUtil {
    static final Pattern RANGE_PATTERN = Pattern.compile("bytes \\d+-\\d+/\\d+");

    public static File getFile(String filename, String pathname) throws IOException {
        if (filename == null || filename.isEmpty()) {
            return null;
        }
        String name = filename.replaceAll("/", Matcher.quoteReplacement(File.separator));
        File f = new File(String.valueOf(pathname) + name);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        if (!f.exists()) {
            f.createNewFile();
        }
        return f;
    }

    public static boolean isOfficeFile(String inputFile) {
        String suffix = inputFile.substring(inputFile.lastIndexOf(".") + 1).toLowerCase();
        if (suffix.equals("doc") || suffix.equals("docx")) {
            return true;
        }
        if (suffix.equals("ppt") || suffix.equals("pptx")) {
            return true;
        }
        return suffix.equals("xls") || suffix.equals("xlsx");
    }

    public static String getFileType(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return "";
        }
        int lastIndex = fileName.lastIndexOf(".");
        return fileName.substring(lastIndex + 1, fileName.length());
    }

    public static File getTokenedFile(String key) throws FileNotFoundException {
        if (key == null || key.isEmpty()) {
            return null;
        }
        File f = new File(String.valueOf(Configurations.getFileRepository()) + File.separator + key);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        if (!f.exists()) {
            throw new FileNotFoundException("File `" + f + "` not exist.");
        }
        return f;
    }

    public static void storeToken(String key) throws IOException {
        if (key == null || key.isEmpty()) {
            return;
        }
        File f = new File(String.valueOf(Configurations.getFileRepository()) + File.separator + key);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        if (!f.exists()) {
            f.createNewFile();
        }
    }

    public static void close(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Range parseRange(HttpServletRequest req) throws IOException {
        String range = req.getHeader("content-range");
        Matcher m = RANGE_PATTERN.matcher(range);
        if (m.find()) {
            range = m.group().replace("bytes ", "");
            String[] rangeSize = range.split("/");
            String[] fromTo = rangeSize[0].split("-");
            long from = Long.parseLong(fromTo[0]);
            long to = Long.parseLong(fromTo[1]);
            long size = Long.parseLong(rangeSize[1]);
            return new Range(from, to, size);
        }
        throw new IOException("Illegal Access!");
    }

    public static long streaming(InputStream in, String key, File dst) throws IOException {
        FileOutputStream out = null;
        File f = IoUtil.getTokenedFile(key);
        try {
            out = new FileOutputStream(f);
            int read = 0;
            byte[] bytes = new byte[0xA00000];
            while ((read = in.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
            out.flush();
        }
        catch (Throwable throwable) {
            IoUtil.close(out);
            throw throwable;
        }
        IoUtil.close(out);
        dst.delete();
        f.renameTo(dst);
        long length = dst.length();
        if (Configurations.isDeleteFinished()) {
            dst.delete();
        }
        return length;
    }

    public static String uuid32len() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}

