<%@ page contentType="text/html;charset=UTF-8"%>
<%@ taglib uri="http://www.springframework.org/security/tags" prefix="authz"%>
<html>
<head>
<title>附件上传页面</title>
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">

<link href="${pageContext.request.contextPath}/styles/uploader.css" rel="stylesheet" type="text/css">
</head>
<body>
	<div id="i_select_files">
	</div>

	<div id="i_stream_files_queue">
	</div>
	
	<div id="i_stream_message_container" class="stream-main-upload-box" style="overflow: auto;height:200px;display:none;">
	</div>
<br>

<script type="text/javascript" src="${pageContext.request.contextPath}/js/jquery-1.11.1.min.js"></script>
<script type="text/javascript" src="${pageContext.request.contextPath}/js/jquery.jsonp-2.4.0.min.js"></script>
<script type="text/javascript" src="${pageContext.request.contextPath}/js/uploader.js"></script>
<script type="text/javascript">
	var uploader_url='${pageContext.request.contextPath}';
	var suburl = requestParam("groupID");
	//var groupID = request("groupID");
	var groupID = '4028049d511e8efb01511e91feb00001';
	
	//禁止刷新，回退 
	function onKeyDown() {
		if ((event.altKey)
				|| ((event.keyCode == 8) && (event.srcElement.type != "text"
						&& event.srcElement.type != "textarea" && event.srcElement.type != "password"))
				|| ((event.ctrlKey) && ((event.keyCode == 78) || (event.keyCode == 82)))
				|| (event.keyCode == 116)) {
			event.keyCode = 0;
			event.returnValue = false;
		}
	}
	document.onkeydown = onKeyDown;

	function stop() { //这个是禁用鼠标右键 
		return false;
	}
	document.oncontextmenu = stop;
	window.onbeforeunload = function() { 

	};
	
	/**
	 * 配置文件（如果没有默认字样，说明默认值就是注释下的值）
	 * 但是，on*（onSelect， onMaxSizeExceed...）等函数的默认行为
	 * 是在ID为i_stream_message_container的页面元素中写日志
	 */
	var default_exts = [".txt", ".doc", ".docx", ".xls", ".xlsx", ".jpg", ".jpeg", ".bmp", ".png", ".gif", ".avi", ".mkv", ".mp4", ".mp3",".pdf"];
	var config = {
		browseFileId : "i_select_files",
		/** 选择文件的ID, 默认: i_select_files */
		browseFileBtn : "<button class='browse-file'>点击选择文件</button>",
		/** 显示选择文件的样式, 默认: `<div>请选择文件</div>` */
		//dragAndDropArea : "i_select_files",
		/** 拖拽上传区域，Id（字符类型"i_select_files"）或者DOM对象, 默认: `i_select_files` */
		//dragAndDropTips : "",
		/** 拖拽提示, 默认: `<span>把文件(文件夹)拖拽到这里</span>` */
		filesQueueId : "i_stream_files_queue",
		/** 文件上传容器的ID, 默认: i_stream_files_queue */
		filesQueueHeight : 500,
		/** 文件上传容器的高度（px）, 默认: 450 */
		//messagerId : "i_stream_message_container",
		/** 消息显示容器的ID, 默认: i_stream_message_container */
		multipleFiles :true,
		/** 多个文件一起上传, 默认: false */
		//autoUploading: false, /** 选择文件后是否自动上传, 默认: true */
		//autoRemoveCompleted : false, /** 是否自动删除容器中已上传完毕的文件, 默认: false */
		maxSize: 1024*1024*1024*2, /** 单个文件的最大大小，默认:2G */
		//retryCount : 5, /** HTML5上传失败的重试次数 */
		//postVarsPerFile : { /** 上传文件时传入的参数，默认: {} */
		//	param1: "val1",
		//	param2: "val2"
		//},
		//swfURL : "${pageContext.request.contextPath}/swf/FlashUploader.swf", /** SWF文件的位置 */
		
		tokenURL : "./service/upload/tk", /** 根据文件名、大小等信息获取Token的URI（用于生成断点续传、跨域的令牌） */
		frmUploadURL : "./service/formdata?" + suburl, /** Flash上传的URI */
		uploadURL : "./service/stream/upload?" + suburl, /** HTML5上传的URI */
		simLimit: 200, /** 单次最大上传文件个数 */
		extFilters: [".txt", ".doc", ".docx", ".xls", ".xlsx", ".jpg", ".jpeg", ".bmp", ".png", ".gif", ".avi", ".mkv", ".mp4", ".mp3",".pdf",".exe"], /** 允许的文件扩展名, 默认: [] */
		onSelect: function(list) {alert("./service/formdata?" + suburl);}, /** 选择文件后的响应事件 */
		//onMaxSizeExceed: function(size, limited, name) {alert('onMaxSizeExceed');}, /** 文件大小超出的响应事件 */
		//onFileCountExceed: function(selected, limit) {alert('onFileCountExceed');}, /** 文件数量超出的响应事件 */
		onExtNameMismatch: function(info) {alert(info.name+'不是允许的文件类型，只允许上传[' + info.filters.toString()+']格式的文件');}, /** 文件的扩展名不匹配的响应事件 */
		//onCancel : function(file) {alert('Canceled:  ' + file.name);}, /** 取消上传文件的响应事件 */
		onComplete : function(file) {onComplete(file); }, /** 单个文件上传完毕的响应事件 */
		onQueueComplete: function() {loadFiles();}, /** 所以文件上传完毕的响应事件 */
		onUploadError: function(status, msg) {alert('onUploadError');} /** 文件上传出错的响应事件 */
		//groupID : window.opener.g_groupID
	};

	var parent=window.opener;
	
	function onComplete(file) {
		alert(JSON.stringify(file));
	}
	
	function loadFiles(){
		selfLoadFiles(groupID);
	}
	
	// 删除选中的文件
	function deleteFile(id,name) {
		if(window.confirm("是否确定删除文件"+name+"？")){
			$.jsonp({
				type:'get',
				callback:"jsonpCallback",
				dataType: 'jsonp',
				url:'./service/fileList/delete/'+id,
				success: function(data){
					if(data.success){
						$("#file_li_"+id).remove();
					}
				}		
			}); 
		}
	}

	var _t = new Stream(config);
	
	function requestParam(paras){
        var url = location.href; 
	    var suburl = url.substring(url.indexOf("?")+1,url.length); 
        return suburl;
	}
	
	function request(paras){
        var url = location.href;
        var paraString = url.substring(url.indexOf("?")+1,url.length).split("&"); 
        var paraObj = {}
        for (i=0; j=paraString[i]; i++){ 
            paraObj[j.substring(0,j.indexOf("=")).toLowerCase()] = j.substring(j.indexOf("=")+1,j.length); 
        } 

        var returnValue = paraObj[paras.toLowerCase()]; 
        if(typeof(returnValue)=="undefined"){ 
            return ""; 
        }else{ 
            return returnValue; 
        }
	}
	
	// 加载所有的文件,并添加下载和删除的功能
	function selfLoadFiles(groupID) {
		$("ul").html('');
		$.jsonp({
			url: './service/fileList/' + groupID,
		  	callback:"jsonpCallback",
		  	dataType: "jsonp",
		  	success: function(json) {
				var data=json.data;
				for(var i=0; i<data.length; i++){
					var fileID = data[i].fileId;
					var fileUrl = "./service/download/" + fileID;
					var fileLi = "<li id='file_li_"+fileID+"' class='stream-cell-file'>"
								+ "<div class='stream-file-name'>"
								+ "<strong><a target='_blank' href='"+fileUrl+"'>" + data[i].fileName + "</a></strong>"
								+ "<a class='stream-cancel' href='javascript:deleteFile(\""+fileID+"\",\""+data[i].fileName+"\")'>删除</a></div></li>";
					$(fileLi).appendTo($("ul"));
				}
			}
		});
	}
	selfLoadFiles(groupID);
</script>
</body>
</html>