/*
 * Decompiled with CFR 0.152.
 */
package com.chenlb.mmseg4j;

import com.chenlb.mmseg4j.CharNode;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Dictionary {
    private static final Logger log = Logger.getLogger(Dictionary.class.getName());
    private File dicPath;
    private volatile Map<Character, CharNode> dict;
    private volatile Map<Character, Object> unit;
    private Map<File, Long> wordsLastTime = null;
    private long lastLoadTime = 0L;
    private static File defalutPath = null;
    private static final ConcurrentHashMap<File, Dictionary> dics = new ConcurrentHashMap();

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public static Dictionary getInstance() {
        File path = Dictionary.getDefalutPath();
        return Dictionary.getInstance(path);
    }

    public static Dictionary getInstance(String path) {
        return Dictionary.getInstance(new File(path));
    }

    public static Dictionary getInstance(File path) {
        log.info("try to load dir=" + path);
        File normalizeDir = Dictionary.normalizeFile(path);
        Dictionary dic = dics.get(normalizeDir);
        if (dic == null) {
            dic = new Dictionary(normalizeDir);
            dics.put(normalizeDir, dic);
        }
        return dic;
    }

    public static File normalizeFile(File file) {
        if (file == defalutPath) {
            return defalutPath;
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("normalize file=[" + file + "] fail", e);
        }
    }

    void destroy() {
        Dictionary.clear(this.dicPath);
        this.dicPath = null;
        this.dict = null;
        this.unit = null;
    }

    public static Dictionary clear(String path) {
        return Dictionary.clear(new File(path));
    }

    public static Dictionary clear(File path) {
        File normalizeDir = Dictionary.normalizeFile(path);
        return dics.remove(normalizeDir);
    }

    private Dictionary(File path) {
        this.init(path);
    }

    private void init(File path) {
        this.dicPath = path;
        this.wordsLastTime = new HashMap<File, Long>();
        this.reload();
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    protected File[] listWordsFiles() {
        return this.dicPath.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("words") && name.endsWith(".dic");
            }
        });
    }

    private Map<Character, CharNode> loadDic(File wordsPath) throws IOException {
        File[] words;
        long s;
        InputStream charsIn = null;
        File charsFile = new File(wordsPath, "chars.dic");
        if (charsFile.exists()) {
            charsIn = new FileInputStream(charsFile);
            this.addLastTime(charsFile);
        } else {
            charsIn = this.getClass().getResourceAsStream("/data/chars.dic");
            charsFile = new File(this.getClass().getResource("/data/chars.dic").getFile());
        }
        final HashMap<Character, CharNode> dic = new HashMap<Character, CharNode>();
        int lineNum = 0;
        long ss = s = Dictionary.now();
        lineNum = Dictionary.load(charsIn, new FileLoading(){

            @Override
            public void row(String line, int n) {
                if (line.length() < 1) {
                    return;
                }
                String[] w = line.split(" ");
                CharNode cn = new CharNode();
                switch (w.length) {
                    case 2: {
                        try {
                            cn.setFreq((int)(Math.log(Integer.parseInt(w[1])) * 100.0));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    case 1: {
                        dic.put(Character.valueOf(w[0].charAt(0)), cn);
                    }
                }
            }
        });
        log.info("chars loaded time=" + (Dictionary.now() - s) + "ms, line=" + lineNum + ", on file=" + charsFile);
        InputStream wordsDicIn = this.getClass().getResourceAsStream("/data/words.dic");
        if (wordsDicIn != null) {
            File wordsDic = new File(this.getClass().getResource("/data/words.dic").getFile());
            this.loadWord(wordsDicIn, dic, wordsDic);
        }
        if ((words = this.listWordsFiles()) != null) {
            for (File wordsFile : words) {
                this.loadWord(new FileInputStream(wordsFile), dic, wordsFile);
                this.addLastTime(wordsFile);
            }
        }
        log.info("load all dic use time=" + (Dictionary.now() - ss) + "ms");
        return dic;
    }

    private void loadWord(InputStream is, Map<Character, CharNode> dic, File wordsFile) throws IOException {
        long s = Dictionary.now();
        int lineNum = Dictionary.load(is, new WordsFileLoading(dic));
        log.info("words loaded time=" + (Dictionary.now() - s) + "ms, line=" + lineNum + ", on file=" + wordsFile);
    }

    private Map<Character, Object> loadUnit(File path) throws IOException {
        InputStream fin = null;
        File unitFile = new File(path, "units.dic");
        if (unitFile.exists()) {
            fin = new FileInputStream(unitFile);
            this.addLastTime(unitFile);
        } else {
            fin = Dictionary.class.getResourceAsStream("/data/units.dic");
            unitFile = new File(Dictionary.class.getResource("/data/units.dic").getFile());
        }
        final HashMap<Character, Object> unit = new HashMap<Character, Object>();
        long s = Dictionary.now();
        int lineNum = Dictionary.load(fin, new FileLoading(){

            @Override
            public void row(String line, int n) {
                if (line.length() != 1) {
                    return;
                }
                unit.put(Character.valueOf(line.charAt(0)), Dictionary.class);
            }
        });
        log.info("unit loaded time=" + (Dictionary.now() - s) + "ms, line=" + lineNum + ", on file=" + unitFile);
        return unit;
    }

    public static int load(InputStream fin, FileLoading loading) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(fin), "UTF-8"));
        String line = null;
        int n = 0;
        while ((line = br.readLine()) != null) {
            if (line == null || line.startsWith("#")) continue;
            loading.row(line, ++n);
        }
        return n;
    }

    private static char[] tail(String str) {
        char[] cs = new char[str.length() - 1];
        str.getChars(1, str.length(), cs, 0);
        return cs;
    }

    private synchronized void addLastTime(File wordsFile) {
        if (wordsFile != null) {
            this.wordsLastTime.put(wordsFile, wordsFile.lastModified());
        }
    }

    public synchronized boolean wordsFileIsChange() {
        for (Map.Entry<File, Long> flt : this.wordsLastTime.entrySet()) {
            File words = flt.getKey();
            if (!words.canRead()) {
                return true;
            }
            if (words.lastModified() <= flt.getValue()) continue;
            return true;
        }
        File[] words = this.listWordsFiles();
        if (words != null) {
            for (File wordsFile : words) {
                if (this.wordsLastTime.containsKey(wordsFile)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean reload() {
        HashMap<File, Long> oldWordsLastTime = new HashMap<File, Long>(this.wordsLastTime);
        Map<Character, CharNode> oldDict = this.dict;
        Map<Character, Object> oldUnit = this.unit;
        try {
            this.wordsLastTime.clear();
            this.dict = this.loadDic(this.dicPath);
            this.unit = this.loadUnit(this.dicPath);
            this.lastLoadTime = System.currentTimeMillis();
        }
        catch (IOException e) {
            this.wordsLastTime.putAll(oldWordsLastTime);
            this.dict = oldDict;
            this.unit = oldUnit;
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "reload dic error! dic=" + this.dicPath + ", and rollbacked.", e);
            }
            return false;
        }
        return true;
    }

    public boolean match(String word) {
        if (word == null || word.length() < 2) {
            return false;
        }
        CharNode cn = this.dict.get(Character.valueOf(word.charAt(0)));
        return this.search(cn, word.toCharArray(), 0, word.length() - 1) >= 0;
    }

    public CharNode head(char ch) {
        return this.dict.get(Character.valueOf(ch));
    }

    public int search(CharNode node, char[] sen, int offset, int tailLen) {
        if (node != null) {
            return node.indexOf(sen, offset, tailLen);
        }
        return -1;
    }

    public int maxMatch(char[] sen, int offset) {
        CharNode node = this.dict.get(Character.valueOf(sen[offset]));
        return this.maxMatch(node, sen, offset);
    }

    public int maxMatch(CharNode node, char[] sen, int offset) {
        if (node != null) {
            return node.maxMatch(sen, offset + 1);
        }
        return 0;
    }

    public ArrayList<Integer> maxMatch(CharNode node, ArrayList<Integer> tailLens, char[] sen, int offset) {
        tailLens.clear();
        tailLens.add(0);
        if (node != null) {
            return node.maxMatch(tailLens, sen, offset + 1);
        }
        return tailLens;
    }

    public boolean isUnit(Character ch) {
        return this.unit.containsKey(ch);
    }

    public static File getDefalutPath() {
        if (defalutPath == null) {
            String defPath = System.getProperty("mmseg.dic.path");
            log.info("look up in mmseg.dic.path=" + defPath);
            if (defPath == null) {
                URL url = Dictionary.class.getClassLoader().getResource("data");
                if (url != null) {
                    defPath = url.getFile();
                    log.info("look up in classpath=" + defPath);
                } else {
                    defPath = System.getProperty("user.dir") + "/data";
                    log.info("look up in user.dir=" + defPath);
                }
            }
            if (!(defalutPath = new File(defPath)).exists()) {
                log.warning("defalut dic path=" + defalutPath + " not exist");
            }
        }
        return defalutPath;
    }

    public Map<Character, CharNode> getDict() {
        return this.dict;
    }

    public File getDicPath() {
        return this.dicPath;
    }

    public long getLastLoadTime() {
        return this.lastLoadTime;
    }

    public static interface FileLoading {
        public void row(String var1, int var2);
    }

    private static class WordsFileLoading
    implements FileLoading {
        final Map<Character, CharNode> dic;

        public WordsFileLoading(Map<Character, CharNode> dic) {
            this.dic = dic;
        }

        @Override
        public void row(String line, int n) {
            if (line.length() < 2) {
                return;
            }
            CharNode cn = this.dic.get(Character.valueOf(line.charAt(0)));
            if (cn == null) {
                cn = new CharNode();
                this.dic.put(Character.valueOf(line.charAt(0)), cn);
            }
            cn.addWordTail(Dictionary.tail(line));
        }
    }
}

