/*
 * Decompiled with CFR 0.152.
 */
package PduParser;

import PduParser.PduPart;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class PduBody {
    private Vector<PduPart> mParts = new Vector();
    private Map<String, PduPart> mPartMapByContentId = new HashMap<String, PduPart>();
    private Map<String, PduPart> mPartMapByContentLocation = new HashMap<String, PduPart>();
    private Map<String, PduPart> mPartMapByName = new HashMap<String, PduPart>();
    private Map<String, PduPart> mPartMapByFileName = new HashMap<String, PduPart>();

    private void putPartToMaps(PduPart part) {
        byte[] fileName;
        byte[] name;
        byte[] contentLocation;
        byte[] contentId = part.getContentId();
        if (contentId != null) {
            this.mPartMapByContentId.put(new String(contentId), part);
        }
        if ((contentLocation = part.getContentLocation()) != null) {
            String clc = new String(contentLocation);
            this.mPartMapByContentLocation.put(clc, part);
        }
        if ((name = part.getName()) != null) {
            String clc = new String(name);
            this.mPartMapByName.put(clc, part);
        }
        if ((fileName = part.getFilename()) != null) {
            String clc = new String(fileName);
            this.mPartMapByFileName.put(clc, part);
        }
    }

    public boolean addPart(PduPart part) {
        if (part == null) {
            throw new NullPointerException();
        }
        this.putPartToMaps(part);
        return this.mParts.add(part);
    }

    public void addPart(int index, PduPart part) {
        if (part == null) {
            throw new NullPointerException();
        }
        this.putPartToMaps(part);
        this.mParts.add(index, part);
    }

    public PduPart removePart(int index) {
        return this.mParts.remove(index);
    }

    public void removeAll() {
        this.mParts.clear();
    }

    public PduPart getPart(int index) {
        return this.mParts.get(index);
    }

    public int getPartIndex(PduPart part) {
        return this.mParts.indexOf(part);
    }

    public int getPartsNum() {
        return this.mParts.size();
    }

    public PduPart getPartByContentId(String cid) {
        return this.mPartMapByContentId.get(cid);
    }

    public PduPart getPartByContentLocation(String contentLocation) {
        return this.mPartMapByContentLocation.get(contentLocation);
    }

    public PduPart getPartByName(String name) {
        return this.mPartMapByName.get(name);
    }

    public PduPart getPartByFileName(String filename) {
        return this.mPartMapByFileName.get(filename);
    }
}

