/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp;

import com.zx.sms.codec.cmpp.msg.CmppConnectRequestMessage;
import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.cmpp.packet.CmppConnectRequest;
import com.zx.sms.codec.cmpp.packet.CmppPacketType;
import com.zx.sms.codec.cmpp.packet.PacketType;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.util.CMPPCommonUtil;
import com.zx.sms.common.util.NettyByteBufUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.ReferenceCountUtil;
import java.util.List;

public class CmppConnectRequestMessageCodec
extends MessageToMessageCodec<Message, CmppConnectRequestMessage> {
    private PacketType packetType;

    public CmppConnectRequestMessageCodec() {
        this(CmppPacketType.CMPPCONNECTREQUEST);
    }

    public CmppConnectRequestMessageCodec(PacketType packetType) {
        this.packetType = packetType;
    }

    protected void decode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        long commandId = msg.getHeader().getCommandId();
        if (this.packetType.getCommandId() != commandId) {
            out.add(msg);
            return;
        }
        CmppConnectRequestMessage requestMessage = new CmppConnectRequestMessage(msg.getHeader());
        ByteBuf bodyBuffer = Unpooled.wrappedBuffer((byte[])msg.getBodyBuffer());
        requestMessage.setSourceAddr(bodyBuffer.readCharSequence(CmppConnectRequest.SOURCEADDR.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        requestMessage.setAuthenticatorSource(NettyByteBufUtil.toArray(bodyBuffer, CmppConnectRequest.AUTHENTICATORSOURCE.getLength()));
        requestMessage.setVersion(bodyBuffer.readUnsignedByte());
        requestMessage.setTimestamp(bodyBuffer.readUnsignedInt());
        ReferenceCountUtil.release((Object)bodyBuffer);
        out.add(requestMessage);
    }

    protected void encode(ChannelHandlerContext ctx, CmppConnectRequestMessage msg, List<Object> out) throws Exception {
        ByteBuf bodyBuffer = ctx.alloc().buffer(CmppConnectRequest.AUTHENTICATORSOURCE.getBodyLength());
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(msg.getSourceAddr().getBytes(GlobalConstance.defaultTransportCharset), CmppConnectRequest.SOURCEADDR.getLength(), 0));
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(msg.getAuthenticatorSource(), CmppConnectRequest.AUTHENTICATORSOURCE.getLength(), 0));
        bodyBuffer.writeByte((int)msg.getVersion());
        bodyBuffer.writeInt((int)msg.getTimestamp());
        msg.setBodyBuffer(NettyByteBufUtil.toArray(bodyBuffer, bodyBuffer.readableBytes()));
        msg.getHeader().setBodyLength(msg.getBodyBuffer().length);
        ReferenceCountUtil.release((Object)bodyBuffer);
        out.add(msg);
    }
}

