/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp;

import com.zx.sms.codec.cmpp.msg.CmppConnectResponseMessage;
import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.cmpp.packet.CmppConnectResponse;
import com.zx.sms.codec.cmpp.packet.CmppPacketType;
import com.zx.sms.codec.cmpp.packet.PacketType;
import com.zx.sms.common.NotSupportedException;
import com.zx.sms.common.util.NettyByteBufUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.ReferenceCountUtil;
import java.util.List;

public class CmppConnectResponseMessageCodec
extends MessageToMessageCodec<Message, CmppConnectResponseMessage> {
    private PacketType packetType;

    public CmppConnectResponseMessageCodec() {
        this(CmppPacketType.CMPPCONNECTRESPONSE);
    }

    public CmppConnectResponseMessageCodec(PacketType packetType) {
        this.packetType = packetType;
    }

    protected void decode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        long commandId = msg.getHeader().getCommandId();
        if (commandId != this.packetType.getCommandId()) {
            out.add(msg);
            return;
        }
        CmppConnectResponseMessage responseMessage = new CmppConnectResponseMessage(msg.getHeader());
        byte[] body = msg.getBodyBuffer();
        if (body.length != 21) {
            if (body.length == 18) {
                throw new NotSupportedException("error cmpp version . shoud use cmpp2.0 ");
            }
            throw new NotSupportedException("error cmpp CmppConnectResponseMessage data .");
        }
        ByteBuf bodyBuffer = Unpooled.wrappedBuffer((byte[])msg.getBodyBuffer());
        responseMessage.setStatus(bodyBuffer.readUnsignedInt());
        responseMessage.setAuthenticatorISMG(NettyByteBufUtil.toArray(bodyBuffer, CmppConnectResponse.AUTHENTICATORISMG.getLength()));
        responseMessage.setVersion(bodyBuffer.readUnsignedByte());
        ReferenceCountUtil.release((Object)bodyBuffer);
        out.add(responseMessage);
    }

    protected void encode(ChannelHandlerContext ctx, CmppConnectResponseMessage msg, List<Object> out) throws Exception {
        ByteBuf bodyBuffer = ctx.alloc().buffer(CmppConnectResponse.AUTHENTICATORISMG.getBodyLength());
        bodyBuffer.writeInt((int)msg.getStatus());
        bodyBuffer.writeBytes(msg.getAuthenticatorISMG());
        bodyBuffer.writeByte((int)msg.getVersion());
        msg.setBodyBuffer(NettyByteBufUtil.toArray(bodyBuffer, bodyBuffer.readableBytes()));
        msg.getHeader().setBodyLength(msg.getBodyBuffer().length);
        ReferenceCountUtil.release((Object)bodyBuffer);
        out.add(msg);
    }
}

