/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp;

import com.zx.sms.codec.cmpp.msg.DefaultHeader;
import com.zx.sms.codec.cmpp.msg.DefaultMessage;
import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.cmpp.packet.CmppHead;
import com.zx.sms.common.GlobalConstance;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmppHeaderCodec
extends MessageToMessageCodec<ByteBuf, Message> {
    private final Logger logger = LoggerFactory.getLogger(CmppHeaderCodec.class);

    protected void decode(ChannelHandlerContext ctx, ByteBuf bytebuf, List<Object> list) throws Exception {
        DefaultHeader header = new DefaultHeader();
        header.setPacketLength(bytebuf.readUnsignedInt());
        header.setCommandId(bytebuf.readUnsignedInt());
        header.setSequenceId(bytebuf.readUnsignedInt());
        header.setHeadLength(CmppHead.COMMANDID.getHeadLength());
        header.setBodyLength(header.getPacketLength() - header.getHeadLength());
        DefaultMessage message = new DefaultMessage();
        if (header.getBodyLength() > 0L) {
            message.setBodyBuffer(new byte[(int)header.getBodyLength()]);
            assert (header.getBodyLength() == (long)bytebuf.readableBytes());
            bytebuf.readBytes(message.getBodyBuffer());
        } else {
            message.setBodyBuffer(GlobalConstance.emptyBytes);
        }
        message.setHeader(header);
        list.add(message);
    }

    protected void encode(ChannelHandlerContext ctx, Message message, List<Object> list) throws Exception {
        int headerLength = CmppHead.COMMANDID.getHeadLength();
        int packetLength = message.getBodyBuffer().length + headerLength;
        ByteBuf buf = ctx.alloc().buffer(packetLength);
        buf.writeInt(packetLength);
        buf.writeInt((int)message.getHeader().getCommandId());
        buf.writeInt((int)message.getHeader().getSequenceId());
        if (packetLength > headerLength) {
            buf.writeBytes(message.getBodyBuffer());
        }
        list.add(buf);
    }
}

