/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp;

import com.zx.sms.codec.cmpp.msg.CmppQueryRequestMessage;
import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.cmpp.packet.CmppPacketType;
import com.zx.sms.codec.cmpp.packet.CmppQueryRequest;
import com.zx.sms.codec.cmpp.packet.PacketType;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.util.CMPPCommonUtil;
import com.zx.sms.common.util.NettyByteBufUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.ReferenceCountUtil;
import java.util.List;

public class CmppQueryRequestMessageCodec
extends MessageToMessageCodec<Message, CmppQueryRequestMessage> {
    private PacketType packetType;

    public CmppQueryRequestMessageCodec() {
        this(CmppPacketType.CMPPQUERYREQUEST);
    }

    public CmppQueryRequestMessageCodec(PacketType packetType) {
        this.packetType = packetType;
    }

    protected void decode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        long commandId = msg.getHeader().getCommandId();
        if (this.packetType.getCommandId() != commandId) {
            out.add(msg);
            return;
        }
        CmppQueryRequestMessage requestMessage = new CmppQueryRequestMessage(msg.getHeader());
        ByteBuf bodyBuffer = Unpooled.wrappedBuffer((byte[])msg.getBodyBuffer());
        requestMessage.setTime(bodyBuffer.readCharSequence(CmppQueryRequest.TIME.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        requestMessage.setQueryType(bodyBuffer.readUnsignedByte());
        requestMessage.setQueryCode(bodyBuffer.readCharSequence(CmppQueryRequest.QUERYCODE.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        requestMessage.setReserve(bodyBuffer.readCharSequence(CmppQueryRequest.RESERVE.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        ReferenceCountUtil.release((Object)bodyBuffer);
        out.add(requestMessage);
    }

    protected void encode(ChannelHandlerContext ctx, CmppQueryRequestMessage msg, List<Object> out) throws Exception {
        ByteBuf bodyBuffer = ctx.alloc().buffer(CmppQueryRequest.QUERYCODE.getBodyLength());
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(msg.getTime().getBytes(GlobalConstance.defaultTransportCharset), CmppQueryRequest.TIME.getLength(), 0));
        bodyBuffer.writeByte((int)msg.getQueryType());
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(msg.getQueryCode().getBytes(GlobalConstance.defaultTransportCharset), CmppQueryRequest.QUERYCODE.getLength(), 0));
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(msg.getReserve().getBytes(GlobalConstance.defaultTransportCharset), CmppQueryRequest.RESERVE.getLength(), 0));
        msg.setBodyBuffer(NettyByteBufUtil.toArray(bodyBuffer, bodyBuffer.readableBytes()));
        msg.getHeader().setBodyLength(msg.getBodyBuffer().length);
        ReferenceCountUtil.release((Object)bodyBuffer);
        out.add(msg);
    }
}

