/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp;

import com.zx.sms.codec.cmpp.msg.CmppSubmitRequestMessage;
import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.cmpp.packet.CmppPacketType;
import com.zx.sms.codec.cmpp.packet.CmppSubmitRequest;
import com.zx.sms.codec.cmpp.packet.PacketType;
import com.zx.sms.codec.cmpp.wap.LongMessageFrameHolder;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.util.CMPPCommonUtil;
import com.zx.sms.common.util.DefaultMsgIdUtil;
import com.zx.sms.common.util.NettyByteBufUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import org.marre.sms.SmsDcs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmppSubmitRequestMessageCodec
extends MessageToMessageCodec<Message, CmppSubmitRequestMessage> {
    private static final Logger logger = LoggerFactory.getLogger(CmppSubmitRequestMessageCodec.class);
    private PacketType packetType;

    public CmppSubmitRequestMessageCodec() {
        this(CmppPacketType.CMPPSUBMITREQUEST);
    }

    public CmppSubmitRequestMessageCodec(PacketType packetType) {
        this.packetType = packetType;
    }

    protected void decode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        long commandId = msg.getHeader().getCommandId();
        if (this.packetType.getCommandId() != commandId) {
            out.add(msg);
            return;
        }
        CmppSubmitRequestMessage requestMessage = new CmppSubmitRequestMessage(msg.getHeader());
        ByteBuf bodyBuffer = Unpooled.wrappedBuffer((byte[])msg.getBodyBuffer());
        requestMessage.setMsgid(DefaultMsgIdUtil.bytes2MsgId(NettyByteBufUtil.toArray(bodyBuffer, CmppSubmitRequest.MSGID.getLength())));
        requestMessage.setPktotal(bodyBuffer.readUnsignedByte());
        requestMessage.setPknumber(bodyBuffer.readUnsignedByte());
        requestMessage.setRegisteredDelivery(bodyBuffer.readUnsignedByte());
        requestMessage.setMsglevel(bodyBuffer.readUnsignedByte());
        requestMessage.setServiceId(bodyBuffer.readCharSequence(CmppSubmitRequest.SERVICEID.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        requestMessage.setFeeUserType(bodyBuffer.readUnsignedByte());
        requestMessage.setFeeterminalId(bodyBuffer.readCharSequence(CmppSubmitRequest.FEETERMINALID.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        requestMessage.setFeeterminaltype(bodyBuffer.readUnsignedByte());
        requestMessage.setTppid(bodyBuffer.readUnsignedByte());
        requestMessage.setTpudhi(bodyBuffer.readUnsignedByte());
        requestMessage.setMsgfmt(new SmsDcs((byte)bodyBuffer.readUnsignedByte()));
        requestMessage.setMsgsrc(bodyBuffer.readCharSequence(CmppSubmitRequest.MSGSRC.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        requestMessage.setFeeType(bodyBuffer.readCharSequence(CmppSubmitRequest.FEETYPE.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        requestMessage.setFeeCode(bodyBuffer.readCharSequence(CmppSubmitRequest.FEECODE.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        requestMessage.setValIdTime(bodyBuffer.readCharSequence(CmppSubmitRequest.VALIDTIME.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        requestMessage.setAtTime(bodyBuffer.readCharSequence(CmppSubmitRequest.ATTIME.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        requestMessage.setSrcId(bodyBuffer.readCharSequence(CmppSubmitRequest.SRCID.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        int destUsrtl = bodyBuffer.readUnsignedByte();
        String[] destTermId = new String[destUsrtl];
        int i = 0;
        while (i < destUsrtl) {
            destTermId[i] = bodyBuffer.readCharSequence(CmppSubmitRequest.DESTTERMINALID.getLength(), GlobalConstance.defaultTransportCharset).toString().trim();
            ++i;
        }
        requestMessage.setDestterminalId(destTermId);
        requestMessage.setDestterminaltype(bodyBuffer.readUnsignedByte());
        short msgLength = (short)(LongMessageFrameHolder.getPayloadLength(requestMessage.getMsgfmt().getAlphabet(), bodyBuffer.readUnsignedByte()) & 0xFFFF);
        byte[] contentbytes = new byte[msgLength];
        bodyBuffer.readBytes(contentbytes);
        requestMessage.setMsgContentBytes(contentbytes);
        requestMessage.setMsgLength(msgLength);
        requestMessage.setLinkID(bodyBuffer.readCharSequence(CmppSubmitRequest.LINKID.getLength(), GlobalConstance.defaultTransportCharset).toString().trim());
        out.add(requestMessage);
        ReferenceCountUtil.release((Object)bodyBuffer);
    }

    protected void encode(ChannelHandlerContext ctx, CmppSubmitRequestMessage requestMessage, List<Object> out) throws Exception {
        assert (requestMessage.getDestUsrtl() > 0);
        ByteBuf bodyBuffer = ctx.alloc().buffer(CmppSubmitRequest.ATTIME.getBodyLength() + requestMessage.getMsgLength() + (requestMessage.getDestUsrtl() - 1) * CmppSubmitRequest.DESTTERMINALID.getLength());
        bodyBuffer.writeBytes(DefaultMsgIdUtil.msgId2Bytes(requestMessage.getMsgid()));
        bodyBuffer.writeByte((int)requestMessage.getPktotal());
        bodyBuffer.writeByte((int)requestMessage.getPknumber());
        bodyBuffer.writeByte((int)requestMessage.getRegisteredDelivery());
        bodyBuffer.writeByte((int)requestMessage.getMsglevel());
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(requestMessage.getServiceId().getBytes(GlobalConstance.defaultTransportCharset), CmppSubmitRequest.SERVICEID.getLength(), 0));
        bodyBuffer.writeByte((int)requestMessage.getFeeUserType());
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(requestMessage.getFeeterminalId().getBytes(GlobalConstance.defaultTransportCharset), CmppSubmitRequest.FEETERMINALID.getLength(), 0));
        bodyBuffer.writeByte((int)requestMessage.getFeeterminaltype());
        bodyBuffer.writeByte((int)requestMessage.getTppid());
        bodyBuffer.writeByte((int)requestMessage.getTpudhi());
        bodyBuffer.writeByte((int)requestMessage.getMsgfmt().getValue());
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(requestMessage.getMsgsrc().getBytes(GlobalConstance.defaultTransportCharset), CmppSubmitRequest.MSGSRC.getLength(), 0));
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(requestMessage.getFeeType().getBytes(GlobalConstance.defaultTransportCharset), CmppSubmitRequest.FEETYPE.getLength(), 0));
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(requestMessage.getFeeCode().getBytes(GlobalConstance.defaultTransportCharset), CmppSubmitRequest.FEECODE.getLength(), 0));
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(requestMessage.getValIdTime().getBytes(GlobalConstance.defaultTransportCharset), CmppSubmitRequest.VALIDTIME.getLength(), 0));
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(requestMessage.getAtTime().getBytes(GlobalConstance.defaultTransportCharset), CmppSubmitRequest.ATTIME.getLength(), 0));
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(requestMessage.getSrcId().getBytes(GlobalConstance.defaultTransportCharset), CmppSubmitRequest.SRCID.getLength(), 0));
        bodyBuffer.writeByte((int)requestMessage.getDestUsrtl());
        int i = 0;
        while (i < requestMessage.getDestUsrtl()) {
            String[] destTermId = requestMessage.getDestterminalId();
            bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(destTermId[i].getBytes(GlobalConstance.defaultTransportCharset), CmppSubmitRequest.DESTTERMINALID.getLength(), 0));
            ++i;
        }
        bodyBuffer.writeByte((int)requestMessage.getDestterminaltype());
        bodyBuffer.writeByte((int)requestMessage.getMsgLength());
        bodyBuffer.writeBytes(requestMessage.getMsgContentBytes());
        bodyBuffer.writeBytes(CMPPCommonUtil.ensureLength(requestMessage.getLinkID().getBytes(GlobalConstance.defaultTransportCharset), CmppSubmitRequest.LINKID.getLength(), 0));
        requestMessage.setBodyBuffer(NettyByteBufUtil.toArray(bodyBuffer, bodyBuffer.readableBytes()));
        requestMessage.getHeader().setBodyLength(requestMessage.getBodyBuffer().length);
        out.add(requestMessage);
        ReferenceCountUtil.release((Object)bodyBuffer);
    }
}

