/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp.msg;

import com.zx.sms.LongSMSMessage;
import com.zx.sms.codec.cmpp.msg.CmppReportRequestMessage;
import com.zx.sms.codec.cmpp.msg.DefaultMessage;
import com.zx.sms.codec.cmpp.msg.Header;
import com.zx.sms.codec.cmpp.packet.CmppPacketType;
import com.zx.sms.codec.cmpp.packet.PacketType;
import com.zx.sms.codec.cmpp.wap.LongMessageFrame;
import com.zx.sms.codec.cmpp.wap.LongMessageFrameHolder;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.util.CMPPCommonUtil;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import com.zx.sms.common.util.MsgId;
import java.util.ArrayList;
import java.util.List;
import org.marre.sms.SmsDcs;
import org.marre.sms.SmsMessage;

public class CmppDeliverRequestMessage
extends DefaultMessage
implements LongSMSMessage<CmppDeliverRequestMessage> {
    private static final long serialVersionUID = 4851585208067281751L;
    private MsgId msgId = new MsgId();
    private String destId = "";
    private String serviceid = "";
    private String srcterminalId = "";
    private short srcterminalType = 0;
    private short registeredDelivery = 0;
    private CmppReportRequestMessage reportRequestMessage = null;
    private String linkid = "";
    private String reserved = "";
    private SmsMessage msg;
    private short tppid = 0;
    private short tpudhi = 0;
    private SmsDcs msgfmt = GlobalConstance.defaultmsgfmt;
    private short msgLength = (short)140;
    private byte[] msgContentBytes = GlobalConstance.emptyBytes;
    private List<CmppDeliverRequestMessage> fragments = null;

    public CmppDeliverRequestMessage(Header header) {
        super((PacketType)CmppPacketType.CMPPDELIVERREQUEST, header);
    }

    public CmppDeliverRequestMessage() {
        super(CmppPacketType.CMPPDELIVERREQUEST);
    }

    public MsgId getMsgId() {
        return this.msgId;
    }

    public void setMsgId(MsgId msgId) {
        this.msgId = msgId;
    }

    public String getDestId() {
        return this.destId;
    }

    public void setDestId(String destId) {
        this.destId = destId;
    }

    public String getServiceid() {
        return this.serviceid;
    }

    public void setServiceid(String serviceid) {
        this.serviceid = serviceid;
    }

    public String getSrcterminalId() {
        return this.srcterminalId;
    }

    public void setSrcterminalId(String srcterminalId) {
        this.srcterminalId = srcterminalId;
    }

    public short getSrcterminalType() {
        return this.srcterminalType;
    }

    public void setSrcterminalType(short srcterminalType) {
        this.srcterminalType = srcterminalType;
    }

    public String getReserved() {
        return this.reserved;
    }

    public void setReserved(String reserved) {
        this.reserved = reserved;
    }

    public CmppReportRequestMessage getReportRequestMessage() {
        return this.reportRequestMessage;
    }

    public void setReportRequestMessage(CmppReportRequestMessage reportRequestMessage) {
        this.reportRequestMessage = reportRequestMessage;
        if (reportRequestMessage != null) {
            this.registeredDelivery = 1;
        }
    }

    public String getLinkid() {
        return this.linkid;
    }

    public void setLinkid(String linkid) {
        this.linkid = linkid;
    }

    @Override
    public boolean isReport() {
        return this.registeredDelivery != 0;
    }

    public String getMsgContent() {
        if (this.msg instanceof SmsMessage) {
            return this.msg.toString();
        }
        if (this.msgContentBytes != null && this.msgContentBytes.length > 0) {
            LongMessageFrame frame = this.generateFrame();
            return LongMessageFrameHolder.INS.getPartTextMsg(frame);
        }
        return "";
    }

    public short getTppid() {
        return this.tppid;
    }

    public void setTppid(short tppid) {
        this.tppid = tppid;
    }

    public short getTpudhi() {
        return this.tpudhi;
    }

    public void setTpudhi(short tpudhi) {
        this.tpudhi = tpudhi;
    }

    public SmsDcs getMsgfmt() {
        return this.msgfmt;
    }

    public void setMsgfmt(SmsDcs msgfmt) {
        this.msgfmt = msgfmt;
    }

    public short getMsgLength() {
        return this.msgLength;
    }

    public void setMsgLength(short msgLength) {
        this.msgLength = msgLength;
    }

    public byte[] getMsgContentBytes() {
        return this.msgContentBytes;
    }

    public void setMsgContentBytes(byte[] msgContentBytes) {
        this.msgContentBytes = msgContentBytes;
    }

    public void setMsg(SmsMessage msg) {
        this.msg = msg;
    }

    public void setMsgContent(String msgContent) {
        this.setMsgContent(CMPPCommonUtil.buildTextMessage(msgContent));
    }

    public void setMsgContent(SmsMessage msg) {
        this.msg = msg;
    }

    @Override
    public SmsMessage getSmsMessage() {
        return this.msg;
    }

    @Override
    public CmppDeliverRequestMessage clone() throws CloneNotSupportedException {
        return (CmppDeliverRequestMessage)super.clone();
    }

    @Override
    public String toString() {
        if (this.isReport()) {
            StringBuilder sb = new StringBuilder();
            sb.append("CmppDeliverRequestMessage [msgId=").append(this.msgId).append(", destId=").append(this.destId).append(", srcterminalId=").append(this.srcterminalId).append(", getHeader()=").append(this.getHeader()).append(", ReportRequest=").append(this.getReportRequestMessage()).append("]");
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CmppDeliverRequestMessage [msgId=").append(this.msgId).append(", destId=").append(this.destId).append(", srcterminalId=").append(this.srcterminalId).append(", msgContent=").append(this.getMsgContent()).append(", sequenceId=").append(this.getHeader().getSequenceId()).append("]");
        return sb.toString();
    }

    @Override
    public LongMessageFrame generateFrame() {
        LongMessageFrame frame = new LongMessageFrame();
        frame.setTppid(this.getTppid());
        frame.setTpudhi(this.getTpudhi());
        frame.setMsgfmt(this.getMsgfmt());
        frame.setMsgContentBytes(this.getMsgContentBytes());
        frame.setMsgLength(this.getMsgLength());
        frame.setSequence(this.getSequenceNo());
        return frame;
    }

    @Override
    public CmppDeliverRequestMessage generateMessage(LongMessageFrame frame) throws Exception {
        CmppDeliverRequestMessage requestMessage = this.clone();
        requestMessage.setTpudhi(frame.getTpudhi());
        requestMessage.setMsgfmt(frame.getMsgfmt());
        requestMessage.setMsgContentBytes(frame.getMsgContentBytes());
        requestMessage.setMsgLength(frame.getMsgLength());
        if (frame.getPknumber() != 1) {
            requestMessage.getHeader().setSequenceId(DefaultSequenceNumberUtil.getSequenceNo());
        }
        requestMessage.setMsg(null);
        return requestMessage;
    }

    @Override
    public List<CmppDeliverRequestMessage> getFragments() {
        return this.fragments;
    }

    @Override
    public void addFragment(CmppDeliverRequestMessage fragment) {
        if (this.fragments == null) {
            this.fragments = new ArrayList<CmppDeliverRequestMessage>();
        }
        this.fragments.add(fragment);
    }
}

