/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp.msg;

import com.zx.sms.LongSMSMessage;
import com.zx.sms.codec.cmpp.msg.DefaultMessage;
import com.zx.sms.codec.cmpp.msg.Header;
import com.zx.sms.codec.cmpp.packet.CmppPacketType;
import com.zx.sms.codec.cmpp.packet.PacketType;
import com.zx.sms.codec.cmpp.wap.LongMessageFrame;
import com.zx.sms.codec.cmpp.wap.LongMessageFrameHolder;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.util.CMPPCommonUtil;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import com.zx.sms.common.util.MsgId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.marre.sms.SmsDcs;
import org.marre.sms.SmsMessage;

public class CmppSubmitRequestMessage
extends DefaultMessage
implements LongSMSMessage<CmppSubmitRequestMessage> {
    private static final long serialVersionUID = 1369427662600486133L;
    private MsgId msgid = new MsgId();
    private short registeredDelivery = 0;
    private short msglevel = (short)9;
    private String serviceId = "";
    private short feeUserType = (short)2;
    private String feeterminalId = "";
    private short feeterminaltype = 0;
    private String msgsrc = "";
    private String feeType = "01";
    private String feeCode = "000000";
    private String valIdTime = "";
    private String atTime = "";
    private String srcId = "";
    private String[] destterminalId = GlobalConstance.emptyStringArray;
    private short destterminaltype = 0;
    private String linkID = "";
    private String reserve = "";
    private SmsMessage msg;
    private short pktotal = 1;
    private short pknumber = 1;
    private short tppid = 0;
    private short tpudhi = 0;
    private SmsDcs msgfmt = GlobalConstance.defaultmsgfmt;
    private short msgLength = (short)140;
    private byte[] msgContentBytes = GlobalConstance.emptyBytes;
    private List<CmppSubmitRequestMessage> fragments = null;

    public CmppSubmitRequestMessage(Header header) {
        super((PacketType)CmppPacketType.CMPPSUBMITREQUEST, header);
    }

    public CmppSubmitRequestMessage() {
        super(CmppPacketType.CMPPSUBMITREQUEST);
    }

    public MsgId getMsgid() {
        return this.msgid;
    }

    public void setMsgid(MsgId msgid) {
        this.msgid = msgid;
    }

    @Override
    public boolean isReport() {
        return false;
    }

    public short getRegisteredDelivery() {
        return this.registeredDelivery;
    }

    public void setRegisteredDelivery(short registeredDelivery) {
        this.registeredDelivery = registeredDelivery;
    }

    public short getMsglevel() {
        return this.msglevel;
    }

    public void setMsglevel(short msglevel) {
        this.msglevel = msglevel;
    }

    public String getServiceId() {
        return this.serviceId == null ? "" : this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public short getFeeUserType() {
        return this.feeUserType;
    }

    public void setFeeUserType(short feeUserType) {
        this.feeUserType = feeUserType;
    }

    public String getFeeterminalId() {
        return this.feeterminalId == null ? "" : this.feeterminalId;
    }

    public void setFeeterminalId(String feeterminalId) {
        this.feeterminalId = feeterminalId;
    }

    public short getFeeterminaltype() {
        return this.feeterminaltype;
    }

    public void setFeeterminaltype(short feeterminaltype) {
        this.feeterminaltype = feeterminaltype;
    }

    public String getMsgsrc() {
        return this.msgsrc == null ? "" : this.msgsrc;
    }

    public void setMsgsrc(String msgsrc) {
        this.msgsrc = msgsrc;
    }

    public String getFeeType() {
        return this.feeType == null ? "" : this.feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public String getFeeCode() {
        return this.feeCode == null ? "" : this.feeCode;
    }

    public void setFeeCode(String feeCode) {
        this.feeCode = feeCode;
    }

    public String getValIdTime() {
        return this.valIdTime == null ? "" : this.valIdTime;
    }

    public void setValIdTime(String valIdTime) {
        this.valIdTime = valIdTime;
    }

    public String getAtTime() {
        return this.atTime == null ? "" : this.atTime;
    }

    public void setAtTime(String atTime) {
        this.atTime = atTime;
    }

    public String getSrcId() {
        return this.srcId == null ? "" : this.srcId;
    }

    public void setSrcId(String srcId) {
        this.srcId = srcId;
    }

    public short getDestUsrtl() {
        return (short)this.destterminalId.length;
    }

    public String[] getDestterminalId() {
        return this.destterminalId;
    }

    public void setDestterminalId(String[] destterminalId) {
        this.destterminalId = destterminalId;
    }

    public void setDestterminalId(String destterminalId) {
        this.destterminalId = new String[]{destterminalId};
    }

    public short getDestterminaltype() {
        return this.destterminaltype;
    }

    public void setDestterminaltype(short destterminaltype) {
        this.destterminaltype = destterminaltype;
    }

    public String getLinkID() {
        return this.linkID == null ? "" : this.linkID;
    }

    public void setLinkID(String linkID) {
        this.linkID = linkID;
    }

    public String getReserve() {
        return this.reserve;
    }

    public void setReserve(String reserve) {
        this.reserve = reserve;
    }

    public String getMsgContent() {
        if (this.msg instanceof SmsMessage) {
            return this.msg.toString();
        }
        if (this.msgContentBytes != null && this.msgContentBytes.length > 0) {
            LongMessageFrame frame = this.generateFrame();
            return LongMessageFrameHolder.INS.getPartTextMsg(frame);
        }
        return "";
    }

    @Override
    public SmsMessage getSmsMessage() {
        return this.msg;
    }

    public void setMsgContent(String msgContent) {
        this.setMsgContent(CMPPCommonUtil.buildTextMessage(msgContent));
    }

    public void setMsgContent(SmsMessage msg) {
        this.msg = msg;
    }

    public byte[] getMsgContentBytes() {
        return this.msgContentBytes;
    }

    public void setMsgContentBytes(byte[] msgContentBytes) {
        this.msgContentBytes = msgContentBytes;
    }

    public short getPktotal() {
        return this.pktotal;
    }

    public void setPktotal(short pktotal) {
        this.pktotal = pktotal;
    }

    public short getPknumber() {
        return this.pknumber;
    }

    public void setPknumber(short pknumber) {
        this.pknumber = pknumber;
    }

    public short getTppid() {
        return this.tppid;
    }

    public void setTppid(short tppid) {
        this.tppid = tppid;
    }

    public short getTpudhi() {
        return this.tpudhi;
    }

    public void setTpudhi(short tpudhi) {
        this.tpudhi = tpudhi;
    }

    public SmsDcs getMsgfmt() {
        return this.msgfmt;
    }

    public void setMsgfmt(SmsDcs msgfmt) {
        this.msgfmt = msgfmt;
    }

    public short getMsgLength() {
        return this.msgLength;
    }

    public void setMsgLength(short msgLength) {
        this.msgLength = msgLength;
    }

    public void setMsg(SmsMessage msg) {
        this.msg = msg;
    }

    public static CmppSubmitRequestMessage create(String phone, String spid, String text) {
        CmppSubmitRequestMessage ret = new CmppSubmitRequestMessage();
        ret.setDestterminalId(new String[]{phone});
        ret.setSrcId(spid);
        ret.setMsgContent(text);
        return ret;
    }

    @Override
    public CmppSubmitRequestMessage clone() throws CloneNotSupportedException {
        return (CmppSubmitRequestMessage)super.clone();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CmppSubmitRequestMessage [msgid=").append(this.msgid).append(", serviceId=").append(this.serviceId).append(", srcId=").append(this.srcId).append(", msgsrc=").append(this.msgsrc).append(", destterminalId=").append(Arrays.toString(this.destterminalId)).append(", msgContent=").append(this.getMsgContent()).append(", sequenceId=").append(this.getHeader().getSequenceId()).append("]");
        return sb.toString();
    }

    @Override
    public LongMessageFrame generateFrame() {
        LongMessageFrame frame = new LongMessageFrame();
        frame.setTppid(this.getTppid());
        frame.setTpudhi(this.getTpudhi());
        frame.setMsgfmt(this.getMsgfmt());
        frame.setMsgContentBytes(this.getMsgContentBytes());
        frame.setMsgLength(this.getMsgLength());
        frame.setSequence(this.getSequenceNo());
        return frame;
    }

    @Override
    public CmppSubmitRequestMessage generateMessage(LongMessageFrame frame) throws Exception {
        CmppSubmitRequestMessage requestMessage = this.clone();
        requestMessage.setPknumber(frame.getPknumber());
        requestMessage.setPktotal(frame.getPktotal());
        requestMessage.setTpudhi(frame.getTpudhi());
        requestMessage.setMsgfmt(frame.getMsgfmt());
        requestMessage.setMsgContentBytes(frame.getMsgContentBytes());
        requestMessage.setMsgLength(frame.getMsgLength());
        if (frame.getPknumber() != 1) {
            requestMessage.getHeader().setSequenceId(DefaultSequenceNumberUtil.getSequenceNo());
        }
        requestMessage.setMsg(null);
        return requestMessage;
    }

    @Override
    public List<CmppSubmitRequestMessage> getFragments() {
        return this.fragments;
    }

    @Override
    public void addFragment(CmppSubmitRequestMessage fragment) {
        if (this.fragments == null) {
            this.fragments = new ArrayList<CmppSubmitRequestMessage>();
        }
        this.fragments.add(fragment);
    }
}

