/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp.wap;

import com.zx.sms.BaseMessage;
import com.zx.sms.LongSMSMessage;
import com.zx.sms.codec.cmpp.wap.LongMessageFrame;
import com.zx.sms.codec.cmpp.wap.LongMessageFrameHolder;
import com.zx.sms.codec.cmpp.wap.SmsMessageHolder;
import com.zx.sms.connect.manager.EndpointEntity;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;
import org.marre.sms.SmsMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLongMessageHandler<T extends BaseMessage>
extends MessageToMessageCodec<T, T> {
    private final Logger logger = LoggerFactory.getLogger(AbstractLongMessageHandler.class);
    private EndpointEntity entity;

    public AbstractLongMessageHandler(EndpointEntity entity) {
        this.entity = entity;
    }

    protected void decode(ChannelHandlerContext ctx, T msg, List<Object> out) throws Exception {
        if ((this.entity == null || this.entity.getSupportLongmsg() == EndpointEntity.SupportLongMessage.BOTH || this.entity.getSupportLongmsg() == EndpointEntity.SupportLongMessage.RECV) && msg instanceof LongSMSMessage && this.needHandleLongMessage(msg)) {
            String key = this.generateFrameKey(msg);
            try {
                SmsMessageHolder hoder = LongMessageFrameHolder.INS.putAndget(key, (LongSMSMessage)msg);
                if (hoder != null) {
                    this.resetMessageContent((BaseMessage)((Object)hoder.msg), hoder.smsMessage);
                    out.add(hoder.msg);
                }
            }
            catch (Exception ex) {
                this.logger.error("", (Throwable)ex);
                this.logger.error("Decode Message Error ,msg dump :{}", (Object)ByteBufUtil.hexDump((byte[])((LongSMSMessage)msg).generateFrame().getMsgContentBytes()));
                BaseMessage res = this.response(msg);
                res.setRequest((BaseMessage)msg);
                ctx.writeAndFlush((Object)res);
            }
        } else {
            out.add(msg);
        }
    }

    protected void encode(ChannelHandlerContext ctx, T requestMessage, List<Object> out) throws Exception {
        if ((this.entity == null || this.entity.getSupportLongmsg() == EndpointEntity.SupportLongMessage.BOTH || this.entity.getSupportLongmsg() == EndpointEntity.SupportLongMessage.SEND) && requestMessage instanceof LongSMSMessage && this.needHandleLongMessage(requestMessage)) {
            SmsMessage msgcontent = ((LongSMSMessage)requestMessage).getSmsMessage();
            List<LongMessageFrame> frameList = LongMessageFrameHolder.INS.splitmsgcontent(msgcontent);
            boolean first = true;
            LongSMSMessage lmsg = (LongSMSMessage)requestMessage;
            for (LongMessageFrame frame : frameList) {
                BaseMessage t = (BaseMessage)lmsg.generateMessage(frame);
                out.add(t);
            }
        } else {
            out.add(requestMessage);
        }
    }

    protected abstract BaseMessage response(T var1);

    protected abstract boolean needHandleLongMessage(T var1);

    protected abstract String generateFrameKey(T var1) throws Exception;

    protected abstract void resetMessageContent(T var1, SmsMessage var2);
}

