/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp.wap;

import com.zx.sms.LongSMSMessage;
import com.zx.sms.codec.cmpp.wap.InformationElement;
import com.zx.sms.codec.cmpp.wap.LongMessageFrameHolder;
import com.zx.sms.common.NotSupportedException;
import com.zx.sms.common.util.CachedMillisecondClock;
import java.util.BitSet;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.marre.sms.SmsDcs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FrameHolder {
    private static final Logger logger = LoggerFactory.getLogger(FrameHolder.class);
    private String serviceNum;
    private long sequence;
    private long timestamp = CachedMillisecondClock.INS.now();
    private int totalLength = 0;
    int frameKey;
    private byte[][] content;
    private int totalbyteLength = 0;
    private BitSet idxBitset;
    private SmsDcs msgfmt;
    private InformationElement appUDHinfo;
    private LongSMSMessage msg;

    public void setAppUDHinfo(InformationElement appUDHinfo) {
        this.appUDHinfo = appUDHinfo;
    }

    public InformationElement getAppUDHinfo() {
        return this.appUDHinfo;
    }

    public void setServiceNum(String serviceNum) {
        this.serviceNum = serviceNum;
    }

    public long getSequence() {
        return this.sequence;
    }

    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public FrameHolder(int frameKey, int totalLength) {
        this.frameKey = frameKey;
        this.totalLength = totalLength;
        this.content = new byte[totalLength][];
        this.idxBitset = new BitSet(totalLength);
    }

    public synchronized void merge(byte[] content, int idx) throws NotSupportedException {
        if (this.idxBitset.get(idx)) {
            logger.warn("have received the same index:{} of Message. do not merge this content.{},origin:{},{},{},new content:{}", new Object[]{idx, this.serviceNum, LongMessageFrameHolder.buildTextMessage(this.content[idx], this.msgfmt).getText(), DateFormatUtils.format((long)this.getTimestamp(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern()), this.getSequence(), LongMessageFrameHolder.buildTextMessage(content, this.msgfmt).getText()});
            throw new NotSupportedException("received the same index");
        }
        if (this.content.length <= idx || idx < 0) {
            logger.warn("have received error index:{} of Message content length:{}. do not merge this content.{},{},{},{}", new Object[]{idx, this.content.length, this.serviceNum, DateFormatUtils.format((long)this.getTimestamp(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern()), this.getSequence(), LongMessageFrameHolder.buildTextMessage(content, this.msgfmt).getText()});
            throw new NotSupportedException("have received error index");
        }
        this.idxBitset.set(idx);
        this.content[idx] = content;
        this.totalbyteLength += this.content[idx].length;
    }

    public synchronized boolean isComplete() {
        return this.totalLength == this.idxBitset.cardinality();
    }

    public synchronized byte[] mergeAllcontent() {
        if (this.totalLength == 1) {
            return this.content[0];
        }
        byte[] ret = new byte[this.totalbyteLength];
        int idx = 0;
        int i = 0;
        while (i < this.totalLength) {
            if (this.content[i] != null && this.content[i].length > 0) {
                System.arraycopy(this.content[i], 0, ret, idx, this.content[i].length);
                idx += this.content[i].length;
            }
            ++i;
        }
        return ret;
    }

    public SmsDcs getMsgfmt() {
        return this.msgfmt;
    }

    public void setMsgfmt(SmsDcs msgfmt) {
        this.msgfmt = msgfmt;
    }

    public LongSMSMessage getMsg() {
        return this.msg;
    }

    public void setMsg(LongSMSMessage msg) {
        this.msg = msg;
    }
}

